package gr.uoa.di.driver.util;

import eu.dnetlib.api.DriverService;

/**
 * An implementation of the ServiceLocator that returns a predefined instance
 * of a service.
 * 
 * Can be used for debug purposes, FallBackLocator or when 2 services A and B 
 * are deployed in the same application (in this case, service A will get an 
 * instance of a StaticServiceLocator<B> in order to avoid calls to the IS and 
 * traversing the whole SOAP stack in order to communicate with B). 
 * 
 * @author <a href="mailto:antleb@di.uoa.gr">Antonis Lempesis</a>
 *
 * @param <S>
 */
public class StaticServiceLocator<S extends DriverService>
	implements ServiceLocator<S> {
	
	private S service = null;
	
	public StaticServiceLocator() {
		
	}

	public StaticServiceLocator(S service) {
		this.service = service;
	}
	
	@Override
	public S getService() {
		return service;
	}

	public void setService(S service) {
		this.service = service;
	}
}