package gr.uoa.di.driver.xml;

import java.io.StringReader;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;

import javax.xml.bind.JAXBException;

import org.xml.sax.InputSource;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.enabling.Vocabulary;
import eu.dnetlib.domain.enabling.VocabularySearchCriteria;
import gr.uoa.di.driver.xml.vocabulary.RESOURCEPROFILE;
import gr.uoa.di.driver.xml.vocabulary.TERMType;

public class VocabularyXmlConverter extends AbstractConverter<Vocabulary> implements
		ResourceToXmlConverter<Vocabulary> {
	
	public VocabularyXmlConverter() throws JAXBException {
		super(RESOURCEPROFILE.class);
	}
	
	public Vocabulary XmlToObject(String xml) throws JAXBException {
		RESOURCEPROFILE profile = (RESOURCEPROFILE) this.getUnmarshaller().unmarshal(new InputSource(new StringReader(xml)));
		Vocabulary vocabulary = null;

		TreeMap<String, String> nameMap = new TreeMap<String, String>();
		TreeMap<String, String> encodingMap = new TreeMap<String, String>();
		String vocabularyName = null;
		
		vocabularyName = profile.getBODY().getCONFIGURATION().getVOCABULARYNAME().getValue();

		List<TERMType> terms = profile.getBODY().getCONFIGURATION().getTERMS()
				.getTERM();
		for (TERMType term : terms) {
			nameMap.put(term.getEnglishName(), term.getCode());
			encodingMap.put(term.getCode(), term.getEnglishName());
		}

		vocabulary = new Vocabulary(vocabularyName, nameMap, encodingMap);

		vocabulary.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER()
				.getValue());
		vocabulary.setResourceKind(profile.getHEADER().getRESOURCEKIND()
				.getValue());
		vocabulary.setResourceType(profile.getHEADER().getRESOURCETYPE()
				.getValue());
		vocabulary.setResourceUri(profile.getHEADER().getRESOURCEURI()
				.getValue());

		if (profile.getHEADER().getDATEOFCREATION().getValue() != null)
			vocabulary.setDateOfCreation(new Date(profile.getHEADER().getDATEOFCREATION().getValue().getMillisecond()));

		return vocabulary;
	}

	public String toXQueryString(VocabularySearchCriteria criteria) {
		criteria = ConversionUtils.createProxy(criteria);
		
		String xQuery = null;
		String predicate = "";

		if (criteria.getName() != null) {
			predicate = "[lower-case(.)=\"" + criteria.getName().toLowerCase()
					+ "\"]";
		}

		xQuery = "for $x in collection(\"/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType\")";
		if (!predicate.equals("")) {
			xQuery += " where ";
			xQuery += " $x//CONFIGURATION/VOCABULARY_NAME " + predicate;
		}
		xQuery += " return $x";

		return xQuery;
	}

	// TODO implement this!!!
	public String ObjectToXml(Vocabulary object) throws JAXBException {
		throw new UnsupportedOperationException();
	}

	public String toXQueryString(SearchCriteria criteria) {
		return this.toXQueryString((VocabularySearchCriteria) criteria);
	}
}
