package gr.uoa.di.driver.enabling;

import eu.dnetlib.domain.enabling.Subscription;


/**
 * A thin client to the IS_SN service
 * @author christos
 *
 */
public interface ISSubscription {
	/**
	 * 
	 * @param subscription
	 * @return the subscription's id
	 * @throws SubscriptionException
	 */
	public String subscribe(Subscription subscription) throws SubscriptionException;
	
	/**
	 * 
	 * @param subscriptionId
	 * @param time
	 */
	public void renewSubscription(String subscriptionId, int time);

	/**
	 * 
	 * @param subscriptionId
	 */
	public void pauseNotifications(String subscriptionId);
	
	/**
	 * 
	 * @param subscriptionId
	 */
	public void resumeNotification(String subscriptionId);
	
	/**
	 * 
	 * @param subscriptionId
	 */
	public void removeSubscription(String subscriptionId);
}
