package gr.uoa.di.driver.dao;

import java.util.List;

import eu.dnetlib.domain.SearchCriteria;


/**
 * A class used to access a data source and perform basic actions. 
 * @author antleb@di.uoa.gr
 *
 * @param <T> The type of elements managed by this dao.
 */
public interface GenericDAO<T> {

    /**
     * Returns the element with the given id.
     * @param id The element's id.
     * @return the element with the given id.
     * @throws DAOException 
     */
    T getById(String  id) throws DAOException;

    /**
     * Saves the given element.
     * @param entity The element to save.
     * @return The same element with its id changed
     * @throws DAOException 
     */
    T save(T entity) throws DAOException;

    /**
     * Deletes the given element.
     * @param entity The element to delete.
     * @throws DAOException 
     */
    void delete(T entity) throws DAOException;
    
    /**
     * Returns all elements.
     * @return A ResultSetIterator with all of the elements.
     * @throws DAOException 
     */
    List<T> getAll() throws DAOException;
    
    /**
     * Returns all elements that comply with the restrictions described by the criteria
     * object.
     * @param criteria The searh criteria.
     * @return A ResultSetIterator with the results of the query.
     * @throws DAOException 
     */
    public List<T> search(SearchCriteria criteria) throws DAOException;
    
    /**
     * Performs a search and returns the unique result. Throws a DAOException if
     * there were more than one results.
     * @param criteria the search criteria;
     * @return the unique result of this query.
     * @throws DAOException If there was a problem in the search or there were
     * more than one results in the query.
     */
    public T getUniqueResult(SearchCriteria criteria) throws DAOException;
    
}