package gr.uoa.di.driver.enabling.islookup.cache;

import eu.dnetlib.domain.ActionType;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.Notification;
import gr.uoa.di.driver.enabling.issn.NotificationListener;

public class SecurityAwareCacheManager<D extends SecureDriverResource> extends
		DriverCacheManager<D> {

	public void init() {
		super.init();
		
		NotificationListener listener = new SecurityAwareCacheNotificationListener();
		
		service.subscribe(ActionType.CREATE, ResourceType.SECURITYPROFILEDSRESOURCETYPE, listener);
		service.subscribe(ActionType.UPDATE, ResourceType.SECURITYPROFILEDSRESOURCETYPE, listener);
		service.subscribe(ActionType.DELETE, ResourceType.SECURITYPROFILEDSRESOURCETYPE, listener);
	}
	
	private class SecurityAwareCacheNotificationListener extends CacheNotificationListener {

		@Override
		public void processNotification(Notification notification) {
			getIdCache().removeAll();
			getCriteriaCache().removeAll();
			
			super.processNotification(notification);
		}
		
	}
}