/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repos;

import eu.dnetlib.api.data.DatasourceManagerServiceException;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.repos.RepoApi;
import eu.dnetlib.repos.RepoTools;
import eu.dnetlib.repos.ehcacher.CacheProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"datasourceManagerServiceLocator"})
public class RepoApiCacheImpl
implements RepoApi {
    private static Logger logger = Logger.getLogger(RepoApiCacheImpl.class);
    private final String[] cacheKeys = new String[]{"opendoar", "re3data", "jour_aggr"};
    protected RepoApi coreRepoApi;
    private CacheProvider cacheProvider;

    @PostConstruct
    public void initCaches() {
        Thread initializingCachesThread = new Thread(){

            @Override
            public void run() {
                logger.info((Object)"initializing caches");
                boolean initialized = false;
                while (!initialized) {
                    for (String cacheKey : RepoApiCacheImpl.this.cacheKeys) {
                        try {
                            if (RepoApiCacheImpl.this.cacheProvider.getCache().isKeyInCache((Object)cacheKey)) continue;
                            File cacheBackup = new File("/tmp/cache-" + cacheKey + ".bak");
                            if (cacheBackup.exists()) {
                                logger.info((Object)("initializing key: " + cacheKey + " from disk"));
                                FileInputStream fis = new FileInputStream("/tmp/cache-" + cacheKey + ".bak");
                                ObjectInputStream ois = new ObjectInputStream(fis);
                                Map repositories = (Map)ois.readObject();
                                ois.close();
                                RepoApiCacheImpl.this.cacheProvider.getCache().put(new Element((Object)cacheKey, (Object)repositories));
                                continue;
                            }
                            logger.info((Object)("initializing key: " + cacheKey + " from dms"));
                            RepoApiCacheImpl.this.cacheProvider.getCache().get((Serializable)((Object)cacheKey)).getObjectValue();
                        }
                        catch (Exception e) {
                            logger.error((Object)("Error while initializing cache for key: " + cacheKey), (Throwable)e);
                            logger.info((Object)("initializing key: " + cacheKey + " from dms"));
                            RepoApiCacheImpl.this.cacheProvider.getCache().get((Serializable)((Object)cacheKey)).getObjectValue();
                        }
                    }
                    logger.info((Object)"caches initialized successfully");
                    initialized = true;
                }
            }
        };
        initializingCachesThread.setDaemon(true);
        initializingCachesThread.start();
    }

    @PreDestroy
    public void persistCaches() {
        logger.info((Object)"persisting caches");
        try {
            for (String cacheKey : this.cacheKeys) {
                FileOutputStream fos = new FileOutputStream("/tmp/cache-" + cacheKey + ".bak");
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                if (!this.cacheProvider.getCache().isKeyInCache((Object)cacheKey)) continue;
                logger.info((Object)("persisting cache: " + cacheKey));
                oos.writeObject((Map)this.cacheProvider.getCache().get((Serializable)((Object)cacheKey)).getObjectValue());
                oos.close();
            }
            logger.info((Object)"caches stored in disk");
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting caches", (Throwable)e);
            for (String cacheKey : this.cacheKeys) {
                File cacheBackup = new File("/tmp/cache-" + cacheKey + ".bak");
                if (!cacheBackup.exists()) continue;
                cacheBackup.delete();
            }
        }
    }

    @Override
    public Repository getRepository(String id) throws Exception {
        return this.getRepository(null, id);
    }

    @Override
    public Repository getRepository(String officialName, String id) throws Exception {
        logger.info((Object)("getting repository with name " + officialName + " and id: " + id + " from cache"));
        Repository retRepo = null;
        try {
            for (String cacheKey : this.cacheKeys) {
                if (!((Map)this.cacheProvider.getCache().get((Serializable)((Object)cacheKey)).getObjectValue()).containsKey(id)) continue;
                return (Repository)((Map)this.cacheProvider.getCache().get((Serializable)((Object)cacheKey)).getObjectValue()).get(id);
            }
            retRepo = this.coreRepoApi.getRepository(id);
        }
        catch (DatasourceManagerServiceException e) {
            logger.error((Object)("Error getting repository with name " + officialName + " and id: " + id + " from cache"), (Throwable)e);
        }
        return retRepo;
    }

    @Override
    public void getRepositoryStats(Repository repo) throws Exception {
        logger.info((Object)("getting repository stats for : " + repo.getOfficialName() + " from cache"));
        this.coreRepoApi.getRepositoryStats(repo);
    }

    @Override
    public String getListLatestUpdate(String mode) throws Exception {
        return this.coreRepoApi.getListLatestUpdate(mode);
    }

    @Override
    public String getNextScheduledExecution(String mode) throws Exception {
        return (String)((RepositoryInterface)this.coreRepoApi.getRepository("openaire____::" + mode).getInterfaces().get(0)).getExtraFields().get("last_collection_date");
    }

    @Override
    public String storeRepository(Repository repo, String datatype, List<RepositoryInterface> interfacesToRegister) throws Exception {
        String retMessage = null;
        logger.info((Object)("Storing " + datatype + " repository with id: " + repo.getId()));
        try {
            retMessage = this.coreRepoApi.storeRepository(repo, datatype, interfacesToRegister);
            this.forceUpdateCache(datatype, repo.getId());
        }
        catch (Exception e) {
            logger.error((Object)("Error storing repo " + repo.getOfficialName() + " in dms"), (Throwable)e);
            throw e;
        }
        return retMessage;
    }

    @Override
    public List<Repository> getRepositories(String collectedFrom) throws Exception {
        ArrayList<Repository> repoList = new ArrayList();
        try {
            logger.info((Object)("getting repos from cache with collected from value: " + collectedFrom));
            Map repoMap = (Map)this.cacheProvider.getCache().get((Serializable)((Object)collectedFrom)).getObjectValue();
            repoList = new ArrayList(repoMap.values());
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repos from cache with collected from value: " + collectedFrom), (Throwable)e);
            throw e;
        }
        return repoList;
    }

    @Override
    public Map<String, Repository> getRepositoriesAsMap(String collectedFrom) throws Exception {
        ArrayList repoList = new ArrayList();
        HashMap<String, Repository> repoMap = new HashMap();
        try {
            logger.info((Object)("getting repos from cache with collected from value: " + collectedFrom));
            repoMap = (Map)this.cacheProvider.getCache().get((Serializable)((Object)collectedFrom)).getObjectValue();
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repos from cache with collected from value: " + collectedFrom), (Throwable)e);
            throw e;
        }
        return repoMap;
    }

    @Override
    public List<Map<String, String>> getRegisteredReposByOthers(String user_mail) {
        List<Map<String, String>> res = new ArrayList<Map<String, String>>();
        try {
            logger.info((Object)("getting repos by others for user : " + user_mail));
            res = this.getRepositoriesOfUserAsMap(user_mail, true);
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repos by others for user : " + user_mail), (Throwable)e);
        }
        return res;
    }

    @Override
    public List<Map<String, String>> getRepositoriesOfUser(String user_mail) throws Exception {
        logger.info((Object)("getting repos for user : " + user_mail));
        return this.getRepositoriesOfUserAsMap(user_mail);
    }

    public List<Map<String, String>> getRepositoriesOfUserAsMap(String user_mail) throws Exception {
        logger.info((Object)("getting repos for user : " + user_mail));
        return this.getRepositoriesOfUserAsMap(user_mail, false);
    }

    private List<Map<String, String>> getRepositoriesOfUserAsMap(String user_mail, Boolean isAdmin) throws Exception {
        logger.info((Object)("getting repos as map for user: " + user_mail));
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>();
        try {
            for (Repository repo : this.getRepositoriesOfUser(user_mail, isAdmin)) {
                res.add(RepoTools.convertRepoToMap(repo));
            }
        }
        catch (Exception e) {
            logger.error((Object)("getting repos as map for user: " + user_mail), (Throwable)e);
        }
        return res;
    }

    @Override
    public TreeMap<String, List<Map<String, String>>> getRepositoriesByCountry(String collectedFrom) throws Exception {
        ArrayList<Repository> repoList = new ArrayList();
        TreeMap<String, List<Map<String, String>>> res = new TreeMap();
        try {
            logger.info((Object)("getting repos by country from cache with key: " + collectedFrom));
            Map repoMap = (Map)this.cacheProvider.getCache().get((Serializable)((Object)collectedFrom)).getObjectValue();
            repoList = new ArrayList(repoMap.values());
            res = RepoTools.splitReposByCountry(repoList);
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repositories from cache with key: " + collectedFrom), (Throwable)e);
            throw e;
        }
        return res;
    }

    @Override
    public Map<String, List<Repository>> getRepositoriesPerCountry(String collectedFrom) throws Exception {
        TreeMap<String, List<Repository>> res = new TreeMap();
        try {
            logger.info((Object)("getting repos by country from cache with key: " + collectedFrom));
            Map repoMap = (Map)this.cacheProvider.getCache().get((Serializable)((Object)collectedFrom)).getObjectValue();
            ArrayList<Repository> repoList = new ArrayList<Repository>(repoMap.values());
            res = RepoTools.splitReposPerCountry(repoList);
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repositories from cache with key: " + collectedFrom), (Throwable)e);
            throw e;
        }
        return res;
    }

    @Override
    public List<Repository> getRepositoriesOfCountry(String collectedFrom, String country) throws Exception {
        try {
            logger.info((Object)("getting repos for country " + country + " from cache with key: " + collectedFrom));
            return this.getRepositoriesPerCountry(collectedFrom).get(country);
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repos for country " + country + " from cache with key: " + collectedFrom), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<String, String> getRepoCompatibility(String officialName, String datasourceId) throws Exception {
        Map<String, String> compMap = null;
        try {
            logger.debug((Object)("getting repository " + officialName + " compatibility from cache"));
            compMap = this.getRepoCompatibility(officialName, datasourceId);
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repo " + officialName + " compatibility from cache"), (Throwable)e);
            throw e;
        }
        return compMap;
    }

    @Override
    public List<Repository> getReposByIds(List<String> datasourceIds) throws Exception {
        ArrayList<Repository> retRepos = new ArrayList<Repository>();
        try {
            logger.info((Object)"getting repos by ids from cache");
            for (String cacheKey : this.cacheKeys) {
                Map repoMap = (Map)this.cacheProvider.getCache().get((Serializable)((Object)cacheKey)).getObjectValue();
                ArrayList repoList = new ArrayList(repoMap.values());
                for (Repository rep : repoList) {
                    if (!datasourceIds.contains(rep.getId())) continue;
                    retRepos.add(rep);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"error getting repos by ids from cache", (Throwable)e);
        }
        return retRepos;
    }

    @Override
    public List<Repository> getRepositoriesOfUser(String user_mail, Boolean repoAdmin) throws SQLException {
        ArrayList<Repository> retRepos = new ArrayList<Repository>();
        try {
            if (!repoAdmin.booleanValue()) {
                logger.info((Object)("getting repositories registered by user: " + user_mail + " from cache"));
                for (String cacheKey : this.cacheKeys) {
                    Map repoMap = (Map)this.cacheProvider.getCache().get((Serializable)((Object)cacheKey)).getObjectValue();
                    ArrayList repoList = new ArrayList(repoMap.values());
                    for (Repository rep : repoList) {
                        if (!rep.getRegisteredBy().equalsIgnoreCase(user_mail) && !rep.getContactEmail().equalsIgnoreCase(user_mail)) continue;
                        retRepos.add(rep);
                    }
                }
            } else {
                logger.debug((Object)"getting journal /agreg  registered by others  from cache");
                Map repoMap = (Map)this.cacheProvider.getCache().get((Serializable)((Object)"jour_aggr")).getObjectValue();
                ArrayList repoList = new ArrayList(repoMap.values());
                for (Repository rep : repoList) {
                    if (rep.getRegisteredBy().equalsIgnoreCase(user_mail) || rep.getContactEmail().equalsIgnoreCase(user_mail)) continue;
                    retRepos.add(rep);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("error getting repositories registered by user: " + user_mail + " from cache"), (Throwable)e);
        }
        return retRepos;
    }

    @Override
    public boolean updateRepositoryInterfaceCompliance(String officialName, String datasourceId, String interfaceId, String desiredCompliance, String set, String baseUrl, String oldId) throws Exception {
        boolean ret;
        try {
            ret = this.coreRepoApi.updateRepositoryInterfaceCompliance(officialName, datasourceId, interfaceId, desiredCompliance, set, baseUrl, oldId);
            this.forceUpdateCache(null, datasourceId);
        }
        catch (Exception e) {
            logger.error((Object)("error connecting to dms to set a repo interface as openaire compliant " + officialName), (Throwable)e);
            throw e;
        }
        return ret;
    }

    @Override
    public boolean insertPubFileInterface(String dsId, RepositoryInterface iFace) throws Exception {
        boolean ret = false;
        try {
            logger.info((Object)("storing pdf interface for repository: " + dsId));
            ret = this.coreRepoApi.insertPubFileInterface(dsId, iFace);
            this.forceUpdateCache(null, dsId);
        }
        catch (Exception e) {
            logger.error((Object)("error storing pdf interface for repository: " + dsId), (Throwable)e);
            throw e;
        }
        return ret;
    }

    @Override
    public boolean updatePubFileInterface(String dsId, RepositoryInterface iFace) throws Exception {
        boolean ret;
        try {
            logger.info((Object)("updating pdf interface for repository: " + dsId));
            ret = this.coreRepoApi.updatePubFileInterface(dsId, iFace);
            this.forceUpdateCache(null, dsId);
        }
        catch (Exception e) {
            logger.error((Object)("error updating pdf interface for repository: " + dsId), (Throwable)e);
            throw e;
        }
        return ret;
    }

    @Override
    public List<String> getUrlsOfRepos(String user_mail, Boolean repoAdmin) throws Exception {
        ArrayList<String> urls = new ArrayList<String>();
        try {
            logger.info((Object)("getting url from repositories registered by user: " + user_mail + " from cache"));
            for (Repository repo : this.getRepositoriesOfUser(user_mail, repoAdmin)) {
                for (RepositoryInterface iFace : repo.getInterfaces()) {
                    if (!iFace.getContentDescription().equalsIgnoreCase("metadata") || iFace.getBaseUrl() == null || iFace.getBaseUrl().isEmpty() || urls.contains(iFace.getBaseUrl()) || !iFace.getAccessProtocol().equalsIgnoreCase("oai")) continue;
                    urls.add(iFace.getBaseUrl());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("error getting url from repositories registered by user: " + user_mail + " from cache"), (Throwable)e);
            throw e;
        }
        return urls;
    }

    @Override
    public String editRepository(Repository repo, String officialNameOld, String idOld, String datatype) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean repoIsCompliant(String officialName) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String updateRepositoryInformation(Repository repo) throws Exception {
        String retMessage = "";
        try {
            logger.info((Object)"updating repository information");
            this.coreRepoApi.updateRepositoryInformation(repo);
            this.forceUpdateCache(repo.getDatasourceType(), repo.getId());
        }
        catch (Exception e) {
            logger.error((Object)"error updating repository information", (Throwable)e);
            throw e;
        }
        return retMessage;
    }

    @Override
    public String deleteRepositoryInterfaces(String dsId, List<RepositoryInterface> interfaces) throws Exception {
        String retMessage = "";
        try {
            logger.info((Object)"deleting repository interfaces");
            retMessage = this.coreRepoApi.deleteRepositoryInterfaces(dsId, interfaces);
        }
        catch (Exception e) {
            logger.error((Object)"error deleting repository interfaces", (Throwable)e);
            throw e;
        }
        return retMessage;
    }

    @Override
    public void deleteRepositoryInterfacesWithoutChecks(String dsId, List<RepositoryInterface> interfaces, String datatype) throws Exception {
        try {
            logger.info((Object)"deleting repository interfaces without checks");
            this.coreRepoApi.deleteRepositoryInterfacesWithoutChecks(dsId, interfaces, datatype);
            this.forceUpdateCache(datatype, dsId);
        }
        catch (Exception e) {
            logger.error((Object)"error deleting repository interfaces", (Throwable)e);
            throw e;
        }
    }

    @Override
    public String updateRepositoryInterfaces(String dsId, List<RepositoryInterface> interfaces, List<RepositoryInterface> interfacesOld, String datatype, List<RepositoryInterface> interfacesToRegister) throws Exception {
        String importResult = "";
        try {
            logger.info((Object)("updating repository interfaces for datasource: " + dsId));
            importResult = this.coreRepoApi.updateRepositoryInterfaces(dsId, interfaces, interfacesOld, datatype, interfacesToRegister);
            this.forceUpdateCache(datatype, dsId);
            logger.debug((Object)("import result final: " + importResult));
        }
        catch (Exception e) {
            logger.error((Object)("error updating repository interfaces for datasource: " + dsId), (Throwable)e);
            throw e;
        }
        return importResult;
    }

    @Override
    public RepositoryInterface updateRepositoryInterfaceWithoutChecks(String dsId, RepositoryInterface iFace, String datatype) throws Exception {
        RepositoryInterface retIface;
        try {
            logger.info((Object)("updating repository interface for datasource: " + dsId));
            retIface = this.coreRepoApi.updateRepositoryInterfaceWithoutChecks(dsId, iFace, datatype);
            this.forceUpdateCache(datatype, dsId);
        }
        catch (Exception e) {
            logger.error((Object)("error updating repository interface for datasource: " + dsId), (Throwable)e);
            throw e;
        }
        return retIface;
    }

    @Override
    public String insertRepositoryInterfaces(String dsId, List<RepositoryInterface> interfaces, List<RepositoryInterface> interfacesOld, String datatype, List<RepositoryInterface> interfacesToRegister) throws Exception {
        String importResult = "";
        try {
            logger.info((Object)("inserting repository interfaces for datasource: " + dsId));
            importResult = this.coreRepoApi.insertRepositoryInterfaces(dsId, interfaces, interfacesOld, datatype, interfacesToRegister);
            this.forceUpdateCache(datatype, dsId);
        }
        catch (Exception e) {
            logger.error((Object)("error inserting repository interfaces for datasource: " + dsId), (Throwable)e);
            throw e;
        }
        return importResult;
    }

    @Override
    public RepositoryInterface insertRepositoryInterfaceWithoutChecks(String dsId, RepositoryInterface iFace, String datatype) throws Exception {
        RepositoryInterface retIface;
        try {
            retIface = this.coreRepoApi.updateRepositoryInterfaceWithoutChecks(dsId, iFace, datatype);
            this.forceUpdateCache(datatype, dsId);
        }
        catch (Exception e) {
            logger.error((Object)("error inserting repository interface for datasource: " + dsId), (Throwable)e);
            throw e;
        }
        return retIface;
    }

    @Override
    public boolean unregisterRepository(Repository repo) throws Exception {
        boolean ret;
        logger.info((Object)("unregistering repository " + repo.getOfficialName()));
        try {
            ret = this.unregisterRepository(repo);
            this.forceUpdateCache(repo.getDatasourceType(), repo.getId());
        }
        catch (Exception e) {
            logger.error((Object)("Error unregistering repository " + repo.getOfficialName()), (Throwable)e);
            return false;
        }
        return ret;
    }

    private void printInterface(RepositoryInterface iFace) {
        logger.debug((Object)("baseUrl: " + iFace.getBaseUrl()));
        logger.debug((Object)("format: " + iFace.getAccessFormat()));
        logger.debug((Object)("typology: " + iFace.getTypology()));
        logger.debug((Object)("set: " + iFace.getAccessSet()));
        logger.debug((Object)("des_comp_level: " + iFace.getDesiredCompatibilityLevel()));
        logger.debug((Object)("cur_comp_level: " + iFace.getCompliance()));
        logger.debug((Object)("protocol: " + iFace.getAccessProtocol()));
        logger.debug((Object)("api_id: " + iFace.getId()));
        logger.debug((Object)("removable: " + iFace.isRemovable()));
        logger.debug((Object)("deleteApi: " + iFace.isDeleteApi()));
    }

    private void forceUpdateCache(final String datatype, final String repoId) {
        Thread updatingThread = new Thread(){

            @Override
            public void run() {
                logger.info((Object)("Updating cache for key: " + datatype + " after adding/editing repository"));
                try {
                    String key = "";
                    if (datatype == null) {
                        for (String cacheKey : RepoApiCacheImpl.this.cacheKeys) {
                            if (!((Map)RepoApiCacheImpl.this.cacheProvider.getCache().get((Serializable)((Object)cacheKey)).getObjectValue()).containsKey(repoId)) continue;
                            key = cacheKey;
                            break;
                        }
                    } else {
                        key = datatype;
                        if (datatype.equalsIgnoreCase("journal") || datatype.equalsIgnoreCase("aggregator")) {
                            key = "jour_aggr";
                        }
                    }
                    Map oldMap = (Map)RepoApiCacheImpl.this.cacheProvider.getCache().get((Serializable)((Object)key)).getObjectValue();
                    oldMap.put(repoId, RepoApiCacheImpl.this.coreRepoApi.getRepository(repoId));
                    RepoApiCacheImpl.this.cacheProvider.getCache().replace(new Element((Object)key, (Object)oldMap), new Element((Object)key, (Object)oldMap));
                    logger.info((Object)"cache updated");
                }
                catch (Exception e) {
                    logger.error((Object)"Error while updating cache. Retry in 250000min", (Throwable)e);
                    try {
                        Thread.sleep(250000L);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"Error while updating cache", (Throwable)e1);
                    }
                }
            }
        };
        updatingThread.setDaemon(true);
        updatingThread.start();
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public RepoApi getCoreRepoApi() {
        return this.coreRepoApi;
    }

    public void setCoreRepoApi(RepoApi coreRepoApi) {
        this.coreRepoApi = coreRepoApi;
    }
}

