/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.data.browsedata;

import eu.dnetlib.domain.data.BrowseData;
import java.io.StringReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BrowseDataUtil {
    static XPathExpression FIELD_EXPR = null;
    static XPathExpression VALUE_EXPR = null;
    static XPathExpression COUNT_EXPR = null;
    static XPathExpression GROUP_RESULT_EXPR = null;
    static Logger logger;

    private static InputSource source(String message) {
        return new InputSource(new StringReader(message));
    }

    private static String parseString(String record, XPathExpression expr) {
        String result = null;
        try {
            result = (String)expr.evaluate(BrowseDataUtil.source(record), XPathConstants.STRING);
        }
        catch (XPathExpressionException xpee) {
            logger.error((Object)("Cannot parse record " + record.replaceAll("\n", " ")), (Throwable)xpee);
        }
        return result;
    }

    public static BrowseData parseRows(String record) {
        logger.debug((Object)("Record " + record));
        record = record.replaceAll("\n", "");
        BrowseData bd = new BrowseData();
        try {
            NodeList nodes = (NodeList)GROUP_RESULT_EXPR.evaluate(BrowseDataUtil.source(record), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String field = node.getAttributes().getNamedItem("field").getTextContent();
                int count = 0;
                String value = null;
                for (int j = 0; j < node.getChildNodes().getLength(); ++j) {
                    Node child = node.getChildNodes().item(j);
                    if (child.getNodeType() == 3) continue;
                    if (child.getLocalName().toLowerCase().equals("count")) {
                        count = Integer.parseInt(child.getTextContent());
                        continue;
                    }
                    if (!child.getLocalName().toLowerCase().equals("value")) continue;
                    value = child.getTextContent();
                }
                bd.addFieldEntry(field, value, count);
            }
        }
        catch (XPathExpressionException e) {
            logger.warn((Object)"Error parsing index row.", (Throwable)e);
        }
        return bd;
    }

    public static String parseField(String record) {
        return BrowseDataUtil.parseString(record, FIELD_EXPR);
    }

    public static String parseValue(String record) {
        return BrowseDataUtil.parseString(record, VALUE_EXPR);
    }

    public static int parseCount(String record) {
        String text = BrowseDataUtil.parseString(record, COUNT_EXPR);
        int count = 0;
        try {
            count = Integer.parseInt(text);
        }
        catch (NumberFormatException nfe) {
            logger.error((Object)("Expected number in count, but found: " + text), (Throwable)nfe);
        }
        return count;
    }

    static {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            FIELD_EXPR = xpath.compile("//groupresult/@field");
            VALUE_EXPR = xpath.compile("//value");
            COUNT_EXPR = xpath.compile("//count");
            GROUP_RESULT_EXPR = xpath.compile("//groupresult");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Failed to build xpath expression.", e);
        }
        logger = Logger.getLogger(BrowseDataUtil.class);
    }
}

