/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.islookup.cache;

import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.SearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.enabling.islookup.cache.CriteriaCacheKey;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;

public class CachingISLookUp<D extends DriverResource>
implements ISLookUp<D> {
    static Logger logger = Logger.getLogger(CachingISLookUp.class);
    private Ehcache criteriaCache = null;
    private Ehcache idCache = null;
    private ResourceToXmlConverter<D> converter = null;
    private ServiceLocator<ISLookUpService> lookupLocator = null;

    @Override
    public D getById(String id) throws ISLookUpException {
        logger.debug((Object)("Requested object with id " + id));
        String key = id;
        Element element = this.idCache.get((Serializable)((Object)key));
        if (element != null) {
            return this.parseXml((String)element.getObjectValue());
        }
        return null;
    }

    @Override
    public List<D> getByid(String[] ids) throws ISLookUpException {
        ArrayList<D> list = new ArrayList<D>();
        for (String id : ids) {
            list.add(this.getById(id));
        }
        return list;
    }

    @Override
    public List<D> fetch(SearchCriteria criteria) throws ISLookUpException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetching results for query: " + this.converter.toXQueryString(criteria)));
        }
        CriteriaCacheKey key = new CriteriaCacheKey(criteria);
        key.setXQuery(this.converter.toXQueryString(criteria));
        Element element = this.criteriaCache.get((Object)key);
        List xmls = (List)element.getObjectValue();
        return this.processSearchResults(xmls);
    }

    private List<D> processSearchResults(List<String> xmls) {
        ArrayList<D> result = new ArrayList<D>();
        for (String xml : xmls) {
            D d = this.parseXml(xml);
            this.updateIdCache(d.getResourceId(), xml);
            result.add(d);
        }
        return result;
    }

    private D parseXml(String xml) {
        try {
            return (D)((DriverResource)this.converter.XmlToObject(xml));
        }
        catch (JAXBException je) {
            logger.error((Object)"Error parsing xml profile", (Throwable)je);
            return null;
        }
    }

    private void updateIdCache(String id, String xml) {
        Element e = new Element((Serializable)((Object)id), (Serializable)((Object)xml));
        this.idCache.put(e);
    }

    @Override
    public List<D> performQuickSearch(SearchCriteria criteria) throws ISLookUpException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing quick search for query: " + this.converter.toXQueryString(criteria)));
        }
        CriteriaCacheKey key = new CriteriaCacheKey(criteria);
        key.setXQuery(this.converter.toXQueryString(criteria));
        Element element = this.criteriaCache.get((Object)key);
        return this.processSearchResults((List)element.getObjectValue());
    }

    @Override
    public List<String> fetch(String XQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public D getUniqueResult(SearchCriteria criteria) throws ISLookUpException {
        List<D> list;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Fetching unique result for query: " + this.converter.toXQueryString(criteria)));
        }
        if ((list = this.performQuickSearch(criteria)).size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (D)((DriverResource)list.get(0));
        }
        throw new ISLookUpException("More than one results in query");
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public void setConverter(ResourceToXmlConverter<D> converter) {
        this.converter = converter;
    }

    public void setCriteriaCache(Ehcache criteriaCache) {
        this.criteriaCache = criteriaCache;
    }

    public void setIdCache(Ehcache idCache) {
        this.idCache = idCache;
    }
}

