/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.islookup.cache;

import eu.dnetlib.domain.ActionType;
import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.domain.enabling.SecurityProfileSearchCriteria;
import gr.uoa.di.driver.app.DriverServiceImpl;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.enabling.islookup.cache.CriteriaCacheKey;
import gr.uoa.di.driver.enabling.issn.NotificationListener;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;

public class DriverCacheManager<D extends DriverResource> {
    private Logger logger = Logger.getLogger(DriverCacheManager.class);
    private ResourceType resourceType = null;
    protected DriverServiceImpl service = null;
    private Ehcache idCache = null;
    private Ehcache criteriaCache = null;
    private ResourceToXmlConverter<D> converter = null;
    private ISLookUp<SecurityProfile> securityLookUp = null;
    private Comparator<D> comparator = null;

    public void init() {
        this.logger.debug((Object)("Initializing cache manager for object type " + this.resourceType));
        CacheNotificationListener listener = new CacheNotificationListener();
        this.service.subscribe(ActionType.CREATE, this.resourceType, listener);
        this.service.subscribe(ActionType.UPDATE, this.resourceType, listener);
        this.service.subscribe(ActionType.DELETE, this.resourceType, listener);
    }

    private void processCreationEvent(Notification notification) {
        try {
            this.logger.debug((Object)"processing creation event");
            String xml = notification.getResource();
            DriverResource object = (DriverResource)this.converter.XmlToObject(xml);
            String objectId = object.getResourceId();
            this.logger.debug((Object)("adding object with id: " + objectId));
            if (object instanceof SecureDriverResource) {
                SecurityProfile secProfile = this.getSecurityProfile(object.getResourceId());
                ((SecureDriverResource)object).setSecurityProfile(secProfile);
            }
            this.idCache.put(new Element((Serializable)((Object)objectId), (Serializable)((Object)xml)));
            this.evaluateQueries(xml, object);
            this.logger.debug((Object)"Done processing create event");
        }
        catch (JAXBException je) {
            this.logger.error((Object)"Error processing create event", (Throwable)je);
        }
        catch (ISLookUpException ile) {
            this.logger.error((Object)"Error processing create event", (Throwable)ile);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing create event", (Throwable)e);
        }
    }

    private void processUpdateEvent(Notification notification) {
        try {
            this.logger.debug((Object)"processing update event");
            String xml = notification.getResource();
            DriverResource object = (DriverResource)this.converter.XmlToObject(xml);
            if (object instanceof SecureDriverResource) {
                this.logger.debug((Object)"profile has security profile");
                SecurityProfile secProfile = this.getSecurityProfile(object.getResourceId());
                ((SecureDriverResource)object).setSecurityProfile(secProfile);
            }
            this.idCache.put(new Element((Serializable)((Object)object.getResourceId()), (Serializable)((Object)xml)));
            this.evaluateQueries(xml, object);
            this.logger.debug((Object)"Done processing update event");
        }
        catch (JAXBException je) {
            this.logger.error((Object)"Error processing update event", (Throwable)je);
        }
        catch (ISLookUpException ile) {
            this.logger.error((Object)"Error processing update event", (Throwable)ile);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing update event", (Throwable)e);
        }
    }

    private SecurityProfile getSecurityProfile(String profileId) throws ISLookUpException {
        this.logger.debug((Object)"Getting sec profile from IS.");
        SecurityProfileSearchCriteria crit = new SecurityProfileSearchCriteria();
        crit.getDriverResourceIds().add(profileId);
        return this.securityLookUp.getUniqueResult((SearchCriteria)crit);
    }

    private void processDeletionEvent(Notification notification) {
        try {
            this.logger.debug((Object)"processing deletion event...");
            DriverResource object = (DriverResource)this.converter.XmlToObject(notification.getResource());
            String profileId = object.getResourceId();
            this.logger.debug((Object)("removing object with id: " + profileId));
            this.idCache.remove((Serializable)((Object)profileId));
            for (Object key : this.criteriaCache.getKeysWithExpiryCheck()) {
                CriteriaCacheKey cacheKey = (CriteriaCacheKey)key;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("checking query: " + cacheKey.getXQuery()));
                }
                List results = (List)this.criteriaCache.get(key).getObjectValue();
                Iterator iter = results.iterator();
                while (iter.hasNext()) {
                    String xml = (String)iter.next();
                    DriverResource result = (DriverResource)this.converter.XmlToObject(xml);
                    this.logger.debug((Object)("comparing with result: " + result.getResourceId()));
                    if (!result.getResourceId().equals(profileId)) continue;
                    this.logger.debug((Object)"object found in results. removing...");
                    iter.remove();
                }
            }
        }
        catch (JAXBException e) {
            this.logger.error((Object)"Error processing deletion event", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error processing deletion event", (Throwable)e);
        }
        this.logger.debug((Object)"Done processing deletion event");
    }

    private void evaluateQueries(String xml, D object) throws JAXBException {
        String objectId = object.getResourceId();
        List queries = this.criteriaCache.getKeysWithExpiryCheck();
        this.logger.debug((Object)("Will evaluate " + queries.size() + " query(ies)"));
        for (int i = 0; i < queries.size(); ++i) {
            CriteriaCacheKey key = (CriteriaCacheKey)queries.get(i);
            SearchCriteria criteria = key.getCriteria();
            List results = (List)this.criteriaCache.get((Object)key).getObjectValue();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("testing query: " + key.getXQuery()));
            }
            for (int j = 0; j < results.size(); ++j) {
                String cachedXml = (String)results.get(j);
                DriverResource result = (DriverResource)this.converter.XmlToObject(cachedXml);
                String resultId = result.getResourceId();
                this.logger.debug((Object)("comparing with: " + resultId));
                if (!objectId.equals(resultId)) continue;
                this.logger.debug((Object)"result found. Removing it");
                results.remove(j);
                break;
            }
            try {
                if (criteria.matches(object)) {
                    this.logger.debug((Object)"results matches. adding it.");
                    results.add(xml);
                    if (this.comparator == null) continue;
                    ArrayList<CacheEntryPair> pairList = new ArrayList<CacheEntryPair>();
                    for (String cachedXml : results) {
                        pairList.add(new CacheEntryPair(this, cachedXml, (DriverResource)this.converter.XmlToObject(cachedXml)));
                    }
                    Collections.sort(pairList, new CacheEntryPairComparator(this.comparator));
                    results.clear();
                    for (CacheEntryPair pair : pairList) {
                        results.add(pair.xml);
                    }
                    continue;
                }
                this.logger.debug((Object)"Object doesn't match query. Will not add");
                continue;
            }
            catch (UnsupportedOperationException uoe) {
                this.logger.warn((Object)"Search criteria have not implememented 'matches' method. Clearing query cache");
                this.criteriaCache.removeAll();
                break;
            }
            catch (Exception e) {
                this.logger.error((Object)"Error updating queries", (Throwable)e);
            }
        }
        this.logger.debug((Object)"Done evaluating queries");
    }

    public void setConverter(ResourceToXmlConverter<D> converter) {
        this.converter = converter;
    }

    public void setIdCache(Ehcache idCache) {
        this.idCache = idCache;
    }

    public Ehcache getIdCache() {
        return this.idCache;
    }

    public void setSecurityLookUp(ISLookUp<SecurityProfile> securityLookUp) {
        this.securityLookUp = securityLookUp;
    }

    public void setComparator(Comparator<D> comparator) {
        this.comparator = comparator;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public Ehcache getCriteriaCache() {
        return this.criteriaCache;
    }

    public void setCriteriaCache(Ehcache criteriaCache) {
        this.criteriaCache = criteriaCache;
    }

    public void setService(DriverServiceImpl service) {
        this.service = service;
    }

    protected class CacheNotificationListener
    implements NotificationListener {
        protected CacheNotificationListener() {
        }

        @Override
        public void processNotification(Notification notification) {
            try {
                if (notification.getResourceType().equals((Object)DriverCacheManager.this.resourceType)) {
                    switch (notification.getActionType()) {
                        case CREATE: {
                            DriverCacheManager.this.processCreationEvent(notification);
                            break;
                        }
                        case UPDATE: {
                            DriverCacheManager.this.processUpdateEvent(notification);
                            break;
                        }
                        case DELETE: {
                            DriverCacheManager.this.processDeletionEvent(notification);
                        }
                    }
                }
            }
            catch (Exception e) {
                DriverCacheManager.this.logger.error((Object)"Error updating cache", (Throwable)e);
            }
        }
    }

    private class CacheEntryPairComparator
    implements Comparator<CacheEntryPair> {
        private Comparator<D> comparator = null;

        public CacheEntryPairComparator(Comparator<D> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(CacheEntryPair o1, CacheEntryPair o2) {
            return this.comparator.compare(o1.d, o2.d);
        }
    }

    private static class CacheEntryPair {
        private String xml = null;
        private D d = null;
        final /* synthetic */ DriverCacheManager this$0;

        public CacheEntryPair(String xml, D d) {
            this.this$0 = var1_1;
            this.xml = xml;
            this.d = d;
        }
    }
}

