/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.resultset;

import eu.dnetlib.api.enabling.ResultSetService;
import eu.dnetlib.api.enabling.ResultSetServiceException;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.util.ObjectToXmlConverter;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class ResultSetImpl<D>
implements ResultSet<D> {
    static Logger logger = Logger.getLogger(ResultSetImpl.class);
    private EPR epr = null;
    static ObjectToXmlConverter<String> dummyConverter = new ObjectToXmlConverter<String>(){

        @Override
        public String XmlToObject(String xml) throws JAXBException {
            return xml;
        }

        @Override
        public String ObjectToXml(String object) throws JAXBException {
            return object;
        }
    };
    private String identifier = null;
    private ObjectToXmlConverter<D> converter = null;
    private ResultSetService rsService = null;

    public ResultSetImpl(ResultSetService rsService, String rsIdentifier) {
        this(rsService, rsIdentifier, dummyConverter);
    }

    public ResultSetImpl(ResultSetService rsService, String rsIdentifier, ObjectToXmlConverter<D> converter) {
        this.identifier = rsIdentifier;
        this.converter = converter;
        this.rsService = rsService;
    }

    @Override
    public boolean isOpen() {
        boolean open = false;
        try {
            String status = this.rsService.getRSStatus(this.identifier);
            open = status.toLowerCase().equals("open");
        }
        catch (ResultSetServiceException e) {
            logger.warn((Object)"Result Set Error.", (Throwable)e);
        }
        return open;
    }

    @Override
    public boolean isAlive() {
        try {
            this.rsService.getNumberOfElements(this.identifier);
        }
        catch (ResultSetServiceException rsse) {
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.rsService.closeRS(this.identifier);
    }

    @Override
    public int size() {
        int size = 0;
        try {
            size = this.rsService.getNumberOfElements(this.identifier);
        }
        catch (ResultSetServiceException e) {
            logger.warn((Object)"Result Set Error.", (Throwable)e);
        }
        return size;
    }

    @Override
    public List<String> getElements(int from, int to) {
        List elements = null;
        try {
            elements = this.rsService.getResult(this.identifier, from, to, "waiting");
        }
        catch (ResultSetServiceException e) {
            logger.warn((Object)"Result Set Error.", (Throwable)e);
        }
        return elements;
    }

    @Override
    public List<D> get(int from, int to) {
        List<String> elements = this.getElements(from, to);
        ArrayList<D> list = null;
        if (elements != null) {
            list = new ArrayList<D>(elements.size());
            for (String element : elements) {
                try {
                    D d = this.converter.XmlToObject(element);
                    list.add(d);
                }
                catch (JAXBException e) {
                    logger.warn((Object)("Error converting element: " + element));
                }
            }
        }
        return list;
    }

    @Override
    public EPR getEpr() {
        return this.epr;
    }

    public void setEpr(EPR epr) {
        this.epr = epr;
    }
}

