/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.resultset;

import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.domain.enabling.SecurityProfileSearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SecurityAwareResultSet<D extends SecureDriverResource>
implements ResultSet<D> {
    private Logger logger = Logger.getLogger(SecurityAwareResultSet.class);
    private ResultSet<D> resultSet = null;
    private ISLookUp<SecurityProfile> securityLookUp = null;

    @Override
    public void close() {
        this.resultSet.close();
    }

    @Override
    public List<D> get(int from, int to) {
        List<D> list = this.resultSet.get(from, to);
        try {
            Map<String, SecurityProfile> secProfiles = this.getSecurityProfiles(list);
            for (SecureDriverResource d : list) {
                SecurityProfile secProfile = secProfiles.get(d.getResourceId());
                d.setSecurityProfile(secProfile);
            }
        }
        catch (ISLookUpException e) {
            this.logger.error((Object)"Error getting security profiles for resources");
        }
        return list;
    }

    @Override
    public List<String> getElements(int from, int to) {
        return this.resultSet.getElements(from, to);
    }

    @Override
    public boolean isAlive() {
        return this.resultSet.isAlive();
    }

    @Override
    public boolean isOpen() {
        return this.resultSet.isOpen();
    }

    @Override
    public int size() {
        return this.resultSet.size();
    }

    public void setSecurityLookUp(ISLookUp<SecurityProfile> securityLookUp) {
        this.securityLookUp = securityLookUp;
    }

    public void setResultSet(ResultSet<D> resultSet) {
        this.resultSet = resultSet;
    }

    private Map<String, SecurityProfile> getSecurityProfiles(List<D> profiles) throws ISLookUpException {
        SecurityProfileSearchCriteria crit = new SecurityProfileSearchCriteria();
        HashMap<String, SecurityProfile> map = new HashMap<String, SecurityProfile>();
        for (SecureDriverResource d : profiles) {
            crit.getDriverResourceIds().add(d.getResourceId());
        }
        for (SecurityProfile secProfile : this.securityLookUp.fetch((SearchCriteria)crit)) {
            map.put(secProfile.getDriverResourceId(), secProfile);
        }
        return map;
    }

    @Override
    public EPR getEpr() {
        return this.resultSet.getEpr();
    }
}

