/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.xml;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.functionality.DocumentDescription;
import eu.dnetlib.domain.functionality.DocumentExternalUrlDisplayType;
import eu.dnetlib.domain.functionality.DocumentField;
import eu.dnetlib.domain.functionality.ExternalUrlDisplayType;
import eu.dnetlib.domain.functionality.InternalUrlDisplayType;
import eu.dnetlib.domain.functionality.PlainTextDisplayType;
import eu.dnetlib.domain.functionality.SearchDisplayType;
import eu.dnetlib.domain.functionality.Searchable;
import eu.dnetlib.domain.functionality.SearchableDate;
import eu.dnetlib.domain.functionality.SwitchDocumentField;
import eu.dnetlib.domain.functionality.WebInterfaceLayout;
import eu.dnetlib.domain.functionality.WebInterfaceSearchCriteria;
import gr.uoa.di.driver.xml.AbstractConverter;
import gr.uoa.di.driver.xml.ConversionUtils;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import gr.uoa.di.driver.xml.webinterfacelayout.CutpointType;
import gr.uoa.di.driver.xml.webinterfacelayout.DisplayListType;
import gr.uoa.di.driver.xml.webinterfacelayout.DisplayType;
import gr.uoa.di.driver.xml.webinterfacelayout.DisplayTypeType;
import gr.uoa.di.driver.xml.webinterfacelayout.DocumentDescriptionType;
import gr.uoa.di.driver.xml.webinterfacelayout.DocumentFieldListType;
import gr.uoa.di.driver.xml.webinterfacelayout.DocumentFieldType;
import gr.uoa.di.driver.xml.webinterfacelayout.MapEntryType;
import gr.uoa.di.driver.xml.webinterfacelayout.MapMapEntryType;
import gr.uoa.di.driver.xml.webinterfacelayout.MapType;
import gr.uoa.di.driver.xml.webinterfacelayout.ObjectFactory;
import gr.uoa.di.driver.xml.webinterfacelayout.RESOURCEPROFILE;
import gr.uoa.di.driver.xml.webinterfacelayout.SEARCHABLEType;
import gr.uoa.di.driver.xml.webinterfacelayout.SUPPORTEDLOCALEType;
import gr.uoa.di.driver.xml.webinterfacelayout.SearchableTypeType;
import gr.uoa.di.driver.xml.webinterfacelayout.SwitchType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class WebInterfaceLayoutXmlConverter
extends AbstractConverter<WebInterfaceLayout>
implements ResourceToXmlConverter<WebInterfaceLayout> {
    static Logger logger = Logger.getLogger(WebInterfaceLayoutXmlConverter.class);
    private ObjectFactory of = new ObjectFactory();

    public WebInterfaceLayoutXmlConverter() throws JAXBException {
        super(RESOURCEPROFILE.class, DocumentDescriptionType.class);
    }

    @Override
    public String ObjectToXml(WebInterfaceLayout layout) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RESOURCEPROFILE profile = this.of.createRESOURCEPROFILE();
        profile.setHEADER(this.of.createHEADERType());
        profile.setBODY(this.of.createBODYType());
        profile.getBODY().setCONFIGURATION(this.of.createCONFIGURATIONType());
        profile.getHEADER().setRESOURCEIDENTIFIER(this.of.createRESOURCEIDENTIFIERType());
        profile.getHEADER().setRESOURCEKIND(this.of.createRESOURCEKINDType());
        profile.getHEADER().setRESOURCETYPE(this.of.createRESOURCETYPEType());
        profile.getHEADER().setRESOURCEURI(this.of.createRESOURCEURIType());
        profile.getHEADER().setDATEOFCREATION(this.of.createDATEOFCREATIONType());
        this.setXmlHeader(profile, layout);
        this.setXmlBody(layout, profile);
        this.getMarshaller().marshal((Object)profile, (OutputStream)baos);
        return baos.toString();
    }

    private void setXmlBody(WebInterfaceLayout layout, RESOURCEPROFILE profile) {
        profile.getBODY().getCONFIGURATION().setNAME(layout.getName());
        profile.getBODY().getCONFIGURATION().setMDFORMATNAME(layout.getMdFormatName());
        profile.getBODY().getCONFIGURATION().setINDEXLAYOUTNAME(layout.getIndexLayoutName());
        profile.getBODY().setCSSFILE(layout.getCssFile());
        profile.getBODY().setSUPPORTEDLOCALES(this.of.createSuportedLocalesListType());
        Locale defaultLocale = layout.getDefaultLocale();
        SUPPORTEDLOCALEType sltype = this.of.createSUPPORTEDLOCALEType();
        sltype.setDEFAULT(true);
        sltype.setLOCALE(defaultLocale.getLanguage() + "_" + defaultLocale.getCountry());
        profile.getBODY().getSUPPORTEDLOCALES().getSUPPORTEDLOCALE().add(sltype);
        for (Locale slocale : layout.getSupportedLocales()) {
            sltype = this.of.createSUPPORTEDLOCALEType();
            sltype.setDEFAULT(false);
            sltype.setLOCALE(slocale.getLanguage() + "_" + slocale.getCountry());
            profile.getBODY().getSUPPORTEDLOCALES().getSUPPORTEDLOCALE().add(sltype);
        }
        profile.getBODY().setSEARCHABLES(this.of.createSEARCHABLESType());
        for (Searchable s : layout.getSearchFields()) {
            SEARCHABLEType stype = new SEARCHABLEType();
            stype.setNAME(s.getName());
            stype.setHidden(s.isHidden());
            if (s instanceof SearchableDate) {
                stype.setTYPE(SearchableTypeType.DATE);
                Integer fromYear = ((SearchableDate)s).getFromYear();
                if (fromYear != null) {
                    stype.setFROMYEAR(((SearchableDate)s).getFromYear());
                    Integer toYear = ((SearchableDate)s).getToYear();
                    stype.setTOYEAR(toYear);
                } else {
                    stype.setFROMYEAR(-1);
                    stype.setTOYEAR(-1);
                }
                stype.setPERIODBACKMAP(this.of.createMapMapType());
                for (Integer key : ((SearchableDate)s).getPeriodBackMap().keySet()) {
                    MapMapEntryType mapEntry = this.of.createMapMapEntryType();
                    mapEntry.setKey(key);
                    Map value = (Map)((SearchableDate)s).getPeriodBackMap().get(key);
                    for (Locale locale : value.keySet()) {
                        MapEntryType entry = this.of.createMapEntryType();
                        entry.setKey(locale.getLanguage() + "_" + locale.getCountry());
                        entry.setValue(value.get(locale));
                        mapEntry.getValue().add(entry);
                    }
                    stype.getPERIODBACKMAP().getMapEntry().add(mapEntry);
                }
            } else {
                stype.setTYPE(SearchableTypeType.PLAIN);
            }
            stype.setINDEXTYPE(s.getIndexType());
            stype.setDESCRIPTIONMAP(this.of.createMapType());
            Map descriptionMap = s.getDescriptionMap();
            List<MapEntryType> entrylist = stype.getDESCRIPTIONMAP().getEntry();
            this.setLocaleDescriptionMapType(entrylist, descriptionMap);
            stype.setSHORTDESCRIPTIONMAP(this.of.createMapType());
            Map shortDescriptionMap = s.getShortDescriptionMap();
            List<MapEntryType> entryList = stype.getSHORTDESCRIPTIONMAP().getEntry();
            this.setLocaleDescriptionMapType(entryList, shortDescriptionMap);
            stype.setINSEARCH(s.isInSearch());
            stype.setINREFINE(s.isInRefine());
            stype.setINBROWSE(s.isInBrowse());
            stype.setSEARCHRANK(s.getSearchRank());
            stype.setBROWSERANK(s.getBrowseRank());
            stype.setREFINERANK(s.getRefineRank());
            stype.setSEARCHVOCABULARY(s.getSearchVocabulary());
            stype.setBROWSEVOCABULARY(s.getBrowseVocabulary());
            profile.getBODY().getSEARCHABLES().getSEARCHABLE().add(stype);
        }
        profile.getBODY().setDOCUMENTDESCRIPTIONS(this.of.createMapType());
        for (String key : layout.getDocumentDescriptions().keySet()) {
            DocumentDescription documentDescription = (DocumentDescription)layout.getDocumentDescriptions().get(key);
            DocumentDescriptionType ddtype = new DocumentDescriptionType();
            ddtype.setView(key);
            DocumentFieldListType documentFieldListType = this.of.createDocumentFieldListType();
            ddtype.setDocumentFields(documentFieldListType);
            for (DocumentField field : documentDescription.getDocumentFields()) {
                DocumentFieldType fieldType = this.createDocumentFieldXml(ddtype, documentFieldListType, field);
                ddtype.getDocumentFields().getDocumentField().add(fieldType);
            }
            MapEntryType entry = this.of.createMapEntryType();
            entry.setKey(ddtype.getView());
            entry.setValue(ddtype);
            profile.getBODY().getDOCUMENTDESCRIPTIONS().getEntry().add(entry);
        }
        for (String collectionId : layout.getBaseCollections()) {
            profile.getBODY().getBASECOLLECTIONS().add(collectionId);
        }
        profile.getBODY().setVIEWCOMMUNITIES(layout.isViewCommunities());
        profile.getBODY().setVIEWCOLLECTIONS(layout.isViewCollections());
        profile.getBODY().setVIEWREPOSITORIES(layout.isViewRepositories());
        profile.getBODY().setVIEWANNOUNCEMENTS(layout.isViewAnnouncements());
        profile.getBODY().setVIEWUSERPROFILE(layout.isViewUserProfile());
        profile.getBODY().setVIEWSIMILARDOCUMENTS(layout.isViewSimilarDocuments());
        profile.getBODY().setVIEWEPUBLICATIONS(layout.isViewEPublications());
    }

    private void setLocaleDescriptionMapType(List<MapEntryType> entryList, Map<Locale, String> descriptionMap) {
        for (Locale locale : descriptionMap.keySet()) {
            String description = descriptionMap.get(locale);
            MapEntryType entry = this.of.createMapEntryType();
            entry.setKey(locale.getLanguage() + "_" + locale.getCountry());
            entry.setValue(description);
            entryList.add(entry);
        }
    }

    private DocumentFieldType createDocumentFieldXml(DocumentDescriptionType ddtype, DocumentFieldListType documentFieldListType, DocumentField field) {
        DocumentFieldType fieldType = this.of.createDocumentFieldType();
        switch (field.getCutpoint()) {
            case LINE: {
                fieldType.setCutpoint(CutpointType.LINE);
                break;
            }
            case PART: {
                fieldType.setCutpoint(CutpointType.PART);
                break;
            }
            case VALUE: {
                fieldType.setCutpoint(CutpointType.VALUE);
            }
        }
        fieldType.setCssClass(field.getCssClass());
        if (field instanceof SwitchDocumentField) {
            SwitchType switchType = this.of.createSwitchType();
            fieldType.setSwitch(switchType);
            switchType.setConditionField(((SwitchDocumentField)field).getConditionField());
            MapType documentFieldMapType = this.of.createMapType();
            for (String conditionFieldValue : ((SwitchDocumentField)field).getDocumentFieldMap().keySet()) {
                MapEntryType entry = this.of.createMapEntryType();
                entry.setKey(conditionFieldValue);
                DocumentField switcheField = (DocumentField)((SwitchDocumentField)field).getDocumentFieldMap().get(conditionFieldValue);
                DocumentFieldListType switchedDocumentFieldListType = this.of.createDocumentFieldListType();
                entry.setValue(this.createDocumentFieldXml(ddtype, switchedDocumentFieldListType, switcheField));
                documentFieldMapType.getEntry().add(entry);
            }
            switchType.setDocumentFieldMap(documentFieldMapType);
            fieldType.getSwitch().setDocumentFieldMap(documentFieldMapType);
        } else {
            fieldType.setName(field.getName());
            fieldType.setDescriptionMap(this.of.createMapType());
            Map descriptionMap = field.getDescriptionMap();
            List<MapEntryType> entryList = fieldType.getDescriptionMap().getEntry();
            this.setLocaleDescriptionMapType(entryList, descriptionMap);
            fieldType.setForceDescription(field.getForceDescription());
            if (field.getSecondaryLinkMap() != null) {
                fieldType.setMultipleValuesDescriptionMap(this.of.createMapType());
                Map multipleValuesDescriptionMap = field.getSecondaryLinkMap();
                entryList = fieldType.getMultipleValuesDescriptionMap().getEntry();
                this.setLocaleDescriptionMapType(entryList, multipleValuesDescriptionMap);
            }
            fieldType.setVocabulary(field.getVocabulary());
            fieldType.setMaxCharacters(field.getMaxCharacters());
            DisplayListType displayListType = this.of.createDisplayListType();
            for (eu.dnetlib.domain.functionality.DisplayType display : field.getDisplays()) {
                DisplayType displayType = this.of.createDisplayType();
                displayType.setDescriptionMap(this.of.createMapType());
                Map displayDescriptionMap = display.getDescriptionMap();
                if (displayDescriptionMap != null) {
                    List<MapEntryType> displayEntryList = displayType.getDescriptionMap().getEntry();
                    this.setLocaleDescriptionMapType(displayEntryList, displayDescriptionMap);
                }
                this.createXmlDisplayType(display, displayType);
                displayListType.getDisplay().add(displayType);
                fieldType.setDisplays(displayListType);
            }
        }
        return fieldType;
    }

    private void createXmlDisplayType(eu.dnetlib.domain.functionality.DisplayType display, DisplayType displayType) {
        if (display instanceof SearchDisplayType) {
            String label = ((SearchDisplayType)display).getLabel();
            displayType.setLabel(label);
            displayType.setDisplayType(DisplayTypeType.SEARCH);
        } else if (display instanceof InternalUrlDisplayType) {
            String parameter;
            String action = ((InternalUrlDisplayType)display).getAction();
            if (action != null) {
                displayType.setAction(action);
            }
            if ((parameter = ((InternalUrlDisplayType)display).getParameter()) != null) {
                displayType.setParameter(parameter);
            }
            displayType.setDisplayType(DisplayTypeType.INTERNAL_URL);
        } else if (display instanceof DocumentExternalUrlDisplayType) {
            displayType.setDisplayType(DisplayTypeType.DOCUMENT_EXTERNAL_URL);
        } else if (display instanceof ExternalUrlDisplayType) {
            displayType.setDisplayType(DisplayTypeType.EXTERNAL_URL);
        } else if (display instanceof PlainTextDisplayType) {
            displayType.setDisplayType(DisplayTypeType.PLAIN);
        }
    }

    private RESOURCEPROFILE setXmlHeader(RESOURCEPROFILE profile, WebInterfaceLayout layout) {
        profile.getHEADER().getRESOURCEKIND().setValue(layout.getResourceKind());
        profile.getHEADER().getRESOURCETYPE().setValue(layout.getResourceType());
        if (layout.getDateOfCreation() != null) {
            profile.getHEADER().getDATEOFCREATION().setValue(ConversionUtils.toXMLGregorianCalendar(layout.getDateOfCreation()));
        } else {
            profile.getHEADER().getDATEOFCREATION().setValue(ConversionUtils.toXMLGregorianCalendar(new Date()));
        }
        if (layout.getResourceId() != null) {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue(layout.getResourceId());
        } else {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
        }
        if (layout.getResourceUri() != null) {
            profile.getHEADER().getRESOURCEURI().setValue(layout.getResourceUri());
        } else {
            profile.getHEADER().getRESOURCEURI().setValue("");
        }
        return profile;
    }

    @Override
    public WebInterfaceLayout XmlToObject(String xml) throws JAXBException {
        WebInterfaceLayout layout = new WebInterfaceLayout(null, null, null);
        RESOURCEPROFILE profile = this.setObjectHeader(xml, layout);
        this.setObjectBody(layout, profile);
        return layout;
    }

    private RESOURCEPROFILE setObjectHeader(String xml, WebInterfaceLayout layout) throws JAXBException {
        RESOURCEPROFILE profile = (RESOURCEPROFILE)this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        layout.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
        layout.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());
        layout.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());
        return profile;
    }

    private void setObjectBody(WebInterfaceLayout layout, RESOURCEPROFILE profile) {
        layout.setName(profile.getBODY().getCONFIGURATION().getNAME());
        layout.setMdFormatName(profile.getBODY().getCONFIGURATION().getMDFORMATNAME());
        layout.setIndexLayoutName(profile.getBODY().getCONFIGURATION().getINDEXLAYOUTNAME());
        layout.setCssFile(profile.getBODY().getCSSFILE());
        layout.setViewCommunities(profile.getBODY().isVIEWCOMMUNITIES());
        layout.setViewCollections(profile.getBODY().isVIEWCOLLECTIONS());
        layout.setViewRepositories(profile.getBODY().isVIEWREPOSITORIES());
        layout.setViewAnnouncements(profile.getBODY().isVIEWANNOUNCEMENTS());
        layout.setViewUserProfile(profile.getBODY().isVIEWUSERPROFILE());
        layout.setViewSimilarDocuments(profile.getBODY().isVIEWSIMILARDOCUMENTS());
        layout.setViewEPublications(profile.getBODY().isVIEWEPUBLICATIONS());
        for (SUPPORTEDLOCALEType sltype : profile.getBODY().getSUPPORTEDLOCALES().getSUPPORTEDLOCALE()) {
            if (sltype.isDEFAULT().booleanValue()) {
                layout.setDefaultLocale(this.retrieveLocale(sltype));
                continue;
            }
            layout.getSupportedLocales().add(this.retrieveLocale(sltype));
        }
        for (String collectionId : profile.getBODY().getBASECOLLECTIONS()) {
            layout.getBaseCollections().add(collectionId);
        }
        for (SEARCHABLEType searchable : profile.getBODY().getSEARCHABLES().getSEARCHABLE()) {
            SearchableDate s = null;
            switch (searchable.getTYPE()) {
                case DATE: {
                    s = new SearchableDate();
                    int fromYear = searchable.getFROMYEAR();
                    int toYear = searchable.getTOYEAR();
                    if (fromYear != -1) {
                        if (toYear == -1) {
                            Date date = new Date();
                            GregorianCalendar calendar = new GregorianCalendar();
                            calendar.setTime(date);
                            toYear = calendar.get(1);
                        }
                        if (toYear <= fromYear) {
                            throw new RuntimeException("Wrong configuration! $toYear should be greater than $fromYear");
                        }
                        s.setFromYear(fromYear);
                        s.setToYear(toYear);
                    }
                    TreeMap periodBack = new TreeMap();
                    for (MapMapEntryType mapEntry : searchable.getPERIODBACKMAP().getMapEntry()) {
                        periodBack.put((Integer)mapEntry.getKey(), new HashMap());
                        for (MapEntryType entry : mapEntry.getValue()) {
                            String[] localeParts = ((String)entry.getKey()).split("_");
                            Locale locale = new Locale(localeParts[0], localeParts[1]);
                            String description = (String)entry.getValue();
                            ((Map)periodBack.get(mapEntry.getKey())).put(locale, description);
                        }
                    }
                    s.setPeriodBackMap(periodBack);
                    break;
                }
                case PLAIN: {
                    s = new Searchable(Searchable.Type.PLAIN);
                }
            }
            s.setName(searchable.getNAME());
            s.setHidden(searchable.isHidden());
            s.setIndexType(searchable.getINDEXTYPE());
            List<MapEntryType> entryList = searchable.getDESCRIPTIONMAP().getEntry();
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            this.setLocaleDescriptionMap(entryList, descriptionMap);
            s.setDescriptionMap(descriptionMap);
            entryList = searchable.getSHORTDESCRIPTIONMAP().getEntry();
            HashMap<Locale, String> shortDescriptionMap = new HashMap<Locale, String>();
            this.setLocaleDescriptionMap(entryList, shortDescriptionMap);
            s.setShortDescriptionMap(shortDescriptionMap);
            s.setInSearch(searchable.isINSEARCH());
            s.setInRefine(searchable.isINREFINE());
            s.setInBrowse(searchable.isINBROWSE());
            s.setSearchRank(searchable.getSEARCHRANK());
            s.setBrowseRank(searchable.getBROWSERANK());
            s.setRefineRank(searchable.getREFINERANK());
            s.setSearchVocabulary(searchable.getSEARCHVOCABULARY());
            s.setBrowseVocabulary(searchable.getBROWSEVOCABULARY());
            layout.getSearchFields().add(s);
        }
        for (MapEntryType entry : profile.getBODY().getDOCUMENTDESCRIPTIONS().getEntry()) {
            DocumentDescription docDescription = new DocumentDescription((String)entry.getKey());
            DocumentDescriptionType documentDescrType = (DocumentDescriptionType)entry.getValue();
            for (DocumentFieldType fieldType : documentDescrType.getDocumentFields().getDocumentField()) {
                docDescription.getDocumentFields().add(this.createDocumentFieldObject(fieldType));
                layout.getDocumentDescriptions().put(docDescription.getView(), docDescription);
            }
        }
    }

    private Locale retrieveLocale(SUPPORTEDLOCALEType sltype) {
        String localeDescr = sltype.getLOCALE();
        String[] locale_details = localeDescr.split("_");
        return new Locale(locale_details[0], locale_details[1]);
    }

    private void setLocaleDescriptionMap(List<MapEntryType> entryList, Map<Locale, String> descriptionMap) {
        for (MapEntryType entry : entryList) {
            String[] localeParts = ((String)entry.getKey()).split("_");
            Locale locale = new Locale(localeParts[0], localeParts[1]);
            String description = (String)entry.getValue();
            descriptionMap.put(locale, description);
        }
    }

    private DocumentField createDocumentFieldObject(DocumentFieldType fieldType) {
        SwitchDocumentField field = null;
        if (fieldType.getSwitch() != null) {
            String conditionField = fieldType.getSwitch().getConditionField();
            field = new SwitchDocumentField(conditionField);
            for (MapEntryType switchEntry : fieldType.getSwitch().getDocumentFieldMap().getEntry()) {
                String conditionFieldValue = (String)switchEntry.getKey();
                DocumentFieldType switchFieldType = (DocumentFieldType)switchEntry.getValue();
                DocumentField documentField = this.createDocumentFieldObject(switchFieldType);
                List<MapEntryType> entryList = ((DocumentFieldType)switchEntry.getValue()).getDescriptionMap().getEntry();
                HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
                this.setLocaleDescriptionMap(entryList, descriptionMap);
                field.setDescriptionMap(descriptionMap);
                field.addSwitchDisplayField(conditionFieldValue, documentField);
            }
        } else {
            String name = fieldType.getName();
            List<MapEntryType> entryList = fieldType.getDescriptionMap().getEntry();
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            this.setLocaleDescriptionMap(entryList, descriptionMap);
            String cssClass = fieldType.getCssClass();
            String vocabulary = fieldType.getVocabulary();
            CutpointType cutpointType = fieldType.getCutpoint();
            DocumentField.Cutpoint cutpoint = null;
            switch (cutpointType) {
                case LINE: {
                    cutpoint = DocumentField.Cutpoint.LINE;
                    break;
                }
                case PART: {
                    cutpoint = DocumentField.Cutpoint.PART;
                    break;
                }
                case VALUE: {
                    cutpoint = DocumentField.Cutpoint.VALUE;
                }
            }
            Integer maxCharacters = fieldType.getMaxCharacters();
            ArrayList<eu.dnetlib.domain.functionality.DisplayType> displays = new ArrayList<eu.dnetlib.domain.functionality.DisplayType>();
            for (DisplayType displayType : fieldType.getDisplays().getDisplay()) {
                eu.dnetlib.domain.functionality.DisplayType display = this.createObjectDisplayType(displayType);
                displays.add(display);
            }
            field = cutpoint != null ? new DocumentField(name, descriptionMap, vocabulary, displays, cssClass, cutpoint, maxCharacters.intValue()) : (maxCharacters != null ? new DocumentField(name, descriptionMap, vocabulary, displays, cssClass, maxCharacters.intValue()) : new DocumentField(name, descriptionMap, vocabulary, displays, cssClass));
            if (fieldType.isForceDescription() != null) {
                field.setForceDescription(fieldType.isForceDescription());
            } else {
                field.setForceDescription(Boolean.valueOf(false));
            }
            if (fieldType.getMultipleValuesDescriptionMap() != null) {
                entryList = fieldType.getMultipleValuesDescriptionMap().getEntry();
                HashMap<Locale, String> secondaryLinkMap = new HashMap<Locale, String>();
                this.setLocaleDescriptionMapType(entryList, secondaryLinkMap);
                field.setSecondaryLinkMap(secondaryLinkMap);
            }
        }
        return field;
    }

    private eu.dnetlib.domain.functionality.DisplayType createObjectDisplayType(DisplayType displayType) {
        PlainTextDisplayType display = null;
        List<MapEntryType> entryList = displayType.getDescriptionMap().getEntry();
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        this.setLocaleDescriptionMap(entryList, descriptionMap);
        String field = displayType.getField();
        switch (displayType.getDisplayType()) {
            case PLAIN: {
                display = new PlainTextDisplayType(field, descriptionMap);
                break;
            }
            case SEARCH: {
                String label = displayType.getLabel();
                if (label == null) {
                    throw new RuntimeException("In case of SearchDisplayType field label cannot be null");
                }
                display = new SearchDisplayType(field, label, descriptionMap);
                break;
            }
            case DOCUMENT_EXTERNAL_URL: {
                display = new DocumentExternalUrlDisplayType(field, descriptionMap);
                break;
            }
            case EXTERNAL_URL: {
                display = new ExternalUrlDisplayType(field, descriptionMap);
                break;
            }
            case INTERNAL_URL: {
                String action = displayType.getAction();
                String parameter = displayType.getParameter();
                display = new InternalUrlDisplayType(field, descriptionMap, action, parameter);
            }
        }
        return display;
    }

    @Override
    public String toXQueryString(SearchCriteria criteria) {
        return this.toXQueryString((WebInterfaceSearchCriteria)criteria);
    }

    public String toXQueryString(WebInterfaceSearchCriteria criteria) {
        criteria = ConversionUtils.createProxy(criteria);
        String xQuery = null;
        ArrayList<String> predicates = new ArrayList<String>();
        xQuery = "for $x in collection( \"/db/DRIVER/WebInterfaceLayoutResources/WebInterfaceLayoutResourceType\" )";
        if (criteria.getLayoutName() != null) {
            predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME[.= \"" + criteria.getLayoutName() + "\"]");
        }
        for (int i = 0; i < predicates.size(); ++i) {
            String predicate = (String)predicates.get(i);
            xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
            xQuery = xQuery + predicate;
        }
        xQuery = xQuery + " return $x";
        logger.debug((Object)xQuery);
        return xQuery;
    }

    @Deprecated
    public String toXQueryString(WebInterfaceLayout exampleInstance) {
        String xQuery = "for $x in collection( \"/db/DRIVER/WebInterfaceLayoutResources/WebInterfaceLayoutResourceType\" )";
        ArrayList<String> predicates = new ArrayList<String>();
        if (exampleInstance != null) {
            if (exampleInstance.getName() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME[.=\"" + exampleInstance.getName() + "\"]");
            }
            for (int i = 0; i < predicates.size(); ++i) {
                String predicate = (String)predicates.get(i);
                xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
                xQuery = xQuery + predicate;
            }
        }
        xQuery = xQuery + " return $x";
        logger.debug((Object)xQuery);
        return xQuery;
    }

    public static void main(String[] args) throws JAXBException {
        WebInterfaceLayoutXmlConverter converter = new WebInterfaceLayoutXmlConverter();
        WebInterfaceLayout layout = new WebInterfaceLayout("i18n_demo", "DMF", "index");
        layout.setCssFile("driver_search_es.css");
        layout.setDefaultLocale(new Locale("en", "GB"));
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        supportedLocales.add(new Locale("es", "ES"));
        layout.setSupportedLocales(supportedLocales);
        layout.setViewCollections(false);
        layout.setViewCommunities(false);
        layout.setViewRepositories(true);
        layout.setViewAnnouncements(true);
        layout.setViewUserProfile(true);
        layout.setViewSimilarDocuments(false);
        layout.setViewEPublications(false);
        Searchable sable = new Searchable(Searchable.Type.PLAIN);
        HashMap<Locale, String> descriprionMap = new HashMap<Locale, String>();
        descriprionMap.put(new Locale("en", "GB"), "Author");
        descriprionMap.put(new Locale("es", "ES"), "Creador");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "author");
        descriprionMap.put(new Locale("es", "ES"), "creador");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("author");
        sable.setIndexType("creator");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(1);
        sable.setRefineRank(1);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Title");
        descriprionMap.put(new Locale("es", "ES"), "T\u00edtulo");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "title");
        descriprionMap.put(new Locale("es", "ES"), "t\u00edtulo");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("title");
        sable.setIndexType("title");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(2);
        sable.setRefineRank(2);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Subject");
        descriprionMap.put(new Locale("es", "ES"), "Materia");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "subject");
        descriprionMap.put(new Locale("es", "ES"), "materia");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("subject");
        sable.setIndexType("subject");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(false);
        sable.setSearchRank(3);
        sable.setRefineRank(3);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Contributor");
        descriprionMap.put(new Locale("es", "ES"), "Contribuidor");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "contributor");
        descriprionMap.put(new Locale("es", "ES"), "contribuidor");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("contributor");
        sable.setIndexType("contributor");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(false);
        sable.setSearchRank(4);
        sable.setRefineRank(4);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publisher");
        descriprionMap.put(new Locale("es", "ES"), "Editor");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "publisher");
        descriprionMap.put(new Locale("es", "ES"), "editor");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("publisher");
        sable.setIndexType("publisher");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(false);
        sable.setSearchRank(5);
        sable.setRefineRank(5);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Source");
        descriprionMap.put(new Locale("es", "ES"), "Fuente");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "source");
        descriprionMap.put(new Locale("es", "ES"), "fuente");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("source");
        sable.setIndexType("source");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(false);
        sable.setSearchRank(6);
        sable.setRefineRank(6);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Relation");
        descriprionMap.put(new Locale("es", "ES"), "Relaci\u00f3n");
        descriprionMap.put(new Locale("es", "ES"), "Relaci\u00f3n");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "relation");
        descriprionMap.put(new Locale("es", "ES"), "relaci\u00f3n");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("relation");
        sable.setIndexType("relation");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(7);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new SearchableDate();
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publication Date");
        descriprionMap.put(new Locale("es", "ES"), "Fecha de Publicaci\u00f3n");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "published");
        descriprionMap.put(new Locale("es", "ES"), "publicado");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("dateAccept");
        sable.setIndexType("dateAccepted");
        sable.setInSearch(true);
        sable.setSearchRank(8);
        ((SearchableDate)sable).setFromYear(1980);
        TreeMap<Integer, HashMap<Locale, String>> tm = new TreeMap<Integer, HashMap<Locale, String>>();
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the specified date range");
        descriprionMap.put(new Locale("es", "ES"), "de la fecha especificada gama");
        tm.put(new Integer(0), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last one month");
        descriprionMap.put(new Locale("es", "ES"), "en el \u00faltimo mes");
        tm.put(new Integer(1), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 2 months");
        descriprionMap.put(new Locale("es", "ES"), "en los \u00faltimos 2 meses");
        tm.put(new Integer(2), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 3 months");
        descriprionMap.put(new Locale("es", "ES"), "en los \u00faltimos 3 meses");
        tm.put(new Integer(3), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 6 months");
        descriprionMap.put(new Locale("es", "ES"), "en los \u00faltimos 6 meses");
        tm.put(new Integer(6), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 12 months");
        descriprionMap.put(new Locale("es", "ES"), "en los \u00faltimos 12 meses");
        tm.put(new Integer(12), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 2 years");
        descriprionMap.put(new Locale("es", "ES"), "en los \u00faltimos 2 a\u00f1os");
        tm.put(new Integer(24), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 3 years");
        descriprionMap.put(new Locale("es", "ES"), "en los \u00faltimos 3 a\u00f1os");
        tm.put(new Integer(36), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 5 years");
        descriprionMap.put(new Locale("es", "ES"), "en los \u00faltimos 5 a\u00f1os");
        tm.put(new Integer(60), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 10 years");
        descriprionMap.put(new Locale("es", "ES"), "en los \u00faltimos 10 a\u00f1os");
        tm.put(new Integer(120), descriprionMap);
        ((SearchableDate)sable).getPeriodBackMap().putAll(tm);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Document Language");
        descriprionMap.put(new Locale("es", "ES"), "Idioma del Documento");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "language");
        descriprionMap.put(new Locale("es", "ES"), "idioma");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("lang");
        sable.setIndexType("language");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(true);
        sable.setSearchRank(9);
        sable.setRefineRank(7);
        sable.setBrowseRank(1);
        sable.setSearchVocabulary("Short list of language names");
        sable.setBrowseVocabulary("Names of languages");
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Document Type");
        descriprionMap.put(new Locale("es", "ES"), "Tipo de Documento");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "category");
        descriprionMap.put(new Locale("es", "ES"), "categor\u00eda");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("category");
        sable.setIndexType("CobjCategory");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(true);
        sable.setSearchRank(10);
        sable.setRefineRank(8);
        sable.setBrowseRank(2);
        sable.setSearchVocabulary("Names of Text Object Typologies");
        sable.setBrowseVocabulary("Names of Text Object Typologies");
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Repositories");
        descriprionMap.put(new Locale("es", "ES"), "Repositorios");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "repositories");
        descriprionMap.put(new Locale("es", "ES"), "repositorios");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("repName");
        sable.setIndexType("repositoryName");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(true);
        sable.setSearchRank(11);
        sable.setRefineRank(9);
        sable.setBrowseRank(3);
        sable.setSearchVocabulary("Names of Repositories");
        layout.getSearchFields().add(sable);
        HashMap<String, DocumentDescription> documentDescriptions = new HashMap<String, DocumentDescription>();
        DocumentDescription dd = new DocumentDescription("summaryView");
        ArrayList<DocumentField> fields = new ArrayList<DocumentField>();
        ArrayList<DocumentExternalUrlDisplayType> displays = new ArrayList<DocumentExternalUrlDisplayType>();
        SwitchDocumentField switchField = new SwitchDocumentField("CobjTypology");
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${title}");
        descriprionMap.put(new Locale("es", "ES"), "${title}");
        descriprionMap.put(new Locale("el", "GR"), "${title}");
        descriprionMap.put(new Locale("zh", "CN"), "${title}");
        DocumentExternalUrlDisplayType type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
        displays.add(type);
        DocumentField field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", DocumentField.Cutpoint.VALUE, 1);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
        descriprionMap.put(new Locale("es", "ES"), "tambi\u00e9n se puede visitar");
        field.setSecondaryLinkMap(descriprionMap);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("Textual", field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${title}");
        descriprionMap.put(new Locale("es", "ES"), "${title}");
        descriprionMap.put(new Locale("el", "GR"), "${title}");
        descriprionMap.put(new Locale("zh", "CN"), "${title}");
        displays = new ArrayList();
        type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
        displays.add(type);
        field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", DocumentField.Cutpoint.VALUE, 1);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
        descriprionMap.put(new Locale("es", "ES"), "tambi\u00e9n se puede visitar");
        field.setSecondaryLinkMap(descriprionMap);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("Compound Object", field);
        dd.putDocumentField((DocumentField)switchField);
        type = new SearchDisplayType("creator", "author");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Author(s)");
        descriprionMap.put(new Locale("es", "ES"), "Creador(s)");
        field = new DocumentField("creator", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        field.setDescriptionMap(descriprionMap);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("description");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Description");
        descriprionMap.put(new Locale("es", "ES"), "Descripci\u00f3n");
        field = new DocumentField("description", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${repositoryName}");
        descriprionMap.put(new Locale("es", "ES"), "${repositoryName}");
        type = new InternalUrlDisplayType("repositoryName", descriprionMap, "showRepository", "name");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "View repository documents");
        descriprionMap.put(new Locale("es", "ES"), "Ver documentos del repositorio");
        type = new SearchDisplayType("repositoryName", "repName", descriprionMap);
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Repository");
        descriprionMap.put(new Locale("es", "ES"), "Repositorio");
        field = new DocumentField("repositoryName", descriprionMap, "Names of Repositories", displays, "resultsField", DocumentField.Cutpoint.LINE, 300);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("language");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Language(s)");
        descriprionMap.put(new Locale("es", "ES"), "Idioma(s)");
        field = new DocumentField("language", descriprionMap, "Names of Languages", displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        dd = new DocumentDescription("detailedView");
        fields = new ArrayList();
        displays = new ArrayList();
        switchField = new SwitchDocumentField("CobjTypology");
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${title}");
        descriprionMap.put(new Locale("es", "ES"), "${title}");
        type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
        displays.add(type);
        field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", DocumentField.Cutpoint.VALUE, 1);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
        descriprionMap.put(new Locale("es", "ES"), "tambi\u00e9n se puede visitar");
        field.setSecondaryLinkMap(descriprionMap);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("Textual", field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${title}");
        descriprionMap.put(new Locale("es", "ES"), "${title}");
        displays = new ArrayList();
        type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
        displays.add(type);
        field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", DocumentField.Cutpoint.VALUE, 1);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
        descriprionMap.put(new Locale("es", "ES"), "tambi\u00e9n se puede visitar");
        field.setSecondaryLinkMap(descriprionMap);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("Compound Object", field);
        dd.putDocumentField((DocumentField)switchField);
        type = new SearchDisplayType("creator", "author");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Author(s)");
        descriprionMap.put(new Locale("es", "ES"), "Creador(s)");
        field = new DocumentField("creator", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        field.setDescriptionMap(descriprionMap);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("description");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Description");
        descriprionMap.put(new Locale("es", "ES"), "Descripci\u00f3n");
        field = new DocumentField("description", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${repositoryName}");
        descriprionMap.put(new Locale("es", "ES"), "${repositoryName}");
        type = new InternalUrlDisplayType("repositoryName", descriprionMap, "showRepository", "name");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "View repository documents");
        descriprionMap.put(new Locale("es", "ES"), "Ver documentos del repositorio");
        type = new SearchDisplayType("repositoryName", "repName", descriprionMap);
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Repository");
        descriprionMap.put(new Locale("es", "ES"), "Repositorio");
        field = new DocumentField("repositoryName", descriprionMap, "Names of Repositories", displays, "resultsField", DocumentField.Cutpoint.LINE, 300);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("language");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Language(s)");
        descriprionMap.put(new Locale("es", "ES"), "Idioma(s)");
        field = new DocumentField("language", descriprionMap, "Names of Languages", displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        type = new PlainTextDisplayType("subject");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Subject(s)");
        descriprionMap.put(new Locale("es", "ES"), "Materia(s)");
        field = new DocumentField("subject", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("publisher");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publisher(s)");
        descriprionMap.put(new Locale("es", "ES"), "Editor(es)");
        field = new DocumentField("publisher", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("contributor");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Contributor(s)");
        descriprionMap.put(new Locale("es", "ES"), "Contribuidor(es)");
        field = new DocumentField("source", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("source");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Source(s)");
        descriprionMap.put(new Locale("es", "ES"), "Fuente(s)");
        field = new DocumentField("source", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("dateAccepted");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publication Date(s)");
        descriprionMap.put(new Locale("es", "ES"), "Fecha(s) de Publicaci\u00f3n");
        field = new DocumentField("dateAccepted", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        dd = new DocumentDescription("communityView");
        fields = new ArrayList();
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "identifier");
        displays = new ArrayList();
        type = new PlainTextDisplayType("identifier");
        displays.add(type);
        field = new DocumentField("identifier", descriprionMap, null, displays, "", DocumentField.Cutpoint.VALUE, 1);
        dd.putDocumentField(field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "id");
        displays = new ArrayList();
        type = new PlainTextDisplayType("id");
        displays.add(type);
        field = new DocumentField("id", descriprionMap, null, displays, "", DocumentField.Cutpoint.VALUE, 1);
        dd.putDocumentField(field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "title");
        displays = new ArrayList();
        type = new PlainTextDisplayType("title");
        displays.add(type);
        field = new DocumentField("title", descriprionMap, null, displays, "", DocumentField.Cutpoint.VALUE, 1);
        dd.putDocumentField(field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "creator");
        displays = new ArrayList();
        type = new PlainTextDisplayType("creator");
        displays.add(type);
        field = new DocumentField("creator", descriprionMap, null, displays, "", DocumentField.Cutpoint.VALUE, 100);
        field.setDescriptionMap(descriprionMap);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("description");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "description");
        field = new DocumentField("description", descriprionMap, null, displays, "", DocumentField.Cutpoint.PART, 300);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("dateAccept");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "dateAccept");
        field = new DocumentField("dateAccept", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        dd = new DocumentDescription("detailedView");
        fields = new ArrayList();
        displays = new ArrayList();
        switchField = new SwitchDocumentField("CobjTypology");
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${title}");
        descriprionMap.put(new Locale("es", "ES"), "${title}");
        type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
        displays.add(type);
        field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", DocumentField.Cutpoint.VALUE, 1);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
        descriprionMap.put(new Locale("es", "ES"), "tambi\u00e9n se puede visitar");
        field.setSecondaryLinkMap(descriprionMap);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("Textual", field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${title}");
        descriprionMap.put(new Locale("es", "ES"), "${title}");
        displays = new ArrayList();
        type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
        displays.add(type);
        field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", DocumentField.Cutpoint.VALUE, 1);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
        descriprionMap.put(new Locale("es", "ES"), "tambi\u00e9n se puede visitar");
        field.setSecondaryLinkMap(descriprionMap);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("Compound Object", field);
        dd.putDocumentField((DocumentField)switchField);
        type = new SearchDisplayType("creator", "author");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Author(s)");
        descriprionMap.put(new Locale("es", "ES"), "Creador(s)");
        field = new DocumentField("creator", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        field.setDescriptionMap(descriprionMap);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("description");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Description");
        descriprionMap.put(new Locale("es", "ES"), "Descripci\u00f3n");
        field = new DocumentField("description", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${repositoryName}");
        descriprionMap.put(new Locale("es", "ES"), "${repositoryName}");
        type = new InternalUrlDisplayType("repositoryName", descriprionMap, "showRepository", "name");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "View repository documents");
        descriprionMap.put(new Locale("es", "ES"), "Ver documentos del repositorio");
        type = new SearchDisplayType("repositoryName", "repName", descriprionMap);
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Repository");
        descriprionMap.put(new Locale("es", "ES"), "Repositorio");
        field = new DocumentField("repositoryName", descriprionMap, "Names of Repositories", displays, "resultsField", DocumentField.Cutpoint.LINE, 300);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("language");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Language(s)");
        descriprionMap.put(new Locale("es", "ES"), "Idioma(s)");
        field = new DocumentField("language", descriprionMap, "Names of Languages", displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        type = new PlainTextDisplayType("subject");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Subject(s)");
        descriprionMap.put(new Locale("es", "ES"), "Materia(s)");
        field = new DocumentField("subject", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("publisher");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publisher(s)");
        descriprionMap.put(new Locale("es", "ES"), "Editor(es)");
        descriprionMap.put(new Locale("el", "GR"), "\u0395\u03ba\u03b4\u03cc\u03c4\u03b5\u03c2");
        descriprionMap.put(new Locale("zh", "CN"), "\u51fa\u7248\u8005");
        field = new DocumentField("publisher", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("contributor");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Contributor(s)");
        descriprionMap.put(new Locale("es", "ES"), "Contribuidor(es)");
        field = new DocumentField("source", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("source");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Source(s)");
        descriprionMap.put(new Locale("es", "ES"), "Fuente(s)");
        field = new DocumentField("source", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("dateAccepted");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publication Date(s)");
        descriprionMap.put(new Locale("es", "ES"), "Fecha(s) de Publicaci\u00f3n");
        field = new DocumentField("dateAccepted", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        dd = new DocumentDescription("bibtex");
        fields = new ArrayList();
        displays = new ArrayList();
        switchField = new SwitchDocumentField("CobjCategory");
        dd = new DocumentDescription("bibtex");
        fields = new ArrayList();
        displays = new ArrayList();
        type = new PlainTextDisplayType("creator");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "author");
        field = new DocumentField("creator", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        field.setDescriptionMap(descriprionMap);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("title");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "title");
        field = new DocumentField("projectname", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("publicationyear");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "year");
        field = new DocumentField("description", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        layout.setDocumentDescriptions(documentDescriptions);
        WebInterfaceLayoutXmlConverter.createXML(converter);
    }

    private static void createXML(WebInterfaceLayoutXmlConverter converter) throws JAXBException {
        WebInterfaceLayout layout = new WebInterfaceLayout("testing", "DMF", "index");
        layout.setCssFile("driver_search.css");
        layout.setDefaultLocale(new Locale("en", "GB"));
        ArrayList supportedLocales = new ArrayList();
        layout.setSupportedLocales(supportedLocales);
        layout.setViewCollections(false);
        layout.setViewCommunities(false);
        layout.setViewRepositories(true);
        layout.setViewAnnouncements(true);
        layout.setViewUserProfile(true);
        layout.setViewSimilarDocuments(false);
        layout.setViewEPublications(false);
        Searchable sable = new Searchable(Searchable.Type.PLAIN);
        HashMap<Locale, String> descriprionMap = new HashMap<Locale, String>();
        descriprionMap.put(new Locale("en", "GB"), "Author");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "author");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("author");
        sable.setIndexType("creator");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(1);
        sable.setRefineRank(1);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Title");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "title");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("title");
        sable.setIndexType("title");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(2);
        sable.setRefineRank(2);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Subject");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "subject");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("subject");
        sable.setIndexType("subject");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(3);
        sable.setRefineRank(3);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publisher");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "publisher");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("publisher");
        sable.setIndexType("publisher");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(5);
        sable.setRefineRank(5);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new SearchableDate();
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publication Date");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "published");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("dateAccept");
        sable.setIndexType("publicationdate");
        sable.setInSearch(true);
        sable.setSearchRank(8);
        ((SearchableDate)sable).setFromYear(1980);
        TreeMap<Integer, HashMap<Locale, String>> tm = new TreeMap<Integer, HashMap<Locale, String>>();
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the specified date range");
        tm.put(new Integer(0), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last one month");
        tm.put(new Integer(1), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 2 months");
        tm.put(new Integer(2), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 3 months");
        tm.put(new Integer(3), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 6 months");
        tm.put(new Integer(6), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 12 months");
        tm.put(new Integer(12), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 2 years");
        tm.put(new Integer(24), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 3 years");
        tm.put(new Integer(36), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 5 years");
        tm.put(new Integer(60), descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "in the last 10 years");
        tm.put(new Integer(120), descriprionMap);
        ((SearchableDate)sable).getPeriodBackMap().putAll(tm);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Document Language");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "language");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("lang");
        sable.setIndexType("language");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(true);
        sable.setSearchRank(9);
        sable.setRefineRank(7);
        sable.setBrowseRank(1);
        sable.setSearchVocabulary("Short list of language names");
        sable.setBrowseVocabulary("Names of languages");
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        sable.setHidden(true);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Project");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "project");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("project");
        sable.setIndexType("projectname");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(true);
        sable.setSearchRank(1);
        sable.setRefineRank(1);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Scientific Areas");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "area");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("areaid");
        sable.setIndexType("subdivisionid");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(true);
        sable.setSearchRank(11);
        sable.setRefineRank(9);
        sable.setBrowseRank(3);
        sable.setSearchVocabulary("subdivisionNames");
        sable.setBrowseVocabulary("subdivisionNames");
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        sable.setHidden(true);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Scientific Area");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "area");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("area");
        sable.setIndexType("subdivisionname");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(1);
        sable.setRefineRank(1);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Country");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "country");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("country");
        sable.setIndexType("countryaffiliation");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(true);
        sable.setSearchRank(1);
        sable.setRefineRank(1);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary("Names of Countries");
        sable.setSearchVocabulary("Names of Countries");
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Programmes");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "programmes");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("programmeid");
        sable.setIndexType("specificprogrammeid");
        sable.setInSearch(true);
        sable.setInRefine(true);
        sable.setInBrowse(true);
        sable.setSearchRank(11);
        sable.setRefineRank(9);
        sable.setBrowseRank(3);
        sable.setSearchVocabulary("programmeNames");
        sable.setBrowseVocabulary("programmeNames");
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        sable.setHidden(true);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Programmes");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "programmes");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("programme");
        sable.setIndexType("specificprogrammename");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(1);
        sable.setRefineRank(1);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Repositories");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "repositories");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("repName");
        sable.setIndexType("datasourcename");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(11);
        sable.setRefineRank(9);
        sable.setBrowseRank(3);
        sable.setSearchVocabulary("datasourcesNames");
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        sable.setHidden(true);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publication Year");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "year");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("year");
        sable.setIndexType("publicationyear");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(true);
        sable.setSearchRank(11);
        sable.setRefineRank(9);
        sable.setBrowseRank(3);
        layout.getSearchFields().add(sable);
        sable = new Searchable(Searchable.Type.PLAIN);
        sable.setHidden(true);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Access Mode");
        sable.setDescriptionMap(descriprionMap);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "access");
        sable.setShortDescriptionMap(descriprionMap);
        sable.setName("accessmode");
        sable.setIndexType("accessmode");
        sable.setInSearch(true);
        sable.setInRefine(false);
        sable.setInBrowse(false);
        sable.setSearchRank(1);
        sable.setRefineRank(1);
        sable.setSearchVocabulary(null);
        sable.setBrowseVocabulary(null);
        layout.getSearchFields().add(sable);
        HashMap<String, DocumentDescription> documentDescriptions = new HashMap<String, DocumentDescription>();
        DocumentDescription dd = new DocumentDescription("summaryView");
        ArrayList<DocumentField> fields = new ArrayList<DocumentField>();
        ArrayList<DocumentExternalUrlDisplayType> displays = new ArrayList<DocumentExternalUrlDisplayType>();
        SwitchDocumentField switchField = new SwitchDocumentField("CobjTypology");
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${title}");
        DocumentExternalUrlDisplayType type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
        displays.add(type);
        DocumentField field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", DocumentField.Cutpoint.VALUE, 1);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
        field.setSecondaryLinkMap(descriprionMap);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("Textual", field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${title}");
        displays = new ArrayList();
        type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
        displays.add(type);
        field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", DocumentField.Cutpoint.VALUE, 1);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
        field.setSecondaryLinkMap(descriprionMap);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("Compound Object", field);
        dd.putDocumentField((DocumentField)switchField);
        type = new SearchDisplayType("creator", "author");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Author(s)");
        field = new DocumentField("creator", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        field.setDescriptionMap(descriprionMap);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("projectname");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Project(s)");
        field = new DocumentField("projectname", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        dd = new DocumentDescription("detailedView");
        fields = new ArrayList();
        displays = new ArrayList();
        switchField = new SwitchDocumentField("CobjTypology");
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${title}");
        type = new DocumentExternalUrlDisplayType("identifier", descriprionMap);
        displays.add(type);
        field = new DocumentField("identifier", descriprionMap, null, displays, "document_text", DocumentField.Cutpoint.VALUE, 1);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
        field.setSecondaryLinkMap(descriprionMap);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("Textual", field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${title}");
        displays = new ArrayList();
        type = new InternalUrlDisplayType("identifier", descriprionMap, "showEPublication", "epId");
        displays.add(type);
        field = new DocumentField("identifier", descriprionMap, null, displays, "document_ep", DocumentField.Cutpoint.VALUE, 1);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "You can also visit...");
        field.setSecondaryLinkMap(descriprionMap);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("Compound Object", field);
        dd.putDocumentField((DocumentField)switchField);
        type = new SearchDisplayType("creator", "author");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Author(s)");
        field = new DocumentField("creator", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        field.setDescriptionMap(descriprionMap);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("projectname");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Project(s)");
        field = new DocumentField("projectname", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("description");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Description");
        field = new DocumentField("description", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("specificprogrammedescription");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Programme(s)");
        field = new DocumentField("specificprogrammedescription", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("subdivisionname");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Scientific Area(s)");
        field = new DocumentField("subdivisionname", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("subject");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Subject(s)");
        field = new DocumentField("subject", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "${datasourcename}");
        type = new PlainTextDisplayType("datasourcename");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Repository");
        field = new DocumentField("datasourcename", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.LINE, 300);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("language");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Language(s)");
        field = new DocumentField("language", descriprionMap, "Names of Languages", displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        type = new PlainTextDisplayType("publisher");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publisher(s)");
        field = new DocumentField("publisher", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("publicationdate");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Publication Date(s)");
        field = new DocumentField("publicationdate", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        type = new PlainTextDisplayType("embargoenddate");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Embargo End Date");
        field = new DocumentField("embargoenddate", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        type = new PlainTextDisplayType("accessmode");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "Access Mode");
        field = new DocumentField("accessmode", descriprionMap, null, displays, "resultsField");
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        dd = new DocumentDescription("communityView");
        fields = new ArrayList();
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "identifier");
        displays = new ArrayList();
        type = new PlainTextDisplayType("identifier");
        displays.add(type);
        field = new DocumentField("identifier", descriprionMap, null, displays, "", DocumentField.Cutpoint.VALUE, 1);
        dd.putDocumentField(field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "id");
        displays = new ArrayList();
        type = new PlainTextDisplayType("id");
        displays.add(type);
        field = new DocumentField("id", descriprionMap, null, displays, "", DocumentField.Cutpoint.VALUE, 1);
        dd.putDocumentField(field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "title");
        displays = new ArrayList();
        type = new PlainTextDisplayType("title");
        displays.add(type);
        field = new DocumentField("title", descriprionMap, null, displays, "", DocumentField.Cutpoint.VALUE, 1);
        dd.putDocumentField(field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "creator");
        displays = new ArrayList();
        type = new PlainTextDisplayType("creator");
        displays.add(type);
        field = new DocumentField("creator", descriprionMap, null, displays, "", DocumentField.Cutpoint.VALUE, 100);
        field.setDescriptionMap(descriprionMap);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("description");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "description");
        field = new DocumentField("description", descriprionMap, null, displays, "", DocumentField.Cutpoint.PART, 300);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("dateAccept");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "dateAccept");
        field = new DocumentField("dateAccept", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        layout.setDocumentDescriptions(documentDescriptions);
        dd = new DocumentDescription("bibtex");
        fields = new ArrayList();
        displays = new ArrayList();
        switchField = new SwitchDocumentField("CobjCategory");
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "creator00");
        type = new PlainTextDisplayType("creator", descriprionMap);
        displays.add(type);
        field = new DocumentField("creator", descriprionMap, null, displays, "document_text", DocumentField.Cutpoint.VALUE, 1);
        field.setForceDescription(Boolean.valueOf(false));
        switchField.addSwitchDisplayField("0000", field);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "craetor01");
        displays = new ArrayList();
        type = new PlainTextDisplayType("creator", descriprionMap);
        displays.add(type);
        field = new DocumentField("creator", descriprionMap, null, displays, "document_ep", DocumentField.Cutpoint.VALUE, 1);
        field.setForceDescription(Boolean.valueOf(true));
        switchField.addSwitchDisplayField("0001", field);
        dd.putDocumentField((DocumentField)switchField);
        type = new PlainTextDisplayType("creator");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "author");
        field = new DocumentField("creator", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.VALUE, 100);
        field.setDescriptionMap(descriprionMap);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("title");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "title");
        field = new DocumentField("projectname", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        type = new PlainTextDisplayType("publicationyear");
        displays = new ArrayList();
        displays.add(type);
        descriprionMap = new HashMap();
        descriprionMap.put(new Locale("en", "GB"), "year");
        field = new DocumentField("description", descriprionMap, null, displays, "resultsField", DocumentField.Cutpoint.PART, 300);
        fields.add(field);
        dd.putDocumentField(field);
        documentDescriptions.put(dd.getView(), dd);
        layout.setDocumentDescriptions(documentDescriptions);
        String xml = converter.ObjectToXml(layout);
        System.out.println(xml);
    }
}

