/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.resultset;

import eu.dnetlib.api.enabling.ResultSetService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.util.ObjectToXmlConverter;
import eu.dnetlib.utils.resolver.EndpointResolver;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.resultset.ResultSet;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import gr.uoa.di.driver.enabling.resultset.ResultSetImpl;
import gr.uoa.di.driver.enabling.resultset.SecurityAwareResultSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ResultSetFactoryImpl
implements ResultSetFactory {
    private static Logger logger = Logger.getLogger(ResultSetFactoryImpl.class);
    private Map<Class<?>, ObjectToXmlConverter<?>> converterMap = new HashMap();
    private ISLookUp<SecurityProfile> securityLookUp = null;
    private EndpointResolver endpointResolver = null;

    @Override
    public <D> ResultSet<D> createResultSet(ResultSet<?> rs, Class<D> resourceClass) {
        return this.createResultSet(rs.getEpr(), resourceClass);
    }

    @Override
    public ResultSet<String> createResultSet(EPR epr) {
        return this.createResultSet(epr, String.class);
    }

    @Override
    public <D> ResultSet<D> createResultSet(EPR epr, Class<D> resourceClass) {
        logger.debug((Object)("Creating result set for resource type: " + resourceClass.getSimpleName() + " and RSService: " + epr.getAddress()));
        ResultSetImpl<Object> rs = null;
        ResultSetService rsService = this.endpointResolver.getService(ResultSetService.class, epr);
        String rsIdentifier = epr.getParameter("ResourceIdentifier");
        if (resourceClass.equals(String.class)) {
            rs = new ResultSetImpl(rsService, rsIdentifier);
        } else {
            ObjectToXmlConverter<?> converter = this.converterMap.get(resourceClass);
            if (converter != null) {
                rs = new ResultSetImpl(rsService, rsIdentifier, converter);
            }
        }
        return rs;
    }

    @Override
    public <D extends SecureDriverResource> ResultSet<D> createSecurityAwareRS(EPR epr, Class<D> resourceClass) {
        logger.debug((Object)("Creating security aware result set for resource type: " + resourceClass.getSimpleName()));
        SecurityAwareResultSet<D> rs = new SecurityAwareResultSet<D>();
        rs.setResultSet(this.createResultSet(epr, resourceClass));
        rs.setSecurityLookUp(this.securityLookUp);
        return rs;
    }

    public void setConverterMap(Map<Class<?>, ObjectToXmlConverter<?>> converterMap) {
        this.converterMap = converterMap;
    }

    public void setSecurityLookUp(ISLookUp<SecurityProfile> securityLookUp) {
        this.securityLookUp = securityLookUp;
    }

    public void setEndpointResolver(EndpointResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
    }
}

