package gr.uoa.di.driver.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.xml.bind.JAXBException;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.functionality.RSSFeed;
import eu.dnetlib.domain.functionality.RSSFeedSearchCriteria;
import gr.uoa.di.driver.xml.rssfeed.DOCUMENTSType;
import gr.uoa.di.driver.xml.rssfeed.ObjectFactory;
import gr.uoa.di.driver.xml.rssfeed.RESOURCEPROFILE;

public class RSSFeedXmlConverter extends AbstractConverter<RSSFeed> implements
		ResourceToXmlConverter<RSSFeed> {

	private ObjectFactory of = new ObjectFactory();

	public RSSFeedXmlConverter() throws JAXBException {
		super(RESOURCEPROFILE.class);
	}

	public String ObjectToXml(RSSFeed rssFeed)
			throws JAXBException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		RESOURCEPROFILE profile = of.createRESOURCEPROFILE();

		profile.setHEADER(of.createHEADERType());
		profile.setBODY(of.createBODYType());

		profile.getHEADER().setRESOURCEIDENTIFIER(of.createRESOURCEIDENTIFIERType());
		profile.getHEADER().setRESOURCEKIND(of.createRESOURCEKINDType());
		profile.getHEADER().setRESOURCETYPE(of.createRESOURCETYPEType());
		profile.getHEADER().setRESOURCEURI(of.createRESOURCEURIType());
		profile.getHEADER().setDATEOFCREATION(of.createDATEOFCREATIONType());

		profile.getHEADER().getRESOURCEKIND().setValue(rssFeed.getResourceKind());
		profile.getHEADER().getRESOURCETYPE().setValue(rssFeed.getResourceType());

		if (rssFeed.getDateOfCreation() != null)
			profile.getHEADER().getDATEOFCREATION().setValue(
					ConversionUtils
							.DateToString(rssFeed.getDateOfCreation()));
		else
			profile.getHEADER().getDATEOFCREATION().setValue("");

		if (rssFeed.getResourceId() != null)
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue(
					rssFeed.getResourceId());
		else
			profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
		
		if (rssFeed.getResourceUri() != null)
			profile.getHEADER().getRESOURCEURI().setValue(
					rssFeed.getResourceUri());
		else
			profile.getHEADER().getRESOURCEURI().setValue("");
		
		profile.getBODY().setSECURITYPARAMETERS(of.createSECURITYPARAMETERSType());
		profile.getBODY().getSECURITYPARAMETERS().setSECURITYPARAMETER("value");

		profile.getBODY().setCONFIGURATION(of.createCONFIGURATIONType());
		profile.getBODY().getCONFIGURATION().setRSSFEEDINFO(
				of.createRSSFEEDINFOType());

		// TODO: set status
		profile.getBODY().setSTATUS("value");

		profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().setCQLQUERY(  rssFeed.getQueryCql() );				
		profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().setUSERID( rssFeed.getUsedId() );
		profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().setDATEOFLASTVISIT(rssFeed.getLastTimeUsed().toString());
		
		Set<String> docIds = rssFeed.getDocumentIds().keySet();
		for( String docId : docIds ) {
			DOCUMENTSType dType = of.createDOCUMENTSType();
			dType.setDOCUMENTID(docId);
			dType.setISNEW(rssFeed.getDocumentIds().get(docId));
			profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().getDOCUMENTS().add( dType );				
		}
		this.getMarshaller().marshal(profile, baos );
		return baos.toString();

	}

	public RSSFeed XmlToObject(String xml) throws JAXBException {
		RSSFeed rssFeed = new RSSFeed();

		RESOURCEPROFILE profile = (RESOURCEPROFILE) this.getUnmarshaller()
				.unmarshal(new ByteArrayInputStream(xml.getBytes()));

		rssFeed.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER().getValue());
		rssFeed.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());		
		if( profile.getHEADER().getDATEOFCREATION().getValue() != null )
			rssFeed.setDateOfCreation(ConversionUtils.parseDate(profile.getHEADER().getDATEOFCREATION().getValue()));
		rssFeed.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());
		rssFeed.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());

		rssFeed.setUsedId( profile.getBODY().getCONFIGURATION()
				.getRSSFEEDINFO().getUSERID());
		rssFeed.setQueryCql( profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().getCQLQUERY() );
		
		for( DOCUMENTSType docType : profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().getDOCUMENTS() ){
			rssFeed.getDocumentIds().put(docType.getDOCUMENTID(), docType.isISNEW());
		}
		
		return rssFeed;
	}

	public String toXQueryString(SearchCriteria criteria) {
		return this.toXQueryString((RSSFeedSearchCriteria) criteria);
	}

	public String toXQueryString(RSSFeedSearchCriteria criteria) {
		criteria = ConversionUtils.createProxy(criteria);

		String xQuery = null;
		List<String> predicates = new ArrayList<String>();

		xQuery = "for $x in collection( \"/db/DRIVER/RSSFeedDSResources/RSSFeedDSResourceType\" )";
		if (criteria.getCqlQuery() != null) {
			predicates
					.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RSSFEED_INFO/CQLQUERY[@value > \"" +
							criteria.getCqlQuery() );
		}		
		if (criteria.getUserId() != null) {
			predicates
					.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RSSFEED_INFO/USER_ID[@value = \""
							+ criteria.getUserId() + "\"]");

		}
		for (int i = 0; i < predicates.size(); i++) {
			String predicate = predicates.get(i);

			if (i > 0) {
				xQuery += " and ";
			} else {
				xQuery += " where ";
			}

			xQuery += predicate;
		}
		xQuery += " return $x";
		return xQuery;
	}

	@Deprecated
	public String toXQueryString(RSSFeed exampleInstance) {
		throw new UnsupportedOperationException();
	}

}
