package gr.uoa.di.driver.xml;

import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.util.ObjectToXmlConverter;


/**
 * Used to convert a driver resource from java to xml and vice versa. It is IS 
 * specific since it also provides information about the resource type and 
 * converts SearchCriteria to XQueries, specific to the IS storage.
 * 
 * @author <a href='mailto:antleb@di.uoa.gr'>Antonis Lempesis</a>
 *
 * @param <D> the resource type to convert, must implement the Xmlable interface.
 */
public interface ResourceToXmlConverter<D extends DriverResource> 
	extends ObjectToXmlConverter<D> {
	
	/**
	 * Creates an XQuery from the given search criteria.
	 * @param criteria The search criteria.
	 * @return the XQuery...
	 */
	public String toXQueryString(SearchCriteria criteria);
}