package eu.dnetlib.repos;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;

public interface RepoApi {

    Repository getRepository(String id) throws Exception;

    Repository getRepository(String officialName, String id)
            throws Exception;

    String storeRepository(Repository repo, String datatype, List<RepositoryInterface> interfacesToRegister)
            throws Exception;

    String editRepository(Repository repo, String officialNameOld,
                          String idOld, String datatype) throws Exception;

    TreeMap<String, List<Map<String, String>>> getRepositoriesByCountry(
            String collectedFrom) throws Exception;

    Map<String, List<Repository>> getRepositoriesPerCountry(
            String collectedFrom) throws Exception;

    List<Repository> getRepositoriesOfCountry(
            String collectedFrom, String country) throws Exception;

    boolean updateRepositoryInterfaceCompliance(String officialName,
                                                String datasourceId, String interfaceId, String desiredCompliance,
                                                String set, String baseUrl, String oldId) throws Exception;

    List<Repository> getRepositoriesOfUser(String user_mail, Boolean repoAdmin) throws Exception;

    boolean repoIsCompliant(String officialName) throws Exception;

    Map<String, String> getRepoCompatibility(String officialName,
                                             String datasourceId) throws Exception;

    List<String> getUrlsOfRepos(String user_mail, Boolean repoAdmin) throws Exception;

    //EXTENDED

    boolean insertPubFileInterface(String dsId, RepositoryInterface iFace)
            throws Exception;

    boolean updatePubFileInterface(String dsId, RepositoryInterface iFace)
            throws Exception;

    Map<String, Repository> getRepositoriesAsMap(String collectedFrom) throws Exception;

    List<Repository> getRepositories(String collectedFrom)
            throws Exception;

    String getNextScheduledExecution(String mode) throws Exception;

    String getListLatestUpdate(String mode) throws Exception;

    List<Repository> getReposByIds(List<String> datasourceIds) throws Exception;

    void getRepositoryStats(Repository repo) throws Exception;

    String updateRepositoryInformation(Repository repo) throws Exception;

    String deleteRepositoryInterfaces(String dsId,
                                      List<RepositoryInterface> interfaces) throws Exception;

    void deleteRepositoryInterfacesWithoutChecks(String dsId, List<RepositoryInterface> interfaces, String datatype) throws Exception;

    String updateRepositoryInterfaces(String dsId,
                                      List<RepositoryInterface> interfaces,
                                      List<RepositoryInterface> interfacesOld, String datatype,
                                      List<RepositoryInterface> interfacesToRegister) throws Exception;

    RepositoryInterface updateRepositoryInterfaceWithoutChecks(String dsId, RepositoryInterface iFace, String datatype) throws Exception;

    String insertRepositoryInterfaces(String dsId,
                                      List<RepositoryInterface> interfaces,
                                      List<RepositoryInterface> interfacesOld, String datatype,
                                      List<RepositoryInterface> interfacesToRegister) throws Exception;

    RepositoryInterface insertRepositoryInterfaceWithoutChecks(String dsId,
                                                               RepositoryInterface iFace, String datatype)
            throws Exception;

    boolean unregisterRepository(Repository repo) throws Exception;

    List<Map<String, String>> getRegisteredReposByOthers(String string);

    List<Map<String, String>> getRepositoriesOfUser(String user_mail)
            throws Exception;
}