/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.users;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import eu.dnetlib.domain.functionality.UserProfile;
import eu.dnetlib.users.Joomla15PasswordHash;
import eu.dnetlib.users.UserApi;
import java.util.Iterator;
import java.util.UUID;
import org.apache.log4j.Logger;

public class UserApiLdapImpl
implements UserApi {
    transient Logger logger = Logger.getLogger(UserApiLdapImpl.class);
    private int ldapPort = 0;
    private String ldapAddress;
    private String ldapUsername;
    private String ldapPassword;
    private String ldapUsersDN;

    @Override
    public boolean activateUser(String activationId) throws Exception {
        try (LDAPConnection connection = null;){
            this.logger.debug((Object)("activating user with activationId " + activationId));
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"employeeNumber", (String)activationId);
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"uid"});
            SearchResult searchResult = connection.search(searchRequest);
            String dn = null;
            if (searchResult.getSearchEntries().size() > 0) {
                for (SearchResultEntry entry : searchResult.getSearchEntries()) {
                    dn = "uid=" + entry.getAttributeValue("uid") + "," + this.ldapUsersDN;
                }
                Modification mod1 = new Modification(ModificationType.REPLACE, "JoomlaBlockUser", "0");
                Modification mod2 = new Modification(ModificationType.REPLACE, "employeeNumber");
                connection.modify(dn, new Modification[]{mod1, mod2});
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public String addUser(String username, String email, String password, String firstName, String lastName, String institution) throws Exception {
        this.logger.debug((Object)("adding user " + username + " " + email + " to ldap"));
        Attribute cn = new Attribute("cn", username);
        Attribute displayName = new Attribute("displayName", firstName + " " + lastName);
        Attribute mail = new Attribute("mail", email);
        Attribute givenName = new Attribute("givenName", firstName);
        Attribute joomlaBlockUser = new Attribute("JoomlaBlockUser", "1");
        Attribute joomlaGroup = new Attribute("JoomlaGroup", "Registered");
        Attribute objectClass = new Attribute("objectClass", new String[]{"top", "inetOrgPerson", "JoomlaUser"});
        Attribute userPassword = new Attribute("userPassword", Joomla15PasswordHash.create(password));
        Attribute sn = new Attribute("sn", lastName);
        Attribute uid = new Attribute("uid", username);
        String activationId = UUID.randomUUID().toString();
        Attribute x500UniqueIdentifier = new Attribute("employeeNumber", activationId);
        try (LDAPConnection connection = null;){
            Entry entry;
            DN dn = new DN("uid=" + username + "," + this.ldapUsersDN);
            if (institution != null && institution.length() > 0) {
                Attribute o = new Attribute("o", institution);
                entry = new Entry(dn.toNormalizedString(), new Attribute[]{cn, displayName, mail, givenName, joomlaBlockUser, joomlaGroup, objectClass, userPassword, sn, uid, x500UniqueIdentifier, o});
            } else {
                entry = new Entry(dn.toNormalizedString(), new Attribute[]{cn, displayName, mail, givenName, joomlaBlockUser, joomlaGroup, objectClass, userPassword, sn, uid, x500UniqueIdentifier});
            }
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            connection.add(entry);
            String string = activationId;
            return string;
        }
    }

    @Override
    public boolean correctCreds(String email, String password) throws Exception {
        try (LDAPConnection connection = null;){
            this.logger.debug((Object)("checking if user " + email + " entered a correct password when logging in"));
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"mail", (String)email);
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"userPassword"});
            SearchResult searchResult = connection.search(searchRequest);
            for (SearchResultEntry entry : searchResult.getSearchEntries()) {
                if (!Joomla15PasswordHash.check(password, entry.getAttributeValue("userPassword"))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public void editUser(UserProfile user) throws Exception {
        try (LDAPConnection connection = null;){
            this.logger.debug((Object)("editing user " + user.getEmail()));
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"mail", (String)user.getEmail());
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"uid"});
            SearchResult searchResult = connection.search(searchRequest);
            String dn = null;
            for (SearchResultEntry entry : searchResult.getSearchEntries()) {
                dn = "uid=" + entry.getAttributeValue("uid") + "," + this.ldapUsersDN;
            }
            Modification mod1 = new Modification(ModificationType.REPLACE, "displayName", user.getFirstname() + " " + user.getLastname());
            Modification mod2 = new Modification(ModificationType.REPLACE, "givenName", user.getFirstname());
            Modification mod3 = new Modification(ModificationType.REPLACE, "sn", user.getLastname());
            Modification mod4 = new Modification(ModificationType.REPLACE, "o", user.getInstitution());
            connection.modify(dn, new Modification[]{mod1, mod2, mod3, mod4});
        }
    }

    @Override
    public UserProfile getUser(String userIdentifier) throws Exception {
        try (LDAPConnection connection = null;){
            this.logger.debug((Object)("getting user " + userIdentifier + " from ldap"));
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"mail", (String)userIdentifier);
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"mail", "givenName", "sn", "o", "uid"});
            SearchResult searchResult = connection.search(searchRequest);
            UserProfile profile = new UserProfile();
            for (SearchResultEntry entry : searchResult.getSearchEntries()) {
                profile.setEmail(entry.getAttributeValue("mail"));
                profile.setFirstname(entry.getAttributeValue("givenName"));
                profile.setLastname(entry.getAttributeValue("sn"));
                profile.setInstitution(entry.getAttributeValue("o"));
                profile.setUsername(entry.getAttributeValue("uid"));
            }
            UserProfile userProfile = profile;
            return userProfile;
        }
    }

    @Override
    public boolean isAdmin(String email) throws Exception {
        try (LDAPConnection connection = null;){
            this.logger.debug((Object)("checking if user " + email + " is an administrator"));
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"mail", (String)email);
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"JoomlaGroup"});
            SearchResult searchResult = connection.search(searchRequest);
            for (SearchResultEntry entry : searchResult.getSearchEntries()) {
                for (String role : entry.getAttributeValues("JoomlaGroup")) {
                    if (!role.equals("validatorAdmin")) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            this.logger.debug((Object)(email + " is not administrator"));
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean isUserActivated(String email) throws Exception {
        try (LDAPConnection connection = null;){
            this.logger.debug((Object)("checking if user " + email + " is activated"));
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"mail", (String)email);
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"JoomlaBlockUser"});
            SearchResult searchResult = connection.search(searchRequest);
            Iterator iterator = searchResult.getSearchEntries().iterator();
            if (iterator.hasNext()) {
                SearchResultEntry entry = (SearchResultEntry)iterator.next();
                int val = entry.getAttributeValueAsInteger("JoomlaBlockUser");
                if (val == 0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    @Override
    public String prepareResetPassword(String email) throws Exception {
        try (LDAPConnection connection = null;){
            this.logger.debug((Object)("preparing reset password for user " + email));
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"mail", (String)email);
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"uid"});
            SearchResult searchResult = connection.search(searchRequest);
            String dn = null;
            for (SearchResultEntry entry : searchResult.getSearchEntries()) {
                dn = "uid=" + entry.getAttributeValue("uid") + "," + this.ldapUsersDN;
            }
            String uuid = UUID.randomUUID().toString();
            Modification mod = new Modification(ModificationType.REPLACE, "employeeNumber", uuid);
            connection.modify(dn, mod);
            String string = uuid;
            return string;
        }
    }

    @Override
    public void resetPassword(String uuid, String password) throws Exception {
        try (LDAPConnection connection = null;){
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"employeeNumber", (String)uuid);
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"uid"});
            SearchResult searchResult = connection.search(searchRequest);
            String dn = null;
            for (SearchResultEntry entry : searchResult.getSearchEntries()) {
                dn = "uid=" + entry.getAttributeValue("uid") + "," + this.ldapUsersDN;
            }
            Modification mod1 = new Modification(ModificationType.REPLACE, "userPassword", Joomla15PasswordHash.create(password));
            Modification mod2 = new Modification(ModificationType.REPLACE, "employeeNumber");
            connection.modify(dn, new Modification[]{mod1, mod2});
        }
    }

    @Override
    public boolean userExists(String email) throws Exception {
        try (LDAPConnection connection = null;){
            this.logger.debug((Object)("checking if user " + email + " exists in ldap"));
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"mail", (String)email);
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"mail"});
            SearchResult searchResult = connection.search(searchRequest);
            if (!searchResult.getSearchEntries().isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean usernameExists(String username) throws Exception {
        try (LDAPConnection connection = null;){
            this.logger.debug((Object)("checking if user " + username + " exists in ldap"));
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"uid", (String)username);
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"uid"});
            SearchResult searchResult = connection.search(searchRequest);
            if (!searchResult.getSearchEntries().isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public String getEmailFromUsername(String username) throws Exception {
        try (LDAPConnection connection = null;){
            this.logger.debug((Object)("getting email for user " + username));
            connection = new LDAPConnection(this.ldapAddress, this.ldapPort, this.ldapUsername, this.ldapPassword);
            Filter filter = Filter.createEqualityFilter((String)"uid", (String)username);
            SearchRequest searchRequest = new SearchRequest(this.ldapUsersDN, SearchScope.SUB, filter, new String[]{"mail"});
            SearchResult searchResult = connection.search(searchRequest);
            Iterator iterator = searchResult.getSearchEntries().iterator();
            if (iterator.hasNext()) {
                SearchResultEntry entry = (SearchResultEntry)iterator.next();
                String string = entry.getAttributeValue("mail");
                return string;
            }
            iterator = null;
            return iterator;
        }
    }

    public void setLdapPort(int ldapPort) {
        this.ldapPort = ldapPort;
    }

    public void setLdapAddress(String ldapAddress) {
        this.ldapAddress = ldapAddress;
    }

    public void setLdapUsername(String ldapUsername) {
        this.ldapUsername = ldapUsername;
    }

    public void setLdapPassword(String ldapPassword) {
        this.ldapPassword = ldapPassword;
    }

    public void setLdapUsersDN(String ldapUsersDN) {
        this.ldapUsersDN = ldapUsersDN;
    }
}

