/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.islookup;

import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISLookUpServiceException;
import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.SearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class ISLookUpImpl<D extends DriverResource>
implements ISLookUp<D> {
    private static Logger logger = Logger.getLogger(ISLookUpImpl.class);
    private ServiceLocator<ISLookUpService> lookupLocator = null;
    private ResourceToXmlConverter<D> converter = null;

    @Override
    public D getById(String profileId) throws ISLookUpException {
        try {
            String xml = this.lookupLocator.getService().getResourceProfile(profileId);
            logger.debug((Object)("Collection xml..." + xml));
            return this.parseXmlProfile(xml);
        }
        catch (ISLookUpServiceException e) {
            throw new ISLookUpException(e);
        }
    }

    @Override
    public List<D> getByid(String[] profileIds) throws ISLookUpException {
        ArrayList<D> res = new ArrayList<D>();
        for (String id : profileIds) {
            res.add(this.getById(id));
        }
        return res;
    }

    @Override
    public List<D> fetch(SearchCriteria criteria) throws ISLookUpException {
        logger.debug((Object)"Fetching...");
        try {
            String xQuery = this.converter.toXQueryString(criteria);
            logger.debug((Object)("xQuery: " + xQuery));
            List xmls = this.lookupLocator.getService().quickSearchProfile(xQuery);
            ArrayList<D> res = new ArrayList<D>();
            logger.debug((Object)("Getting results from result set. Result set size: " + xmls.size()));
            logger.debug((Object)"starting parsing");
            if (xmls.size() > 0) {
                for (String xml : xmls) {
                    res.add(this.parseXmlProfile(xml));
                }
            }
            logger.debug((Object)"parsed");
            return res;
        }
        catch (ISLookUpServiceException e) {
            logger.error((Object)e);
            throw new ISLookUpException(e);
        }
    }

    private D parseXmlProfile(String xml) throws ISLookUpException {
        try {
            return (D)((DriverResource)this.converter.XmlToObject(xml));
        }
        catch (JAXBException e) {
            throw new ISLookUpException("Error parsing xml profile", e);
        }
        catch (Exception e) {
            logger.error((Object)("Error parsing: " + xml));
            throw new ISLookUpException("Error parsing xml profile", e);
        }
    }

    @Override
    public List<String> fetch(String XQuery) throws ISLookUpException {
        try {
            return this.lookupLocator.getService().quickSearchProfile(XQuery);
        }
        catch (ISLookUpServiceException e) {
            throw new ISLookUpException(e);
        }
    }

    @Override
    public List<D> performQuickSearch(SearchCriteria criteria) throws ISLookUpException {
        try {
            String xQuery = this.converter.toXQueryString(criteria);
            ArrayList<D> results = new ArrayList<D>();
            List xmls = this.lookupLocator.getService().quickSearchProfile(xQuery);
            for (String profile : xmls) {
                results.add(this.parseXmlProfile(profile));
            }
            return results;
        }
        catch (ISLookUpServiceException e) {
            throw new ISLookUpException(e);
        }
    }

    @Override
    public D getUniqueResult(SearchCriteria criteria) throws ISLookUpException {
        List<D> list = this.performQuickSearch(criteria);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (D)((DriverResource)list.get(0));
        }
        throw new ISLookUpException("More than one results in query");
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }

    public void setConverter(ResourceToXmlConverter<D> converter) {
        this.converter = converter;
    }
}

