package eu.dnetlib.utils.cql;

/**
 * @author stoumpos
 * 
 */
public abstract class CqlClause
{
	public static enum CqlClauseType { BOOLEAN, RELATION, TERM };
	
	public final CqlClauseType type;
	
	CqlClause(CqlClauseType type) {
		super();
		this.type = type;
	}
	
	@Override
	public String toString()
	{
		return toCqlString();
	}
	
	public abstract String toCqlString();

	public abstract String toNodeString(String prefix);
}
