package gr.uoa.di.driver.enabling.islookup.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.domain.enabling.SecurityProfileSearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;

public class SecurityAwareCachingISLookUp<D extends SecureDriverResource> extends CachingISLookUp<D> implements ISLookUp<D> {
	static Logger logger = Logger.getLogger(SecurityAwareCachingISLookUp.class);

	private CachingISLookUp<D> lookup = null;
	private ISLookUp<SecurityProfile> securityLookup = null;

	public D getById(String id) throws ISLookUpException {
		logger.debug("Requested object with id " + id);
		D object = lookup.getById(id);
		SecurityProfile secProfile = getSecurityProfile(id);
		
		object.setSecurityProfile(secProfile);
		
		return object;
	}

	public List<D> getByid(String[] ids) throws ISLookUpException {
		List<D> list = new ArrayList<D>();
		Map<String, SecurityProfile> secProfiles = this.getSecurityProfiles(ids);
		
		for (String id : ids) {
			D d = this.getById(id);
			
			d.setSecurityProfile(secProfiles.get(id));
			list.add(d);
		}
		
		return list;
	}

	public List<D> fetch(SearchCriteria criteria) throws ISLookUpException {
		logger.debug("Fetching ...");
		
		List<D> list = this.lookup.fetch(criteria);
		List<String> ids = new ArrayList<String>();
		
		for (D d:list)
			ids.add(d.getResourceId());
		
		Map<String, SecurityProfile> secProfiles = this.getSecurityProfiles(ids.toArray(new String[] {}));
		
		for (D d:list) {
			SecurityProfile secProfile = secProfiles.get(d.getResourceId());
			
			logger.debug("Setting security profile " + 
					secProfile.getResourceId() + " to resource " + 
					d.getResourceId());
			
			d.setSecurityProfile(secProfile);
		}
		
		return list;
	}

	public List<D> performQuickSearch(SearchCriteria criteria)
			throws ISLookUpException {
		logger.debug("Performing quick search...");
		List<D> list = this.lookup.performQuickSearch(criteria);
		List<String> ids = new ArrayList<String>();
		
		for (D d:list)
			ids.add(d.getResourceId());
		
		Map<String, SecurityProfile> secProfiles = this.getSecurityProfiles(ids.toArray(new String[] {}));
		
		for (D d:list)
			d.setSecurityProfile(secProfiles.get(d.getResourceId()));
		
		return list;
	}
	
	public List<String> fetch(String XQuery) {
		throw new UnsupportedOperationException();
	}

	public D getUniqueResult(SearchCriteria criteria) throws ISLookUpException {
		D d = this.lookup.getUniqueResult(criteria);
		
		d.setSecurityProfile(this.getSecurityProfile(d.getResourceId()));
		
		return d;
	}
	
	private SecurityProfile getSecurityProfile(String id) throws ISLookUpException {
		logger.debug("Getting security profile for " + id);
		
		SecurityProfileSearchCriteria crit = new SecurityProfileSearchCriteria();
		
		crit.getDriverResourceIds().add(id);
		
		return securityLookup.getUniqueResult(crit);
	}
	
	private Map<String, SecurityProfile> getSecurityProfiles(String[] ids) throws ISLookUpException {
		logger.debug("Getting security profiles for " + ids.length + " resources");
		
		HashMap<String, SecurityProfile> map = new HashMap<String, SecurityProfile>();
		SecurityProfileSearchCriteria crit = new SecurityProfileSearchCriteria();
		
		for (String id:ids) {
			crit.getDriverResourceIds().add(id);
		}
		
		List<SecurityProfile> list = securityLookup.fetch(crit);
		
		for (SecurityProfile secProfile:list)
			map.put(secProfile.getDriverResourceId(), secProfile);
		
		return map;
	}

	public CachingISLookUp<D> getLookup() {
		return lookup;
	}

	public void setLookup(CachingISLookUp<D> lookup) {
		this.lookup = lookup;
	}

	public ISLookUp<SecurityProfile> getSecurityLookup() {
		return securityLookup;
	}

	public void setSecurityLookup(ISLookUp<SecurityProfile> securityLookup) {
		this.securityLookup = securityLookup;
	}
}
