/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.issn;

import eu.dnetlib.domain.enabling.Notification;
import gr.uoa.di.driver.enabling.issn.NotificationListener;
import gr.uoa.di.driver.enabling.issn.NotificationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class NotificationManagerImpl
implements NotificationManager {
    private static Logger logger = Logger.getLogger(NotificationManagerImpl.class);
    private ExecutorService executor = null;
    private int threads = 2;
    private List<NotificationListener> listeners = new ArrayList<NotificationListener>();

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void init() {
        this.executor = Executors.newFixedThreadPool(this.threads);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(NotificationListener listener) {
        logger.debug((Object)("Adding listener of type " + listener.getClass()));
        List<NotificationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void notify(Notification notification) {
        try {
            logger.debug((Object)("Notification received with type " + notification.getResourceType()));
            this.executor.submit(new NotificationTask(notification));
        }
        catch (Exception e) {
            logger.error((Object)"Error processing notification.", (Throwable)e);
        }
    }

    private class NotificationTask
    implements Runnable {
        private Notification notification = null;

        public NotificationTask(Notification notification) {
            this.notification = notification;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            NotificationListener[] listenerArray = null;
            NotificationListener[] notificationListenerArray = NotificationManagerImpl.this.listeners;
            synchronized (notificationListenerArray) {
                listenerArray = NotificationManagerImpl.this.listeners.toArray(new NotificationListener[0]);
            }
            for (NotificationListener listener : listenerArray) {
                logger.debug((Object)("Notifying listener of type " + listener.getClass().getName() + "with notification type " + this.notification.getResourceType()));
                try {
                    listener.processNotification(this.notification);
                }
                catch (Exception e) {
                    logger.error((Object)"Error notifying listener", (Throwable)e);
                }
            }
        }
    }
}

