/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.xml;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.functionality.RSSFeed;
import eu.dnetlib.domain.functionality.RSSFeedSearchCriteria;
import gr.uoa.di.driver.xml.AbstractConverter;
import gr.uoa.di.driver.xml.ConversionUtils;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import gr.uoa.di.driver.xml.rssfeed.DOCUMENTSType;
import gr.uoa.di.driver.xml.rssfeed.ObjectFactory;
import gr.uoa.di.driver.xml.rssfeed.RESOURCEPROFILE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.bind.JAXBException;

public class RSSFeedXmlConverter
extends AbstractConverter<RSSFeed>
implements ResourceToXmlConverter<RSSFeed> {
    private ObjectFactory of = new ObjectFactory();

    public RSSFeedXmlConverter() throws JAXBException {
        super(RESOURCEPROFILE.class);
    }

    @Override
    public String ObjectToXml(RSSFeed rssFeed) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RESOURCEPROFILE profile = this.of.createRESOURCEPROFILE();
        profile.setHEADER(this.of.createHEADERType());
        profile.setBODY(this.of.createBODYType());
        profile.getHEADER().setRESOURCEIDENTIFIER(this.of.createRESOURCEIDENTIFIERType());
        profile.getHEADER().setRESOURCEKIND(this.of.createRESOURCEKINDType());
        profile.getHEADER().setRESOURCETYPE(this.of.createRESOURCETYPEType());
        profile.getHEADER().setRESOURCEURI(this.of.createRESOURCEURIType());
        profile.getHEADER().setDATEOFCREATION(this.of.createDATEOFCREATIONType());
        profile.getHEADER().getRESOURCEKIND().setValue(rssFeed.getResourceKind());
        profile.getHEADER().getRESOURCETYPE().setValue(rssFeed.getResourceType());
        if (rssFeed.getDateOfCreation() != null) {
            profile.getHEADER().getDATEOFCREATION().setValue(ConversionUtils.DateToString(rssFeed.getDateOfCreation()));
        } else {
            profile.getHEADER().getDATEOFCREATION().setValue("");
        }
        if (rssFeed.getResourceId() != null) {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue(rssFeed.getResourceId());
        } else {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
        }
        if (rssFeed.getResourceUri() != null) {
            profile.getHEADER().getRESOURCEURI().setValue(rssFeed.getResourceUri());
        } else {
            profile.getHEADER().getRESOURCEURI().setValue("");
        }
        profile.getBODY().setSECURITYPARAMETERS(this.of.createSECURITYPARAMETERSType());
        profile.getBODY().getSECURITYPARAMETERS().setSECURITYPARAMETER("value");
        profile.getBODY().setCONFIGURATION(this.of.createCONFIGURATIONType());
        profile.getBODY().getCONFIGURATION().setRSSFEEDINFO(this.of.createRSSFEEDINFOType());
        profile.getBODY().setSTATUS("value");
        profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().setCQLQUERY(rssFeed.getQueryCql());
        profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().setUSERID(rssFeed.getUsedId());
        profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().setDATEOFLASTVISIT(rssFeed.getLastTimeUsed().toString());
        Set docIds = rssFeed.getDocumentIds().keySet();
        for (String docId : docIds) {
            DOCUMENTSType dType = this.of.createDOCUMENTSType();
            dType.setDOCUMENTID(docId);
            dType.setISNEW((Boolean)rssFeed.getDocumentIds().get(docId));
            profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().getDOCUMENTS().add(dType);
        }
        this.getMarshaller().marshal((Object)profile, (OutputStream)baos);
        return baos.toString();
    }

    @Override
    public RSSFeed XmlToObject(String xml) throws JAXBException {
        RSSFeed rssFeed = new RSSFeed();
        RESOURCEPROFILE profile = (RESOURCEPROFILE)this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        rssFeed.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER().getValue());
        rssFeed.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
        if (profile.getHEADER().getDATEOFCREATION().getValue() != null) {
            rssFeed.setDateOfCreation(ConversionUtils.parseDate(profile.getHEADER().getDATEOFCREATION().getValue()));
        }
        rssFeed.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());
        rssFeed.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());
        rssFeed.setUsedId(profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().getUSERID());
        rssFeed.setQueryCql(profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().getCQLQUERY());
        for (DOCUMENTSType docType : profile.getBODY().getCONFIGURATION().getRSSFEEDINFO().getDOCUMENTS()) {
            rssFeed.getDocumentIds().put(docType.getDOCUMENTID(), docType.isISNEW());
        }
        return rssFeed;
    }

    @Override
    public String toXQueryString(SearchCriteria criteria) {
        return this.toXQueryString((RSSFeedSearchCriteria)criteria);
    }

    public String toXQueryString(RSSFeedSearchCriteria criteria) {
        criteria = ConversionUtils.createProxy(criteria);
        String xQuery = null;
        ArrayList<String> predicates = new ArrayList<String>();
        xQuery = "for $x in collection( \"/db/DRIVER/RSSFeedDSResources/RSSFeedDSResourceType\" )";
        if (criteria.getCqlQuery() != null) {
            predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RSSFEED_INFO/CQLQUERY[@value > \"" + criteria.getCqlQuery());
        }
        if (criteria.getUserId() != null) {
            predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/RSSFEED_INFO/USER_ID[@value = \"" + criteria.getUserId() + "\"]");
        }
        for (int i = 0; i < predicates.size(); ++i) {
            String predicate = (String)predicates.get(i);
            xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
            xQuery = xQuery + predicate;
        }
        xQuery = xQuery + " return $x";
        return xQuery;
    }

    @Deprecated
    public String toXQueryString(RSSFeed exampleInstance) {
        throw new UnsupportedOperationException();
    }
}

