package eu.dnetlib.util;

import java.net.MalformedURLException;
import java.net.URL;

public class UtilityFunctions {

	public static boolean isEmpty(String str) {
		return str == null || str.trim().length() == 0;
	}

	/**
	 * Filters a string. Returns the string of "" if the string is null
	 * 
	 * @param str
	 *            the string to be filter
	 * @return the actual string or "" if str is null
	 */
	public static String filterNull(String str) {
		return str == null ? "" : str;
	}

	public static boolean nonEmpty(String str) {
		return !isEmpty(str);
	}

	public static boolean isValidURL(String str) {
		if (isEmpty(str))
			return false;

		boolean valid = true;
		try {
			new URL(str.trim());
		} catch (MalformedURLException e) {
			valid = false;
		}
		return valid;
	}
}
