package gr.uoa.di.driver.enabling;

import java.util.List;

import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SearchCriteria;

/**
 * A client of the ISLookUp service.
 * 
 * @author <a href='mailto:antleb@di.uoa.gr'>Antonis Lempesis</a>
 * 
 * @param <D>
 *            The type of the resource profiles that this client works with.
 */
public interface ISLookUp<D extends DriverResource> {
	/**
	 * Returns the resource profile with the given search id.
	 * 
	 * @param id the id
	 * @return the resource profile.
	 * @throws ISLookUpException
	 */
	D getById(String id) throws ISLookUpException;

	/**
	 * Returns the resource profiles with the given ids.
	 * 
	 * @param id the list of ids.
	 * @return the resource profiles.
	 * @throws ISLookUpException
	 */
	List<D> getByid(String id[]) throws ISLookUpException;

	/**
	 * Performs a search by criteria.
	 * 
	 * @param criteria the search criteria.
	 * @return a list with the results of the query.
	 * @throws ISLookUpException
	 */
	List<D> fetch(SearchCriteria criteria) throws ISLookUpException;

	/**
	 * Performs a direct XQuery search and returns a list of xml profiles that
	 * match the criteria, without any processing.
	 * 
	 * @param XQuery the xquery.
	 * @return a list of xml profiles.
	 * @throws ISLookUpException
	 */
	List<String> fetch(String XQuery) throws ISLookUpException;

	/**
	 * Uses the appropriate method in ISLookUp and performs a query without
	 * using a result set. This method should be used only when a small number
	 * of results is expected. If there is a large number of results, there is a
	 * risk of a SOAP error (the respone will be too large, over the SOAP
	 * limit).
	 * 
	 * @param criteria the search criteria.
	 * @return a list of results.
	 * @throws ISLookUpException
	 */
	List<D> performQuickSearch(SearchCriteria criteria)
			throws ISLookUpException;

	/**
	 * Performs a quick search and returns the unique result.
	 * 
	 * @param criteria the search criteria.
	 * @return the unique search result
	 * @throws ISLookUpException if there is more than one result.
	 */
	D getUniqueResult(SearchCriteria criteria) throws ISLookUpException;
}