package gr.uoa.di.driver.enabling.islookup.cache;

import java.util.List;

import net.sf.ehcache.constructs.blocking.CacheEntryFactory;

import org.apache.log4j.Logger;

import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.api.enabling.ISLookUpServiceException;
import eu.dnetlib.domain.DriverResource;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import gr.uoa.di.driver.util.ServiceLocator;

public class LookUpEntryFactory<D extends DriverResource> implements
		CacheEntryFactory {
	private Logger logger = Logger.getLogger(this.getClass());
	private ServiceLocator<ISLookUpService> lookUpServiceLocator = null;
	private ResultSetFactory rsFactory = null;

	public Object createEntry(Object key) throws Exception {
		Object entry = null;

		if (key instanceof String) {
			entry = this.getById((String) key);
		} else if (key instanceof CriteriaCacheKey) {
			CriteriaCacheKey args = (CriteriaCacheKey) key;
			String XQuery = args.getXQuery();
			
			entry = this.getByCriteria(XQuery);
		} else {
			logger.warn("key is not id or query");
			logger.warn("key is: " + key + "(" + key.getClass() + ")");
		}

		return entry;
	}

	private List<String> getByCriteria(String XQuery) throws ISLookUpServiceException {
				return lookUpServiceLocator.getService().quickSearchProfile(XQuery);
	}

	private String getById(String key) throws ISLookUpServiceException {
		return lookUpServiceLocator.getService().getResourceProfile(key);
	}

	public ServiceLocator<ISLookUpService> getLookUpServiceLocator() {
		return lookUpServiceLocator;
	}

	public void setLookUpServiceLocator(
			ServiceLocator<ISLookUpService> lookUpServiceLocator) {
		this.lookUpServiceLocator = lookUpServiceLocator;
	}

	public void setRsFactory(ResultSetFactory rsFactory) {
		this.rsFactory = rsFactory;
	}
}
