/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repos.ehcacher;

import eu.dnetlib.repos.ehcacher.CacheWrapper;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;

public class EhcacheWrapper<K, V>
implements CacheWrapper<K, V> {
    private final String cacheName;
    private final CacheManager cacheManager;
    private Logger logger = Logger.getLogger(EhcacheWrapper.class);

    public EhcacheWrapper(String cacheName, CacheManager cacheManager) {
        this.cacheName = cacheName;
        this.cacheManager = cacheManager;
        this.logger.debug((Object)("ehcacheWrapper created with name: " + cacheName + "and cachemanager: " + cacheManager));
    }

    @Override
    public void put(K key, V value) {
        this.getCache().put(new Element(key, value));
    }

    @Override
    public V get(K key) {
        Element element = this.getCache().get(key);
        if (element != null) {
            return (V)element.getObjectValue();
        }
        return null;
    }

    public Ehcache getCache() {
        return this.cacheManager.getEhcache(this.cacheName);
    }

    public int size() {
        return this.getCache().getSize();
    }
}

