/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.app;

import eu.dnetlib.domain.EPR;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.registration.ServiceRegistrationManagerImpl;
import eu.dnetlib.enabling.tools.registration.ServiceRegistrator;
import eu.dnetlib.enabling.tools.registration.ValidatingServiceRegistrationManagerImpl;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import eu.dnetlib.utils.EPRUtils;
import gr.uoa.di.driver.app.DriverServiceImpl;
import javax.xml.ws.Endpoint;
import org.apache.log4j.Logger;

public class InitialiazingServiceRegistrationManager
extends ValidatingServiceRegistrationManagerImpl {
    private static Logger logger = Logger.getLogger(InitialiazingServiceRegistrationManager.class);
    private EndpointReferenceBuilder<Endpoint> eprBuilder = null;
    private boolean removeRegistration = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        ServiceRegistrator serviceRegistrator = this.getRegistrator();
        synchronized (serviceRegistrator) {
            DriverServiceImpl service = (DriverServiceImpl)this.getService();
            if (this.getState() == ServiceRegistrationManagerImpl.State.REGISTERED && !service.isInititialized()) {
                logger.debug((Object)"Service is registered and unitialized. Initializing.");
                EPR epr = this.createEPR();
                epr.setParameter("serviceId", this.getProfileId());
                service.setServiceEPR(epr);
                service.init();
            }
        }
        super.tick();
    }

    public void destroy() {
        try {
            if (this.removeRegistration) {
                logger.debug((Object)"Removing service registration");
                ((ISRegistryService)this.getRegistrator().getServiceLocator().getService(ISRegistryService.class)).deleteProfile(this.getProfileId());
            }
        }
        catch (ISRegistryException e) {
            logger.error((Object)"Error removing service registration", (Throwable)e);
        }
    }

    private EPR createEPR() {
        return EPRUtils.createEPR(this.eprBuilder, this.getEndpoint());
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public boolean isRemoveRegistration() {
        return this.removeRegistration;
    }

    public void setRemoveRegistration(boolean removeRegistration) {
        this.removeRegistration = removeRegistration;
    }
}

