/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.enabling.islookup.cache;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.domain.enabling.SecurityProfileSearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;
import gr.uoa.di.driver.enabling.islookup.cache.CachingISLookUp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SecurityAwareCachingISLookUp<D extends SecureDriverResource>
extends CachingISLookUp<D>
implements ISLookUp<D> {
    static Logger logger = Logger.getLogger(SecurityAwareCachingISLookUp.class);
    private CachingISLookUp<D> lookup = null;
    private ISLookUp<SecurityProfile> securityLookup = null;

    @Override
    public D getById(String id) throws ISLookUpException {
        logger.debug((Object)("Requested object with id " + id));
        SecureDriverResource object = (SecureDriverResource)this.lookup.getById(id);
        SecurityProfile secProfile = this.getSecurityProfile(id);
        object.setSecurityProfile(secProfile);
        return (D)object;
    }

    @Override
    public List<D> getByid(String[] ids) throws ISLookUpException {
        ArrayList<D> list = new ArrayList<D>();
        Map<String, SecurityProfile> secProfiles = this.getSecurityProfiles(ids);
        for (String id : ids) {
            D d = this.getById(id);
            d.setSecurityProfile(secProfiles.get(id));
            list.add(d);
        }
        return list;
    }

    @Override
    public List<D> fetch(SearchCriteria criteria) throws ISLookUpException {
        logger.debug((Object)"Fetching ...");
        List<D> list = this.lookup.fetch(criteria);
        ArrayList<String> ids = new ArrayList<String>();
        for (SecureDriverResource d : list) {
            ids.add(d.getResourceId());
        }
        Map<String, SecurityProfile> secProfiles = this.getSecurityProfiles(ids.toArray(new String[0]));
        for (SecureDriverResource d : list) {
            SecurityProfile secProfile = secProfiles.get(d.getResourceId());
            logger.debug((Object)("Setting security profile " + secProfile.getResourceId() + " to resource " + d.getResourceId()));
            d.setSecurityProfile(secProfile);
        }
        return list;
    }

    @Override
    public List<D> performQuickSearch(SearchCriteria criteria) throws ISLookUpException {
        logger.debug((Object)"Performing quick search...");
        List<D> list = this.lookup.performQuickSearch(criteria);
        ArrayList<String> ids = new ArrayList<String>();
        for (SecureDriverResource d : list) {
            ids.add(d.getResourceId());
        }
        Map<String, SecurityProfile> secProfiles = this.getSecurityProfiles(ids.toArray(new String[0]));
        for (SecureDriverResource d : list) {
            d.setSecurityProfile(secProfiles.get(d.getResourceId()));
        }
        return list;
    }

    @Override
    public List<String> fetch(String XQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public D getUniqueResult(SearchCriteria criteria) throws ISLookUpException {
        SecureDriverResource d = (SecureDriverResource)this.lookup.getUniqueResult(criteria);
        d.setSecurityProfile(this.getSecurityProfile(d.getResourceId()));
        return (D)d;
    }

    private SecurityProfile getSecurityProfile(String id) throws ISLookUpException {
        logger.debug((Object)("Getting security profile for " + id));
        SecurityProfileSearchCriteria crit = new SecurityProfileSearchCriteria();
        crit.getDriverResourceIds().add(id);
        return this.securityLookup.getUniqueResult((SearchCriteria)crit);
    }

    private Map<String, SecurityProfile> getSecurityProfiles(String[] ids) throws ISLookUpException {
        logger.debug((Object)("Getting security profiles for " + ids.length + " resources"));
        HashMap<String, SecurityProfile> map = new HashMap<String, SecurityProfile>();
        SecurityProfileSearchCriteria crit = new SecurityProfileSearchCriteria();
        for (String id : ids) {
            crit.getDriverResourceIds().add(id);
        }
        List<SecurityProfile> list = this.securityLookup.fetch((SearchCriteria)crit);
        for (SecurityProfile secProfile : list) {
            map.put(secProfile.getDriverResourceId(), secProfile);
        }
        return map;
    }

    public CachingISLookUp<D> getLookup() {
        return this.lookup;
    }

    public void setLookup(CachingISLookUp<D> lookup) {
        this.lookup = lookup;
    }

    public ISLookUp<SecurityProfile> getSecurityLookup() {
        return this.securityLookup;
    }

    public void setSecurityLookup(ISLookUp<SecurityProfile> securityLookup) {
        this.securityLookup = securityLookup;
    }
}

