/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.xml;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.data.MDFormatDataStructure;
import eu.dnetlib.domain.functionality.LayoutField;
import eu.dnetlib.domain.functionality.MDFormatSearchCriteria;
import gr.uoa.di.driver.xml.AbstractConverter;
import gr.uoa.di.driver.xml.ConversionUtils;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import gr.uoa.di.driver.xml.mdformat.RESOURCEPROFILE;
import gr.uoa.di.driver.xml.mdformat.STATUSType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;

public class MDFormatDSXmlConverter
extends AbstractConverter<MDFormatDataStructure>
implements ResourceToXmlConverter<MDFormatDataStructure> {
    static Logger logger = Logger.getLogger(MDFormatDSXmlConverter.class);

    public MDFormatDSXmlConverter() throws JAXBException {
        super(RESOURCEPROFILE.class);
    }

    @Override
    public String ObjectToXml(MDFormatDataStructure object) throws JAXBException {
        throw new UnsupportedOperationException("Only xml to object operation is supported");
    }

    @Override
    public MDFormatDataStructure XmlToObject(String xml) throws JAXBException {
        MDFormatDataStructure mdFormat = new MDFormatDataStructure();
        RESOURCEPROFILE profile = this.setObjectHeader(xml, mdFormat);
        this.setObjectBody(mdFormat, profile);
        return mdFormat;
    }

    private RESOURCEPROFILE setObjectHeader(String xml, MDFormatDataStructure mdFormat) throws JAXBException {
        RESOURCEPROFILE profile = (RESOURCEPROFILE)this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        mdFormat.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
        mdFormat.setDateOfCreation(this.toDate(profile.getHEADER().getDATEOFCREATION().getValue()));
        mdFormat.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());
        mdFormat.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());
        return profile;
    }

    public Date toDate(XMLGregorianCalendar calendar) {
        return calendar.toGregorianCalendar().getTime();
    }

    private void setObjectBody(MDFormatDataStructure mdFormat, RESOURCEPROFILE profile) {
        mdFormat.setResourceName(profile.getBODY().getCONFIGURATION().getNAME());
        for (STATUSType.LAYOUTS.LAYOUT l : profile.getBODY().getSTATUS().getLAYOUTS().getLAYOUT()) {
            ArrayList<LayoutField> fields = new ArrayList<LayoutField>();
            for (STATUSType.LAYOUTS.LAYOUT.FIELDS.FIELD f : l.getFIELDS().getFIELD()) {
                LayoutField field = new LayoutField();
                field.setName(f.getName());
                field.setXpath(f.getXpath());
                field.setIndexable(f.isIndexable());
                field.setResult(f.isResult());
                field.setType(f.getType());
                field.setStat(f.isStat().booleanValue());
                if (f.isTokenizable() != null) {
                    field.setTokenizable(f.isTokenizable().booleanValue());
                } else {
                    field.setTokenizable(false);
                }
                fields.add(field);
            }
            mdFormat.getLayouts().put(l.getName(), fields);
        }
    }

    @Override
    public String toXQueryString(SearchCriteria criteria) {
        return this.toXQueryString((MDFormatSearchCriteria)criteria);
    }

    @Deprecated
    public String toXQueryString(MDFormatDataStructure exampleInstance) {
        String xQuery = "for $x in collection( \"/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType\" )";
        ArrayList<String> predicates = new ArrayList<String>();
        if (exampleInstance != null) {
            if (exampleInstance.getResourceName() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME[.=\"" + exampleInstance.getResourceName() + "\"]");
            }
            for (int i = 0; i < predicates.size(); ++i) {
                String predicate = (String)predicates.get(i);
                xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
                xQuery = xQuery + predicate;
            }
        }
        xQuery = xQuery + " return $x";
        logger.debug((Object)xQuery);
        return xQuery;
    }

    public String toXQueryString(MDFormatSearchCriteria criteria) {
        criteria = ConversionUtils.createProxy(criteria);
        String xQuery = null;
        ArrayList<String> predicates = new ArrayList<String>();
        xQuery = "for $x in collection( \"/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType\" )";
        if (criteria.getMDFormatName() != null) {
            predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME[.= \"" + criteria.getMDFormatName() + "\"]");
        }
        for (int i = 0; i < predicates.size(); ++i) {
            String predicate = (String)predicates.get(i);
            xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
            xQuery = xQuery + predicate;
        }
        xQuery = xQuery + " return $x";
        logger.debug((Object)xQuery);
        return xQuery;
    }
}

