/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.xml;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.domain.enabling.SecurityProfileSearchCriteria;
import gr.uoa.di.driver.xml.AbstractConverter;
import gr.uoa.di.driver.xml.ConversionUtils;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import gr.uoa.di.driver.xml.security.ObjectFactory;
import gr.uoa.di.driver.xml.security.RESOURCEPROFILE;
import gr.uoa.di.driver.xml.security.TypedString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.bind.JAXBException;

public class SecurityProfileXmlConverter
extends AbstractConverter<SecurityProfile>
implements ResourceToXmlConverter<SecurityProfile> {
    private ObjectFactory of = new ObjectFactory();

    public SecurityProfileXmlConverter() throws JAXBException {
        super(RESOURCEPROFILE.class);
    }

    @Override
    public String ObjectToXml(SecurityProfile object) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RESOURCEPROFILE profile = this.of.createRESOURCEPROFILE();
        profile.setHEADER(this.of.createHEADERType());
        profile.setBODY(this.of.createBODYType());
        profile.getHEADER().setRESOURCEIDENTIFIER(this.of.createRESOURCEIDENTIFIERType());
        profile.getHEADER().setDATEOFCREATION(this.of.createDATEOFCREATIONType());
        profile.getHEADER().setRESOURCEKIND(this.of.createRESOURCEKINDType());
        profile.getHEADER().setRESOURCETYPE(this.of.createRESOURCETYPEType());
        profile.getHEADER().setRESOURCEURI(this.of.createRESOURCEURIType());
        profile.getHEADER().getRESOURCETYPE().setValue(object.getResourceType());
        profile.getHEADER().getRESOURCEKIND().setValue(object.getResourceKind());
        if (object.getDateOfCreation() != null) {
            profile.getHEADER().getDATEOFCREATION().setValue(ConversionUtils.DateToString(object.getDateOfCreation()));
        } else {
            profile.getHEADER().getDATEOFCREATION().setValue("");
        }
        if (object.getResourceId() != null) {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue(object.getResourceId());
        } else {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
        }
        if (object.getResourceUri() != null) {
            profile.getHEADER().getRESOURCEURI().setValue(object.getResourceUri());
        } else {
            profile.getHEADER().getRESOURCEURI().setValue("");
        }
        profile.getBODY().setCONFIGURATION(this.of.createCONFIGURATIONType());
        if (object.getDriverResourceId() != null) {
            profile.getBODY().getCONFIGURATION().setResourceId(object.getDriverResourceId());
        } else {
            profile.getBODY().getCONFIGURATION().setResourceId(" ");
        }
        for (String role : object.getIdentities()) {
            TypedString identity = new TypedString();
            identity.setType("driver.security.identity.role");
            identity.setText("driver.security.identity.role#" + role);
            profile.getBODY().getCONFIGURATION().getIdentities().add(identity);
        }
        TypedString string = new TypedString();
        string.setText(object.getPassword());
        string.setType("password");
        profile.getBODY().getCONFIGURATION().getIdentities().add(string);
        this.getMarshaller().marshal((Object)profile, (OutputStream)baos);
        return baos.toString();
    }

    @Override
    public SecurityProfile XmlToObject(String xml) throws JAXBException {
        SecurityProfile profile = new SecurityProfile();
        RESOURCEPROFILE resource = (RESOURCEPROFILE)this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        profile.setResourceId(resource.getHEADER().getRESOURCEIDENTIFIER().getValue());
        profile.setResourceUri(resource.getHEADER().getRESOURCEURI().getValue());
        profile.setResourceKind(resource.getHEADER().getRESOURCEKIND().getValue());
        profile.setResourceType(resource.getHEADER().getRESOURCETYPE().getValue());
        profile.setDateOfCreation(ConversionUtils.parseDate(resource.getHEADER().getDATEOFCREATION().getValue()));
        profile.setDriverResourceId(resource.getBODY().getCONFIGURATION().getResourceId());
        for (TypedString identity : resource.getBODY().getCONFIGURATION().getIdentities()) {
            if (identity.getType().toLowerCase().equals("driver.security.identity.role")) {
                profile.getIdentities().add(identity.getText().substring("driver.security.identity.role".length() + 1));
                continue;
            }
            if (!identity.getType().toLowerCase().equals("password")) continue;
            profile.setPassword(identity.getText());
        }
        return profile;
    }

    public String toXQueryString(SecurityProfileSearchCriteria criteria) {
        criteria = ConversionUtils.createProxy(criteria);
        String xQuery = "for $x in collection(\"/db/DRIVER/SecurityProfileDSResources/SecurityProfileDSResourceType\")";
        List resourceIds = criteria.getDriverResourceIds();
        if (resourceIds != null && resourceIds.size() > 0) {
            xQuery = xQuery + " where ";
            xQuery = xQuery + " $x/RESOURCE_PROFILE/BODY/CONFIGURATION[";
            for (int i = 0; i < resourceIds.size(); ++i) {
                String resourceId = (String)resourceIds.get(i);
                if (i > 0) {
                    xQuery = xQuery + " or ";
                }
                xQuery = xQuery + "resourceId = \"" + resourceId + "\"";
            }
            xQuery = xQuery + "]";
        }
        xQuery = xQuery + " return $x";
        return xQuery;
    }

    @Override
    public String toXQueryString(SearchCriteria criteria) {
        return this.toXQueryString((SecurityProfileSearchCriteria)criteria);
    }
}

