/**
 * 
 */
package eu.dnetlib.utils.cql;



/**
 * @author stoumpos
 * 
 */
public class CqlBoolean extends CqlClause {

	String operator = null;
	CqlClause left = null;
	CqlClause right = null;

	public CqlBoolean() {
		this(null, null, null);
	}

	public CqlBoolean(CqlClause left, String operator, CqlClause right) {
		super(CqlClauseType.BOOLEAN);
		this.operator = operator;
		this.left = left;
		this.right = right;
	}

	public CqlClause getLeft() {
		return left;
	}

	public void setLeft(CqlClause left) {
		this.left = left;
	}

	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public CqlClause getRight() {
		return right;
	}

	public void setRight(CqlClause right) {
		this.right = right;
	}
	
	@Override
	public String toCqlString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("(").append(left).append(") ").append(operator);
		buffer.append(" (").append(right).append(")");
		return buffer.toString();
	}

	@Override
	public String toNodeString(String prefix) {
		StringBuffer buffer = new StringBuffer();
		buffer.append(prefix).append(operator).append("\n");
		buffer.append(left.toNodeString(prefix + "\t")).append("\n");
		buffer.append(right.toNodeString(prefix + "\t")).append("\n");
		return buffer.toString();
	}
}
