package gr.uoa.di.driver.enabling.issn;

import eu.dnetlib.domain.enabling.Notification;

/**
 * A class to manage notifications from the IS. A common use case is to delegate
 * the calls from the IS to a manager instance and subscribe listeners to the
 * manager in order to get Notification objects.
 * The advantage of the manager is that it can queue the notifications and add
 * less overhead to the ISSNService.
 *  
 * @author <a href="mailto:antleb@di.uoa.gr">Antonis Lempesis</a>
 *
 */
public interface NotificationManager {

	public void notify(Notification notification);
	
	public void addListener(NotificationListener listener);
}
