package gr.uoa.di.driver.xml;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import eu.dnetlib.domain.DriverResource;

public abstract class AbstractConverter<R extends DriverResource> implements ResourceToXmlConverter<R> {
	
	private JAXBContext jc = null;
	
	public AbstractConverter(Class<?>... resourceClass) throws JAXBException {
		this.jc = JAXBContext.newInstance(resourceClass);
	}
	
	protected Marshaller getMarshaller() throws JAXBException {
		return jc.createMarshaller();
	}

	protected Unmarshaller getUnmarshaller() throws JAXBException {
		return jc.createUnmarshaller();
	}
}
