/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.repos;

import eu.dnetlib.api.data.DatasourceManagerService;
import eu.dnetlib.api.data.DatasourceManagerServiceException;
import eu.dnetlib.domain.data.Repository;
import eu.dnetlib.domain.data.RepositoryInterface;
import eu.dnetlib.repos.RepoApi;
import eu.dnetlib.repos.RepoTools;
import gr.uoa.di.driver.util.ServiceLocator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.log4j.Logger;

public class RepoApiDmsImpl
implements RepoApi {
    private static Logger logger = Logger.getLogger(RepoApiDmsImpl.class);
    private final String[] filterKeys = new String[]{"openaire____::opendoar", "openaire____::re3data", "infrastruct_::openaire"};
    private ServiceLocator<DatasourceManagerService> dmService = null;

    @Override
    public Repository getRepository(String id) throws Exception {
        return this.getRepository(null, id);
    }

    @Override
    public Repository getRepository(String officialName, String id) throws Exception {
        logger.info((Object)("getting repository with name " + officialName + " and id: " + id + " from dms"));
        Repository retRepo = null;
        try {
            retRepo = this.dmService.getService().getDatasource(id);
        }
        catch (DatasourceManagerServiceException e) {
            logger.error((Object)("Error getting repository with name " + officialName + " and id: " + id + " from dms"), (Throwable)e);
        }
        return retRepo;
    }

    @Override
    public void getRepositoryStats(Repository repo) throws Exception {
        logger.info((Object)("getting repository stats for : " + repo.getOfficialName() + " from dms"));
        try {
            this.dmService.getService().findNextScheduledExecution(repo.getId(), ((RepositoryInterface)repo.getInterfaces().get(0)).getId());
        }
        catch (DatasourceManagerServiceException e) {
            logger.error((Object)("Error getting repo stats for : " + repo.getOfficialName() + " from openaire db"), (Throwable)e);
        }
    }

    @Override
    public String getListLatestUpdate(String mode) throws Exception {
        String date = null;
        try {
            logger.info((Object)("getting last collection date for " + mode));
            date = (String)((RepositoryInterface)this.dmService.getService().getDatasource("openaire____::" + mode).getInterfaces().get(0)).getExtraFields().get("last_collection_date");
            logger.debug((Object)("last collection date for opendoar: " + date));
        }
        catch (DatasourceManagerServiceException e) {
            logger.error((Object)"Error getting last update date", (Throwable)e);
        }
        return date;
    }

    @Override
    public String getNextScheduledExecution(String mode) throws Exception {
        String date = null;
        try {
            date = (String)((RepositoryInterface)this.dmService.getService().getDatasource("openaire____::" + mode).getInterfaces().get(0)).getExtraFields().get("last_collection_date");
            logger.debug((Object)("last collection date for opendoar: " + date));
            Date date1 = this.dmService.getService().findNextScheduledExecution("opendoar____::2367", "api_________::opendoar____::2367::0");
            logger.debug((Object)("next scheduled for opendoar: " + date1));
        }
        catch (DatasourceManagerServiceException e) {
            logger.error((Object)"Error getting repo stats for opendoar", (Throwable)e);
        }
        return date;
    }

    @Override
    public String storeRepository(Repository repo, String datatype, List<RepositoryInterface> interfacesToRegister) throws Exception {
        String retMessage = null;
        logger.info((Object)("storing " + datatype + " repository with id: " + repo.getId()));
        try {
            Date utilDate = new Date();
            Timestamp date = new Timestamp(utilDate.getTime());
            if (datatype.equalsIgnoreCase("opendoar") || datatype.equalsIgnoreCase("re3data")) {
                String updateQuery = "UPDATE datasources SET englishname = '" + repo.getEnglishName() + "', logourl = '" + repo.getLogoUrl() + "', timezone = '" + repo.getTimezone() + "', registeredby = '" + repo.getRegisteredBy() + "', activationid = '" + repo.getActivationId() + "', contactemail = '" + repo.getContactEmail() + "', datasourceclass = '" + repo.getDatasourceClass() + "' WHERE id = '" + repo.getId() + "'";
                if (this.dmService.getService().updateSQL(repo.getId(), updateQuery, false)) {
                    logger.debug((Object)"updated successfully");
                } else {
                    logger.error((Object)("error while updating: " + updateQuery));
                }
            } else if (datatype.equalsIgnoreCase("journal") || datatype.equalsIgnoreCase("aggregator")) {
                logger.debug((Object)("looking if " + datatype + " " + repo.getOfficialName() + " is already in datasources"));
                if (this.dmService.getService().getDatasource(repo.getId()) != null) {
                    retMessage = datatype + " '" + repo.getOfficialName() + "' is already in datasources.";
                    repo.getInterfaces().clear();
                    logger.debug((Object)retMessage);
                } else {
                    logger.debug((Object)(datatype + " " + repo.getOfficialName() + " is not in datasources. Inserting.."));
                    repo.setDateOfCollection((Date)date);
                    repo.setAggregator("OPENAIRE");
                    try {
                        if (this.dmService.getService().addDatasource(repo)) {
                            logger.debug((Object)"inserted successfully");
                        } else {
                            logger.error((Object)"error while inserting");
                        }
                    }
                    catch (DatasourceManagerServiceException e) {
                        logger.error((Object)("error while inserting" + (Object)((Object)e)));
                    }
                }
            }
            logger.debug((Object)"Inserting Interfaces");
            for (RepositoryInterface iFace : repo.getInterfaces()) {
                if (iFace.getBaseUrl().isEmpty() || iFace.getDesiredCompatibilityLevel().isEmpty()) continue;
                if (iFace.getId() != null && !iFace.getId().isEmpty()) {
                    logger.debug((Object)"updating iface..");
                    this.dmService.getService().updateBaseUrl(repo.getId(), iFace.getId(), iFace.getBaseUrl());
                    if (!iFace.getAccessSet().isEmpty()) {
                        logger.debug((Object)("set not empty: " + iFace.getAccessSet()));
                        this.dmService.getService().updateAccessParam(repo.getId(), iFace.getId(), "set", iFace.getAccessSet(), false);
                    } else {
                        this.dmService.getService().deleteAccessParamOrExtraField(repo.getId(), iFace.getId(), "set");
                    }
                    this.dmService.getService().updateContentDescription(repo.getId(), iFace.getId(), "metadata");
                    if (datatype.equals("re3data")) {
                        this.dmService.getService().updateAccessParam(repo.getId(), iFace.getId(), "format", "oai_datacite", false);
                        iFace.setAccessFormat("oai_datacite");
                    } else {
                        this.dmService.getService().updateAccessParam(repo.getId(), iFace.getId(), "format", "oai_dc", false);
                        iFace.setAccessFormat("oai_dc");
                    }
                    logger.debug((Object)"updated successfully");
                } else {
                    logger.debug((Object)"adding new iface..");
                    iFace.setContentDescription("metadata");
                    iFace.setCompliance("UNKNOWN");
                    if (datatype.equals("re3data")) {
                        iFace.setAccessFormat("oai_datacite");
                    } else {
                        iFace.setAccessFormat("oai_dc");
                    }
                    if (repo.getDatasourceClass() != null && !repo.getDatasourceClass().isEmpty()) {
                        iFace.setTypology(repo.getDatasourceClass());
                    } else if (datatype.equalsIgnoreCase("journal")) {
                        iFace.setTypology("pubsrepository::journal");
                    } else if (datatype.equalsIgnoreCase("aggregator")) {
                        iFace.setTypology("aggregator::pubsrepository::unknown");
                    } else if (datatype.equalsIgnoreCase("opendoar")) {
                        iFace.setTypology("pubsrepository::unknown");
                    } else if (datatype.equalsIgnoreCase("re3data")) {
                        iFace.setTypology("datarepository::unknown");
                    }
                    iFace.setRemovable(true);
                    iFace.setAccessProtocol("oai");
                    iFace.setMetadataIdentifierPath("//*[local-name()='header']/*[local-name()='identifier']");
                    iFace.setId("api_________::" + repo.getId() + "::" + UUID.randomUUID().toString().substring(0, 8));
                    if (iFace.getAccessSet().isEmpty()) {
                        logger.debug((Object)("set is empty: " + iFace.getAccessSet()));
                        iFace.removeAccessSet();
                    }
                    logger.debug((Object)("new ifaceId :" + iFace.getId()));
                    if (this.dmService.getService().addInterface(repo.getId(), iFace)) {
                        logger.debug((Object)"added successfully");
                    } else {
                        logger.error((Object)"error while adding");
                    }
                }
                interfacesToRegister.add(iFace);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error storing repo " + repo.getOfficialName() + " in dms"), (Throwable)e);
            throw e;
        }
        logger.debug((Object)("Finished storing " + datatype + " repository with id: " + repo.getId()));
        return retMessage;
    }

    @Override
    public String editRepository(Repository repo, String officialNameOld, String idOld, String datatype) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Repository> getRepositories(String collectedFrom) throws Exception {
        ArrayList<Repository> repoList = new ArrayList();
        try {
            logger.info((Object)("getting repos from dms with collected from value: " + collectedFrom));
            repoList = this.dmService.getService().listDatasourcesUsingFilter(null, null, null, collectedFrom);
        }
        catch (DatasourceManagerServiceException e) {
            logger.error((Object)("Error getting repos from dms with collected from value: " + collectedFrom), (Throwable)e);
            throw e;
        }
        return repoList;
    }

    @Override
    public Map<String, Repository> getRepositoriesAsMap(String collectedFrom) throws Exception {
        List repoList = new ArrayList();
        HashMap<String, Repository> repoMap = new HashMap<String, Repository>();
        try {
            logger.info((Object)("getting repos from dms with collected from value: " + collectedFrom));
            repoList = this.dmService.getService().listDatasourcesUsingFilter(null, null, null, collectedFrom);
            for (Repository repo : repoList) {
                repoMap.put(repo.getId(), repo);
            }
        }
        catch (DatasourceManagerServiceException e) {
            logger.error((Object)("Error getting repos from dms with collected from value: " + collectedFrom), (Throwable)e);
            throw e;
        }
        return repoMap;
    }

    @Override
    public List<Map<String, String>> getRegisteredReposByOthers(String user_mail) {
        List<Map<String, String>> res = new ArrayList<Map<String, String>>();
        try {
            logger.info((Object)("getting repos by others for user : " + user_mail));
            res = this.getReposAsMap(user_mail, true);
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repos by others for user : " + user_mail), (Throwable)e);
        }
        return res;
    }

    @Override
    public List<Map<String, String>> getRepositoriesOfUser(String user_mail) throws Exception {
        logger.info((Object)("getting repos for user : " + user_mail));
        return this.getReposAsMap(user_mail, false);
    }

    private List<Map<String, String>> getReposAsMap(String user_mail, Boolean isAdmin) throws Exception {
        logger.info((Object)("getting repos as map for user: " + user_mail));
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>();
        try {
            for (Repository repo : this.getRepositoriesOfUser(user_mail, isAdmin)) {
                HashMap<String, String> rep = new HashMap<String, String>();
                rep.put("name", repo.getOfficialName());
                rep.put("id", repo.getId());
                rep.put("url", repo.getWebsiteUrl());
                rep.put("mode", repo.getDatasourceType());
                rep.put("registered", repo.isRegistered() != false ? "yes" : "no");
                res.add(rep);
            }
        }
        catch (Exception e) {
            logger.error((Object)("getting repos as map for user: " + user_mail), (Throwable)e);
        }
        return res;
    }

    @Override
    public TreeMap<String, List<Map<String, String>>> getRepositoriesByCountry(String collectedFrom) throws Exception {
        ArrayList<Repository> repoList = new ArrayList();
        TreeMap<String, List<Map<String, String>>> res = new TreeMap();
        try {
            logger.info((Object)("getting repos by country from dms with key: " + collectedFrom));
            repoList = this.getRepositories(RepoTools.getFilterKey(collectedFrom));
            res = RepoTools.splitReposByCountry(repoList);
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repositories from dms with key: " + collectedFrom), (Throwable)e);
            throw e;
        }
        return res;
    }

    @Override
    public Map<String, List<Repository>> getRepositoriesPerCountry(String collectedFrom) throws Exception {
        TreeMap<String, List<Repository>> res = new TreeMap();
        try {
            logger.info((Object)("getting repos by country from dms with key: " + collectedFrom));
            List<Repository> repoList = this.getRepositories(RepoTools.getFilterKey(collectedFrom));
            res = RepoTools.splitReposPerCountry(repoList);
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repositories from dms with key: " + collectedFrom), (Throwable)e);
            throw e;
        }
        return res;
    }

    @Override
    public List<Repository> getRepositoriesOfCountry(String collectedFrom, String country) throws Exception {
        try {
            logger.info((Object)("getting repos for country " + country + " from dms with key: " + collectedFrom));
            return this.getRepositoriesPerCountry(collectedFrom).get(country);
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repos for country " + country + " from dms with key: " + collectedFrom), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Map<String, String> getRepoCompatibility(String officialName, String datasourceId) throws Exception {
        HashMap<String, String> compMap = null;
        Repository repo = this.dmService.getService().getDatasource(datasourceId);
        try {
            logger.debug((Object)("getting repository " + officialName + " compatibility from dms"));
            compMap = new HashMap<String, String>();
            if (repo.getInterfaces().size() > 0) {
                for (RepositoryInterface iFace : repo.getInterfaces()) {
                    compMap.put(iFace.getCompliance(), iFace.getAccessSet());
                    if (!iFace.getCompliance().equalsIgnoreCase("openaire2.0")) continue;
                    compMap.put("openaire2.0_data", "openaire_data");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error getting repo " + officialName + " compatibility from dms"), (Throwable)e);
            throw e;
        }
        return compMap;
    }

    @Override
    public List<Repository> getReposByIds(List<String> datasourceIds) throws Exception {
        ArrayList<Repository> retRepos = new ArrayList<Repository>();
        try {
            logger.info((Object)"getting repos by ids from dms");
            for (String datasourceId : datasourceIds) {
                retRepos.add(this.getRepository(datasourceId));
            }
        }
        catch (Exception e) {
            logger.error((Object)"error getting repos by ids from dms", (Throwable)e);
        }
        return retRepos;
    }

    @Override
    public List<Repository> getRepositoriesOfUser(String user_mail, Boolean repoAdmin) throws Exception {
        ArrayList<Repository> retRepos = new ArrayList<Repository>();
        try {
            if (!repoAdmin.booleanValue()) {
                logger.info((Object)("getting repositories registered by user: " + user_mail + " from dms"));
                for (String filterKey : this.filterKeys) {
                    List<Repository> repoList = this.getRepositories(filterKey);
                    for (Repository rep : repoList) {
                        if (!rep.getRegisteredBy().equalsIgnoreCase(user_mail) && !rep.getContactEmail().equalsIgnoreCase(user_mail)) continue;
                        retRepos.add(rep);
                    }
                }
            } else {
                logger.debug((Object)"getting journal /agreg  registered by others  from dms");
                List<Repository> repoList = this.getRepositories("infrastruct_::openaire");
                for (Repository rep : repoList) {
                    if (rep.getRegisteredBy().equalsIgnoreCase(user_mail) || rep.getContactEmail().equalsIgnoreCase(user_mail)) continue;
                    retRepos.add(rep);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("error getting repositories registered by user: " + user_mail + " from dms"), (Throwable)e);
        }
        return retRepos;
    }

    @Override
    public boolean repoIsCompliant(String officialName) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean updateRepositoryInterfaceCompliance(String officialName, String datasourceId, String interfaceId, String desiredCompliance, String set, String baseUrl, String oldId) throws Exception {
        boolean ret = true;
        try {
            if (desiredCompliance.equalsIgnoreCase("openaire2.0_data")) {
                desiredCompliance = "openaire2.0";
            }
            logger.info((Object)("updating repository " + officialName + " compliance to : " + desiredCompliance));
            if (oldId == null) {
                this.dmService.getService().updateLevelOfCompliance(datasourceId, interfaceId, desiredCompliance);
            } else {
                logger.debug((Object)"Checking if old interface should be updated");
                if (!desiredCompliance.equalsIgnoreCase("UNKNOWN") && !desiredCompliance.equalsIgnoreCase("notCompatible")) {
                    logger.debug((Object)"updating old interface with new set/url");
                    this.dmService.getService().updateBaseUrl(datasourceId, oldId, baseUrl);
                    if (set.equalsIgnoreCase("none")) {
                        this.dmService.getService().deleteAccessParamOrExtraField(datasourceId, oldId, "set");
                    } else {
                        this.dmService.getService().updateAccessParam(datasourceId, oldId, "set", set, false);
                    }
                    logger.debug((Object)"deleting new interface");
                    this.dmService.getService().deleteInterface(datasourceId, interfaceId);
                }
                logger.debug((Object)("updating repository " + officialName + " compliance to : " + desiredCompliance));
            }
            Date utilDate = new Date();
            Timestamp date = new Timestamp(utilDate.getTime());
            String updateQuery = "UPDATE datasources SET activationid = " + null + ", dateofvalidation = '" + date + "' WHERE id = '" + datasourceId + "'";
            if (this.dmService.getService().updateSQL(datasourceId, updateQuery, false)) {
                logger.debug((Object)"updated successfully");
            } else {
                logger.error((Object)("error while updating: " + updateQuery));
            }
        }
        catch (Exception e) {
            logger.error((Object)("error connecting to dms to set a repo interface as openaire compliant " + officialName), (Throwable)e);
            ret = false;
            throw e;
        }
        return ret;
    }

    @Override
    public boolean insertPubFileInterface(String dsId, RepositoryInterface iFace) throws Exception {
        try {
            logger.info((Object)("storing pdf interface for repository: " + dsId));
            this.dmService.getService().addInterface(dsId, iFace);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("error storing pdf interface for repository: " + dsId), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean updatePubFileInterface(String dsId, RepositoryInterface iFace) throws Exception {
        try {
            logger.info((Object)("updating pdf interface for repository: " + dsId));
            this.dmService.getService().deleteInterface(dsId, iFace.getId());
            this.dmService.getService().addInterface(dsId, iFace);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("error updating pdf interface for repository: " + dsId), (Throwable)e);
            return false;
        }
    }

    @Override
    public List<String> getUrlsOfRepos(String user_mail, Boolean repoAdmin) throws Exception {
        ArrayList<String> urls = new ArrayList<String>();
        try {
            logger.info((Object)("getting url from repositories registered by user: " + user_mail + " from dms"));
            for (Repository repo : this.getRepositoriesOfUser(user_mail, repoAdmin)) {
                repo = this.getRepository(repo.getOfficialName(), repo.getId());
                logger.debug((Object)("repo: " + repo.getOfficialName()));
                for (RepositoryInterface iFace : repo.getInterfaces()) {
                    if (!iFace.getContentDescription().equalsIgnoreCase("metadata") || iFace.getBaseUrl() == null || iFace.getBaseUrl().isEmpty() || urls.contains(iFace.getBaseUrl()) || !iFace.getAccessProtocol().equalsIgnoreCase("oai")) continue;
                    urls.add(iFace.getBaseUrl());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("error getting url from repositories registered by user: " + user_mail + " from dms"), (Throwable)e);
            throw e;
        }
        return urls;
    }

    @Override
    public String updateRepositoryInformation(Repository repo) throws Exception {
        try {
            logger.info((Object)"updating repository information");
            String updateQuery = "UPDATE datasources SET englishname = '" + repo.getEnglishName() + "', logourl = '" + repo.getLogoUrl() + "', timezone = '" + repo.getTimezone() + "', registeredby = '" + repo.getRegisteredBy() + "', contactemail = '" + repo.getContactEmail() + "', datasourceclass = '" + repo.getDatasourceClass() + "' WHERE id = '" + repo.getId() + "'";
            if (this.dmService.getService().updateSQL(repo.getId(), updateQuery, false)) {
                logger.debug((Object)"updated successfully");
                return "The information about your repository is successfully updated.";
            }
            logger.error((Object)("error while updating: " + updateQuery));
            return "The information of your repository couldn't be updated. Please try again.";
        }
        catch (Exception e) {
            logger.error((Object)"error updating repository information", (Throwable)e);
            throw e;
        }
    }

    @Override
    public String deleteRepositoryInterfaces(String dsId, List<RepositoryInterface> interfaces) throws Exception {
        String retMessage = "";
        try {
            logger.info((Object)"deleting repository interfaces");
            int countSelected = 0;
            int countRemoved = 0;
            for (RepositoryInterface iFace : interfaces) {
                if (!iFace.isDeleteApi()) continue;
                ++countSelected;
            }
            if (countSelected == 0) {
                return "None interface was selected.";
            }
            if (countSelected == interfaces.size()) {
                return "You cannot delete all interfaces! There must be at least one left.";
            }
            for (RepositoryInterface iFace : interfaces) {
                logger.debug((Object)("delete API: " + iFace.isDeleteApi() + "--removable API: " + iFace.isRemovable()));
                if (!iFace.isDeleteApi()) continue;
                if (iFace.isRemovable()) {
                    if (this.dmService.getService().deleteInterface(dsId, iFace.getId())) {
                        logger.debug((Object)("iface deleted: " + iFace.getId()));
                        ++countRemoved;
                        continue;
                    }
                    logger.error((Object)("error while deleting iFace: " + iFace.getId()));
                    retMessage = retMessage + "Interface for url/set: " + iFace.getBaseUrl() + " / " + iFace.getAccessSet() + " couldn't be delete. Please try again.<br>";
                    continue;
                }
                retMessage = retMessage + "Interface for url/set: " + iFace.getBaseUrl() + " / " + iFace.getAccessSet() + " couldn't be deleted because it is the one registered in OpenDoar. <br>";
            }
            retMessage = retMessage + "You have successfully deleted " + countRemoved + " interface(s).";
        }
        catch (Exception e) {
            logger.error((Object)"error deleting repository interfaces", (Throwable)e);
            throw e;
        }
        return retMessage;
    }

    @Override
    public void deleteRepositoryInterfacesWithoutChecks(String dsId, List<RepositoryInterface> interfaces, String datatype) throws Exception {
        try {
            logger.info((Object)"deleting repository interfaces without checks");
            for (RepositoryInterface iFace : interfaces) {
                logger.info((Object)("deleting repository interface with url/set/id: " + iFace.getBaseUrl() + "/" + iFace.getAccessSet() + "/" + iFace.getId()));
                if (this.dmService.getService().deleteInterface(dsId, iFace.getId())) {
                    logger.debug((Object)("iface deleted: " + iFace.getId()));
                    continue;
                }
                logger.error((Object)("error while deleting iFace: " + iFace.getId()));
                throw new Exception("error on dms while deleting iFace: " + iFace.getId());
            }
        }
        catch (Exception e) {
            logger.error((Object)"error deleting repository interfaces", (Throwable)e);
            throw e;
        }
    }

    @Override
    public String updateRepositoryInterfaces(String dsId, List<RepositoryInterface> interfaces, List<RepositoryInterface> interfacesOld, String datatype, List<RepositoryInterface> interfacesToRegister) throws Exception {
        String importResult = "";
        try {
            logger.info((Object)("updating repository interfaces for datasource: " + dsId));
            block2: for (RepositoryInterface iFace : interfaces) {
                if (!iFace.isDeleteApi()) continue;
                for (RepositoryInterface iFaceOld : interfacesOld) {
                    if (!iFaceOld.getId().equals(iFace.getId())) continue;
                    logger.error((Object)"old inteface found:");
                    this.printInterface(iFaceOld);
                    logger.error((Object)"new inteface:");
                    this.printInterface(iFace);
                    if (!(iFace.getDesiredCompatibilityLevel().equals("openaire2.0_data") && iFace.getCompliance().equals("openaire2.0") || iFace.getCompliance().equals(iFace.getDesiredCompatibilityLevel()))) {
                        logger.debug((Object)"Iface desired combatibility level changed.");
                        if (iFace.getBaseUrl().equals(iFaceOld.getBaseUrl()) && iFace.getAccessSet().equals(iFaceOld.getAccessSet())) {
                            logger.debug((Object)"Set and Url are the same.");
                            if (iFace.isRemovable()) {
                                logger.debug((Object)"deleting old iface..");
                                if (this.dmService.getService().deleteInterface(dsId, iFaceOld.getId())) {
                                    logger.debug((Object)"deleted successfully");
                                } else {
                                    logger.error((Object)"error while deleting");
                                }
                                logger.debug((Object)"adding new iface..");
                                iFace.setContentDescription("metadata");
                                iFace.setCompliance("UNKNOWN");
                                iFace.setId("api_________::" + dsId + "::" + UUID.randomUUID().toString().substring(0, 8));
                                iFace.setMetadataIdentifierPath("//*[local-name()='header']/*[local-name()='identifier']");
                                if (iFace.getAccessSet().isEmpty()) {
                                    logger.debug((Object)("set is empty: " + iFace.getAccessSet()));
                                    iFace.removeAccessSet();
                                }
                                logger.debug((Object)("new ifaceId :" + iFace.getId()));
                                if (this.dmService.getService().addInterface(dsId, iFace)) {
                                    logger.debug((Object)"added successfully");
                                    interfacesToRegister.add(iFace);
                                    continue block2;
                                }
                                logger.error((Object)"error while adding");
                                continue block2;
                            }
                            logger.debug((Object)"Cannot delete old iface.. Values of old interface will be updated");
                            logger.debug((Object)("updating iface.. :" + iFace.getId()));
                            this.dmService.getService().updateBaseUrl(dsId, iFace.getId(), iFace.getBaseUrl());
                            if (!iFace.getAccessSet().isEmpty()) {
                                this.dmService.getService().updateAccessParam(dsId, iFace.getId(), "set", iFace.getAccessSet(), false);
                            } else {
                                this.dmService.getService().deleteAccessParamOrExtraField(dsId, iFace.getId(), "set");
                            }
                            this.dmService.getService().updateContentDescription(dsId, iFace.getId(), "metadata");
                            if (datatype.equals("re3data")) {
                                this.dmService.getService().updateAccessParam(dsId, iFace.getId(), "format", "oai_datacite", false);
                                iFace.setAccessFormat("oai_datacite");
                            } else {
                                this.dmService.getService().updateAccessParam(dsId, iFace.getId(), "format", "oai_dc", false);
                                iFace.setAccessFormat("oai_dc");
                            }
                            logger.debug((Object)"added successfully");
                            interfacesToRegister.add(iFace);
                            continue block2;
                        }
                        if (iFace.getBaseUrl().equals(iFaceOld.getBaseUrl()) && iFace.getAccessSet().equals(iFaceOld.getAccessSet())) continue block2;
                        logger.debug((Object)"Set and/or Url changed. A new interface will be created");
                        logger.debug((Object)"adding new iface..The old one will be kept untouched.");
                        importResult = importResult + "Interface for url/set: " + iFace.getBaseUrl() + " / " + iFace.getAccessSet() + " seems to be completely new. As a result, a new interface will be created. If you wish, you can remove the old one later.<br>";
                        iFace.setContentDescription("metadata");
                        iFace.setCompliance("UNKNOWN");
                        iFace.setRemovable(true);
                        iFace.setMetadataIdentifierPath("//*[local-name()='header']/*[local-name()='identifier']");
                        if (!iFace.isRemovable()) {
                            iFace.getExtraFields().put("oldId", iFace.getId());
                        }
                        iFace.setId("api_________::" + dsId + "::" + UUID.randomUUID().toString().substring(0, 8));
                        if (iFace.getAccessSet().isEmpty()) {
                            logger.debug((Object)("set is empty: " + iFace.getAccessSet()));
                            iFace.removeAccessSet();
                        }
                        logger.debug((Object)("new ifaceId :" + iFace.getId()));
                        if (this.dmService.getService().addInterface(dsId, iFace)) {
                            logger.debug((Object)"added successfully");
                            interfacesToRegister.add(iFace);
                            continue block2;
                        }
                        logger.error((Object)"error while adding");
                        continue block2;
                    }
                    if (iFace.getBaseUrl().equals(iFaceOld.getBaseUrl()) && iFace.getAccessSet().equals(iFaceOld.getAccessSet())) continue block2;
                    logger.debug((Object)"Iface url/set changed.");
                    importResult = importResult + "Interface for url/set: " + iFace.getBaseUrl() + " / " + iFace.getAccessSet() + " is already compliant. As a result, a new interface will be created. If the new interface becomes compliant, then the old interface will be replaced. If not, both interfaces will be available. <br>";
                    logger.debug((Object)"adding new iface..but keeping the old id to update later.");
                    logger.debug((Object)("import result: " + importResult));
                    iFace.setContentDescription("metadata");
                    iFace.setCompliance("UNKNOWN");
                    iFace.setRemovable(true);
                    iFace.setMetadataIdentifierPath("//*[local-name()='header']/*[local-name()='identifier']");
                    iFace.getExtraFields().put("oldId", iFace.getId());
                    iFace.setId("api_________::" + dsId + "::" + UUID.randomUUID().toString().substring(0, 8));
                    if (iFace.getAccessSet().isEmpty()) {
                        logger.debug((Object)("set is empty: " + iFace.getAccessSet()));
                        iFace.removeAccessSet();
                    }
                    logger.debug((Object)("new ifaceId :" + iFace.getId()));
                    if (this.dmService.getService().addInterface(dsId, iFace)) {
                        logger.debug((Object)"added successfully");
                        interfacesToRegister.add(iFace);
                        continue block2;
                    }
                    logger.error((Object)"error while adding");
                    continue block2;
                }
            }
            logger.debug((Object)("import result final: " + importResult));
        }
        catch (Exception e) {
            logger.error((Object)("error updating repository interfaces for datasource: " + dsId), (Throwable)e);
            throw e;
        }
        return importResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RepositoryInterface updateRepositoryInterfaceWithoutChecks(String dsId, RepositoryInterface iFace, String datatype) throws Exception {
        try {
            logger.info((Object)("updating repository interface for datasource: " + dsId));
            this.printInterface(iFace);
            if (iFace.isRemovable()) {
                logger.debug((Object)"deleting old iface..");
                if (this.dmService.getService().deleteInterface(dsId, iFace.getId())) {
                    logger.debug((Object)"deleted successfully");
                } else {
                    logger.error((Object)"error while deleting");
                }
                logger.debug((Object)"adding new iface..");
                iFace.setContentDescription("metadata");
                iFace.setCompliance("UNKNOWN");
                iFace.setId("api_________::" + dsId + "::" + UUID.randomUUID().toString().substring(0, 8));
                iFace.setMetadataIdentifierPath("//*[local-name()='header']/*[local-name()='identifier']");
                if (iFace.getAccessSet().isEmpty()) {
                    logger.debug((Object)("set is empty: " + iFace.getAccessSet()));
                    iFace.removeAccessSet();
                }
                logger.debug((Object)("new ifaceId :" + iFace.getId()));
                if (!this.dmService.getService().addInterface(dsId, iFace)) {
                    logger.error((Object)"error while adding");
                    throw new Exception("Error on datasource manager service");
                }
                logger.debug((Object)"added successfully");
            } else {
                logger.debug((Object)"Cannot delete old iface.. Values of old interface will be updated");
                logger.debug((Object)("updating iface.. :" + iFace.getId()));
                this.dmService.getService().updateBaseUrl(dsId, iFace.getId(), iFace.getBaseUrl());
                if (!iFace.getAccessSet().isEmpty()) {
                    this.dmService.getService().updateAccessParam(dsId, iFace.getId(), "set", iFace.getAccessSet(), false);
                } else {
                    this.dmService.getService().deleteAccessParamOrExtraField(dsId, iFace.getId(), "set");
                }
                this.dmService.getService().updateContentDescription(dsId, iFace.getId(), "metadata");
                if (datatype.equals("re3data")) {
                    iFace.setAccessFormat("oai_datacite");
                } else {
                    iFace.setAccessFormat("oai_dc");
                }
                this.dmService.getService().updateAccessParam(dsId, iFace.getId(), "format", iFace.getAccessFormat(), false);
                this.dmService.getService().updateLevelOfCompliance(dsId, iFace.getId(), "UNKNOWN");
            }
            logger.debug((Object)"updated successfully");
            return iFace;
        }
        catch (Exception e) {
            logger.error((Object)("error updating repository interface for datasource: " + dsId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public String insertRepositoryInterfaces(String dsId, List<RepositoryInterface> interfaces, List<RepositoryInterface> interfacesOld, String datatype, List<RepositoryInterface> interfacesToRegister) throws Exception {
        String importResult = "";
        try {
            logger.info((Object)("inserting repository interfaces for datasource: " + dsId));
            logger.debug((Object)("interfacesNew size: " + interfaces.size()));
            logger.debug((Object)"cleaning up interfacesNew list from empty rows");
            for (RepositoryInterface iFace : interfaces) {
                if (iFace.getBaseUrl().isEmpty() || iFace.getDesiredCompatibilityLevel().isEmpty()) continue;
                logger.debug((Object)"adding new iface..");
                logger.debug((Object)"checking if there exists an interface with same url/set..");
                boolean exists = false;
                for (RepositoryInterface iFaceOld : interfacesOld) {
                    if (!iFaceOld.getBaseUrl().equals(iFace.getBaseUrl()) || !iFaceOld.getAccessSet().equals(iFace.getAccessSet())) continue;
                    logger.debug((Object)"there exists an interface with same url/set..");
                    importResult = importResult + "Interface for url/set: " + iFace.getBaseUrl() + " / " + iFace.getAccessSet() + " could not be added. There already exists an interface with same url/set. You have to update he existing one or remove it before adding a new one.<br>";
                    exists = true;
                    break;
                }
                iFace.setContentDescription("metadata");
                iFace.setCompliance("UNKNOWN");
                if (datatype.equalsIgnoreCase("journal")) {
                    iFace.setTypology("pubsrepository::journal");
                } else if (datatype.equalsIgnoreCase("aggregator")) {
                    iFace.setTypology("aggregator::pubsrepository::unknown");
                } else {
                    iFace.setTypology("pubsrepository::unknown");
                }
                if (datatype.equals("re3data")) {
                    iFace.setAccessFormat("oai_datacite");
                } else {
                    iFace.setAccessFormat("oai_dc");
                }
                iFace.setAccessProtocol("oai");
                iFace.setRemovable(true);
                iFace.setMetadataIdentifierPath("//*[local-name()='header']/*[local-name()='identifier']");
                iFace.setId("api_________::" + dsId + "::" + UUID.randomUUID().toString().substring(0, 8));
                if (iFace.getAccessSet().isEmpty()) {
                    logger.debug((Object)("set is empty: " + iFace.getAccessSet()));
                    iFace.removeAccessSet();
                }
                logger.debug((Object)("new ifaceId :" + iFace.getId()));
                if (exists) continue;
                if (this.dmService.getService().addInterface(dsId, iFace)) {
                    logger.debug((Object)"added successfully");
                    interfacesToRegister.add(iFace);
                    continue;
                }
                logger.error((Object)"error while adding");
            }
            logger.debug((Object)("interfaces size after cleanup: " + interfacesToRegister.size()));
        }
        catch (Exception e) {
            logger.error((Object)("error inserting repository interfaces for datasource: " + dsId), (Throwable)e);
            throw e;
        }
        return importResult;
    }

    @Override
    public RepositoryInterface insertRepositoryInterfaceWithoutChecks(String dsId, RepositoryInterface iFace, String datatype) throws Exception {
        try {
            Repository repo = this.getRepository(dsId);
            logger.info((Object)("inserting repository interface for datasource: " + dsId));
            logger.debug((Object)"adding new iface..");
            iFace.setContentDescription("metadata");
            iFace.setCompliance("UNKNOWN");
            if (repo.getDatasourceClass() == null) {
                if (datatype.equalsIgnoreCase("journal")) {
                    iFace.setTypology("pubsrepository::journal");
                } else if (datatype.equalsIgnoreCase("aggregator")) {
                    iFace.setTypology("aggregator::pubsrepository::unknown");
                } else {
                    iFace.setTypology("pubsrepository::unknown");
                }
            } else {
                iFace.setTypology(repo.getDatasourceClass());
            }
            if (datatype.equals("re3data")) {
                iFace.setAccessFormat("oai_datacite");
            } else {
                iFace.setAccessFormat("oai_dc");
            }
            iFace.setAccessProtocol("oai");
            iFace.setRemovable(true);
            iFace.setMetadataIdentifierPath("//*[local-name()='header']/*[local-name()='identifier']");
            iFace.setId("api_________::" + dsId + "::" + UUID.randomUUID().toString().substring(0, 8));
            if (iFace.getAccessSet().isEmpty()) {
                logger.debug((Object)("set is empty: " + iFace.getAccessSet()));
                iFace.removeAccessSet();
            }
            logger.debug((Object)("new ifaceId :" + iFace.getId()));
            if (this.dmService.getService().addInterface(dsId, iFace)) {
                logger.debug((Object)"added successfully");
            } else {
                logger.error((Object)"error while adding");
            }
            return iFace;
        }
        catch (Exception e) {
            logger.error((Object)("error inserting repository interface for datasource: " + dsId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public boolean unregisterRepository(Repository repo) throws Exception {
        logger.info((Object)("unregistering repository " + repo.getOfficialName()));
        try {
            for (RepositoryInterface iFace : repo.getInterfaces()) {
                if (iFace.isRemovable()) {
                    logger.debug((Object)"deleting iface..");
                    if (this.dmService.getService().deleteInterface(repo.getId(), iFace.getId())) {
                        logger.debug((Object)"deleted successfully");
                        continue;
                    }
                    logger.error((Object)"error while deleting");
                    continue;
                }
                logger.debug((Object)"updating iface compliance to UNKNOWN");
                this.dmService.getService().updateLevelOfCompliance(repo.getId(), iFace.getId(), "UNKNOWN");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error unregistering repository " + repo.getOfficialName()), (Throwable)e);
            return false;
        }
        return true;
    }

    private void printInterface(RepositoryInterface iFace) {
        logger.debug((Object)("baseUrl: " + iFace.getBaseUrl()));
        logger.debug((Object)("format: " + iFace.getAccessFormat()));
        logger.debug((Object)("typology: " + iFace.getTypology()));
        logger.debug((Object)("set: " + iFace.getAccessSet()));
        logger.debug((Object)("des_comp_level: " + iFace.getDesiredCompatibilityLevel()));
        logger.debug((Object)("cur_comp_level: " + iFace.getCompliance()));
        logger.debug((Object)("protocol: " + iFace.getAccessProtocol()));
        logger.debug((Object)("api_id: " + iFace.getId()));
        logger.debug((Object)("removable: " + iFace.isRemovable()));
        logger.debug((Object)("deleteApi: " + iFace.isDeleteApi()));
    }

    public ServiceLocator<DatasourceManagerService> getDmService() {
        return this.dmService;
    }

    public void setDmService(ServiceLocator<DatasourceManagerService> dmService) {
        this.dmService = dmService;
    }
}

