package gr.uoa.di.driver.xml;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

import org.apache.commons.lang3.StringEscapeUtils;

import eu.dnetlib.miscutils.datetime.DateUtils;

/**
 * A simple class to provide support for conversion
 * of dates from/to strings, according to the ISO muble muble standard.
 * 
 * @author <a href="antleb@di.uoa.gr">Antonis Lempesis</a>
 * 
 */
public abstract class ConversionUtils {

	public static String DateToString(Date date) {
		return new DateUtils(date).getDateAsISO8601String();
	}

	public static Date parseDate(String dateString) {
		return new DateUtils().parse(dateString);
	}

	public static XMLGregorianCalendar toXMLGregorianCalendar(Date date) {
		try {
			DatatypeFactory factory = DatatypeFactory.newInstance();
			GregorianCalendar calendar = new GregorianCalendar();

			calendar.setTime(date);

			return factory.newXMLGregorianCalendar(calendar);
		} catch (DatatypeConfigurationException e) {
			
			return null;
		}

	}

	public static Date toDate(XMLGregorianCalendar calendar) {
		return calendar.toGregorianCalendar().getTime();
	}
	
	@SuppressWarnings("unchecked")
	public static <T> T createProxy(T originalObject) {
		Enhancer enhancer = new Enhancer();
        
		enhancer.setSuperclass(originalObject.getClass());
        enhancer.setCallback(new XMLEscapingInterceptor(originalObject));

		return (T) enhancer.create();
	}
}

class XMLEscapingInterceptor implements MethodInterceptor {
	private Object originalObject = null;
	
	public XMLEscapingInterceptor(Object original) {
		this.originalObject = original;
	}
	
	@Override
	public Object intercept(Object obj, Method method, Object[] args,
			MethodProxy methodProxy) throws Throwable {
		if (method.getName().startsWith("get") && method.getReturnType().equals(String.class)) {
			String res = (String) method.invoke(originalObject, args);
			
			return StringEscapeUtils.escapeXml(res);
		} else {
			return  method.invoke(originalObject, args);
		}
	}
}