/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.driver.xml;

import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.functionality.Community;
import eu.dnetlib.domain.functionality.CommunitySearchCriteria;
import gr.uoa.di.driver.xml.AbstractConverter;
import gr.uoa.di.driver.xml.ConversionUtils;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import gr.uoa.di.driver.xml.community.COLLECTIONType;
import gr.uoa.di.driver.xml.community.MANAGERType;
import gr.uoa.di.driver.xml.community.ObjectFactory;
import gr.uoa.di.driver.xml.community.RECOMMENDATIONType;
import gr.uoa.di.driver.xml.community.RESOURCEPROFILE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBException;

public class CommunityXmlConverter
extends AbstractConverter<Community>
implements ResourceToXmlConverter<Community> {
    private ObjectFactory of = new ObjectFactory();

    public CommunityXmlConverter() throws JAXBException {
        super(RESOURCEPROFILE.class);
    }

    @Override
    public Community XmlToObject(String xml) throws JAXBException {
        Community community = new Community();
        RESOURCEPROFILE profile = (RESOURCEPROFILE)this.getUnmarshaller().unmarshal((InputStream)new ByteArrayInputStream(xml.getBytes()));
        community.setResourceId(profile.getHEADER().getRESOURCEIDENTIFIER().getValue());
        community.setResourceUri(profile.getHEADER().getRESOURCEURI().getValue());
        community.setResourceKind(profile.getHEADER().getRESOURCEKIND().getValue());
        community.setResourceType(profile.getHEADER().getRESOURCETYPE().getValue());
        community.setDateOfCreation(ConversionUtils.parseDate(profile.getHEADER().getDATEOFCREATION().getValue()));
        community.setName(profile.getBODY().getCONFIGURATION().getNAME().getValue());
        community.setDescription(profile.getBODY().getCONFIGURATION().getDESCRIPTION().getValue());
        community.setOwner(profile.getBODY().getCONFIGURATION().getOWNER().getValue());
        List<COLLECTIONType> collections = profile.getBODY().getCONFIGURATION().getCOLLECTIONS().getCOLLECTION();
        List<MANAGERType> managers = profile.getBODY().getCONFIGURATION().getMANAGERS().getMANAGER();
        List<RECOMMENDATIONType> recommendations = profile.getBODY().getCONFIGURATION().getRECOMMENDATIONS().getRECOMMENDATION();
        List<String> authDocs = profile.getBODY().getCONFIGURATION().getAuthoritativeDocuments().getAuthoritativeDocument();
        for (COLLECTIONType cOLLECTIONType : collections) {
            community.getCollections().add(cOLLECTIONType.getCollection());
        }
        for (MANAGERType mANAGERType : managers) {
            community.getManagers().add(mANAGERType.getManager());
        }
        for (RECOMMENDATIONType rECOMMENDATIONType : recommendations) {
            community.getRecommendations().add(rECOMMENDATIONType.getRecommendation());
        }
        community.setAuthoritativeDocuments(new HashSet<String>(authDocs));
        return community;
    }

    @Override
    public String ObjectToXml(Community community) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RESOURCEPROFILE profile = this.of.createRESOURCEPROFILE();
        profile.setHEADER(this.of.createHEADERType());
        profile.setBODY(this.of.createBODYType());
        profile.getHEADER().setRESOURCEIDENTIFIER(this.of.createRESOURCEIDENTIFIERType());
        profile.getHEADER().setRESOURCEKIND(this.of.createRESOURCEKINDType());
        profile.getHEADER().setRESOURCETYPE(this.of.createRESOURCETYPEType());
        profile.getHEADER().setRESOURCEURI(this.of.createRESOURCEURIType());
        profile.getHEADER().setDATEOFCREATION(this.of.createDATEOFCREATIONType());
        profile.getHEADER().getRESOURCEKIND().setValue(community.getResourceKind());
        profile.getHEADER().getRESOURCETYPE().setValue(community.getResourceType());
        if (community.getDateOfCreation() != null) {
            profile.getHEADER().getDATEOFCREATION().setValue(ConversionUtils.DateToString(community.getDateOfCreation()));
        } else {
            profile.getHEADER().getDATEOFCREATION().setValue("");
        }
        if (community.getResourceId() != null) {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue(community.getResourceId());
        } else {
            profile.getHEADER().getRESOURCEIDENTIFIER().setValue("");
        }
        if (community.getResourceUri() != null) {
            profile.getHEADER().getRESOURCEURI().setValue(community.getResourceUri());
        } else {
            profile.getHEADER().getRESOURCEURI().setValue("");
        }
        profile.getBODY().setSECURITYPARAMETERS(this.of.createSECURITYPARAMETERSType());
        profile.getBODY().setCONFIGURATION(this.of.createCONFIGURATIONType());
        profile.getBODY().setSTATUS("value");
        profile.getBODY().getSECURITYPARAMETERS().setSECURITYPARAMETER("Security Parameters");
        profile.getBODY().getCONFIGURATION().setDESCRIPTION(this.of.createCONFIGURATIONTypeDESCRIPTION());
        profile.getBODY().getCONFIGURATION().getDESCRIPTION().setValue(community.getDescription());
        profile.getBODY().getCONFIGURATION().setNAME(this.of.createCONFIGURATIONTypeNAME());
        profile.getBODY().getCONFIGURATION().getNAME().setValue(community.getName());
        profile.getBODY().getCONFIGURATION().setOWNER(this.of.createCONFIGURATIONTypeOWNER());
        profile.getBODY().getCONFIGURATION().getOWNER().setValue(community.getOwner());
        profile.getBODY().getCONFIGURATION().setCOLLECTIONS(this.of.createCOLLECTIONSType());
        profile.getBODY().getCONFIGURATION().setMANAGERS(this.of.createMANAGERSType());
        profile.getBODY().getCONFIGURATION().setRECOMMENDATIONS(this.of.createRECOMMENDATIONSType());
        profile.getBODY().getCONFIGURATION().setAuthoritativeDocuments(this.of.createAuthoritativeDocumentsType());
        for (String collection : community.getCollections()) {
            COLLECTIONType col = this.of.createCOLLECTIONType();
            col.setCollection(collection);
            profile.getBODY().getCONFIGURATION().getCOLLECTIONS().getCOLLECTION().add(col);
        }
        for (String manager : community.getManagers()) {
            MANAGERType man = this.of.createMANAGERType();
            man.setManager(manager);
            profile.getBODY().getCONFIGURATION().getMANAGERS().getMANAGER().add(man);
        }
        for (String recommendation : community.getRecommendations()) {
            RECOMMENDATIONType rec = this.of.createRECOMMENDATIONType();
            rec.setRecommendation(recommendation);
            profile.getBODY().getCONFIGURATION().getRECOMMENDATIONS().getRECOMMENDATION().add(rec);
        }
        profile.getBODY().getCONFIGURATION().getAuthoritativeDocuments().getAuthoritativeDocument().addAll(community.getAuthoritativeDocuments());
        this.getMarshaller().marshal((Object)profile, (OutputStream)baos);
        return baos.toString();
    }

    @Override
    public String toXQueryString(SearchCriteria criteria) {
        return this.toXQueryString((CommunitySearchCriteria)criteria);
    }

    public String toXQueryString(CommunitySearchCriteria criteria) {
        criteria = ConversionUtils.createProxy(criteria);
        String xQuery = null;
        String predicate = "";
        if (criteria.getContains() != null) {
            predicate = "[contains(lower-case(@value), \"" + criteria.getContains().toLowerCase() + "\")]";
        }
        if (criteria.getStartsWith() != null) {
            predicate = predicate + "[starts-with(lower-case(@value), \"" + criteria.getStartsWith().toLowerCase() + "\")]";
        }
        if (criteria.getEndsWith() != null) {
            predicate = predicate + "[ends-with(lower-case(@value), \"" + criteria.getEndsWith().toLowerCase() + "\")]";
        }
        xQuery = "for $x in collection(\"/db/DRIVER/CommunityDSResources/CommunityDSResourceType\")";
        if (!predicate.equals("")) {
            xQuery = xQuery + " where ";
            xQuery = xQuery + " $x//CONFIGURATION/NAME " + predicate;
        }
        xQuery = xQuery + " order by $x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME/@value ";
        xQuery = xQuery + " return $x";
        System.out.println("xquery: " + xQuery);
        return xQuery;
    }

    @Deprecated
    public String toXQueryString(Community exampleInstance) {
        String xQuery = "for $x in collection(\"/db/DRIVER/CommunityDSResources/CommunityDSResourceType\") ";
        ArrayList<String> predicates = new ArrayList<String>();
        if (exampleInstance != null) {
            if (exampleInstance.getCommunityId() != null) {
                predicates.add("$x/RESOURCE_PROFILE/HEADER/RESOURCE_IDENTIFIER[@value=\"" + exampleInstance.getCommunityId() + "\"]");
            }
            if (exampleInstance.getName() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME[@value=\"" + exampleInstance.getName() + "\"]");
            }
            if (exampleInstance.getDescription() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/DESCRIPTION[@value=\"" + exampleInstance.getDescription() + "\"]");
            }
            if (exampleInstance.getOwner() != null) {
                predicates.add("$x/RESOURCE_PROFILE/BODY/CONFIGURATION/OWNER[@value=\"" + exampleInstance.getOwner() + "\"]");
            }
            for (int i = 0; i < predicates.size(); ++i) {
                String predicate = (String)predicates.get(i);
                xQuery = i > 0 ? xQuery + " and " : xQuery + " where ";
                xQuery = xQuery + predicate;
            }
        }
        xQuery = xQuery + " order by $x/RESOURCE_PROFILE/BODY/CONFIGURATION/NAME/@value ";
        xQuery = xQuery + " return $x";
        return xQuery;
    }
}

