package eu.dnetlib.openaire.user.login.utils;

import org.apache.log4j.Logger;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.session.ExpiringSession;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Map;


@Service
public class AuthoritiesUpdater extends HttpSessionSecurityContextRepository {

    private static final Logger logger = Logger.getLogger(AuthoritiesUpdater.class);

    @Autowired
    FindByIndexNameSessionRepository sessions;

    public void update(String id, Update update) {
        if (sessions != null) {
            Map<String, ExpiringSession> map = sessions.
                    findByIndexNameAndIndexValue(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, id);
            logger.debug(map.values().toArray().length);
            for (ExpiringSession session : map.values()) {
                logger.debug(session.getId());
                if (!session.isExpired()) {
                    SecurityContext securityContext = session.getAttribute(SPRING_SECURITY_CONTEXT_KEY);
                    Authentication authentication = securityContext.getAuthentication();
                    if (authentication instanceof OIDCAuthenticationToken) {
                        OIDCAuthenticationToken authOIDC = (OIDCAuthenticationToken) authentication;
                        Collection<? extends GrantedAuthority> authorities = update.authorities(authentication.getAuthorities());
                        logger.debug(authorities);
                        securityContext.setAuthentication(new OIDCAuthenticationToken(authOIDC.getSub(), authOIDC.getIssuer(),
                                authOIDC.getUserInfo(), authorities, authOIDC.getIdToken(),
                                authOIDC.getAccessTokenValue(), authOIDC.getRefreshTokenValue()));
                        logger.debug("Update authorities");
                        session.setAttribute(SPRING_SECURITY_CONTEXT_KEY, securityContext);
                        sessions.save(session);
                    }
                }
            }
        }
    }

    public interface Update {
        Collection<? extends GrantedAuthority> authorities(Collection<? extends GrantedAuthority> old);
    }
}
