/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.user.login.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AuthoritiesMapper {
    private static final Logger logger = Logger.getLogger(AuthoritiesMapper.class);

    public static Collection<? extends GrantedAuthority> map(JsonArray entitlements) {
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        AuthoritiesMapper.provideRoles(entitlements, authorities);
        AuthoritiesMapper.entityRoles(entitlements, authorities);
        return authorities;
    }

    private static void entityRoles(JsonArray entitlements, Set<SimpleGrantedAuthority> authorities) {
        String regex = "urn:geant:openaire[.]eu:group:([^:]*):?(.*)?:role=member#aai[.]openaire[.]eu";
        for (JsonElement obj : entitlements) {
            Matcher matcher = Pattern.compile(regex).matcher(obj.getAsString());
            if (!matcher.find()) continue;
            StringBuilder sb = new StringBuilder();
            if (matcher.group(1) != null && matcher.group(1).length() > 0) {
                sb.append(matcher.group(1).replace("+-+", "_").replaceAll("[+.]", "_").toUpperCase());
            }
            if (matcher.group(2).length() > 0) {
                sb.append("_");
                if (matcher.group(2).equals("admins")) {
                    sb.append("MANAGER");
                } else {
                    sb.append(matcher.group(2).toUpperCase());
                }
            }
            authorities.add(new SimpleGrantedAuthority(sb.toString()));
        }
    }

    private static void provideRoles(JsonArray entitlements, Set<SimpleGrantedAuthority> authorities) {
        HashMap userRoles = new HashMap(){
            {
                this.put("urn:geant:openaire.eu:group:Super+Administrator:role=member#aai.openaire.eu", "ROLE_ADMIN");
                this.put("urn:geant:openaire.eu:group:Content+Provider+Dashboard+Administrator:role=member#aai.openaire.eu", "ROLE_PROVIDE_ADMIN");
            }
        };
        HashMap userRolesMap = new HashMap();
        userRoles.forEach((openaireRole, appRole) -> userRolesMap.put(openaireRole, new SimpleGrantedAuthority(appRole)));
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        if (entitlements != null) {
            entitlements.forEach(role -> {
                SimpleGrantedAuthority authority = (SimpleGrantedAuthority)userRolesMap.get(role.getAsString());
                if (authority != null) {
                    authorities.add(authority);
                }
            });
        }
    }
}

