/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.user.login.handler;

import com.google.gson.JsonParser;
import eu.dnetlib.openaire.user.login.utils.JWTGenerator;
import java.io.IOException;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.session.FindByIndexNameSessionRepository;

public class FrontEndLinkURIAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger logger = Logger.getLogger(FrontEndLinkURIAuthenticationSuccessHandler.class);
    private String frontEndURI;
    private String frontPath;
    private String frontDomain;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IllegalArgumentException, IOException {
        OIDCAuthenticationToken authOIDC = (OIDCAuthenticationToken)authentication;
        request.getSession().setAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME, (Object)authOIDC.getUserInfo().getEmail());
        try {
            Cookie accessToken = new Cookie("AccessToken", authOIDC.getAccessTokenValue());
            String regex = "^([A-Za-z0-9-_=]+)\\.([A-Za-z0-9-_=]+)\\.?([A-Za-z0-9-_.+=]*)$";
            Matcher matcher = Pattern.compile(regex).matcher(authOIDC.getAccessTokenValue());
            if (matcher.find()) {
                long exp = new JsonParser().parse(new String(Base64.getDecoder().decode(matcher.group(2)))).getAsJsonObject().get("exp").getAsLong();
                accessToken.setMaxAge((int)(exp - new Date().getTime() / 1000L));
            } else {
                accessToken.setMaxAge(3600);
            }
            logger.debug((Object)("access token: " + authOIDC.getAccessTokenValue()));
            logger.debug((Object)("refresh token: " + authOIDC.getRefreshTokenValue()));
            logger.debug((Object)("CREDENTIALS > " + authOIDC.getCredentials()));
            logger.debug((Object)("Authorities > " + authOIDC.getAuthorities()));
            logger.debug((Object)("\n\nPrincipals > " + authOIDC.getPrincipal()));
            logger.debug((Object)("\n\nUser Info > " + authOIDC.getUserInfo()));
            logger.debug((Object)("\n\nopenAIREUser: " + JWTGenerator.generateJsonToken(authOIDC)));
            logger.debug((Object)"\n////////////////////////////////////////////////////////////////////////////////////////////////\n");
            accessToken.setPath(this.frontPath);
            if (this.frontDomain != null) {
                accessToken.setDomain(this.frontDomain);
            }
            response.addCookie(accessToken);
            response.sendRedirect(this.frontEndURI);
        }
        catch (IOException e) {
            logger.error((Object)"IOException in redirection ", (Throwable)e);
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"IllegalArgumentException in redirection ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public String getFrontEndURI() {
        return this.frontEndURI;
    }

    public void setFrontEndURI(String frontEndURI) {
        this.frontEndURI = frontEndURI;
    }

    public String getFrontPath() {
        return this.frontPath;
    }

    public void setFrontPath(String frontPath) {
        this.frontPath = frontPath;
    }

    public String getFrontDomain() {
        return this.frontDomain;
    }

    public void setFrontDomain(String frontDomain) {
        this.frontDomain = frontDomain;
    }
}

