package eu.dnetlib.uoamonitorservice.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.data.annotation.Id;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Category<StringOrSubcategory> {
    @Id
    @JsonProperty("_id")
    private String id;

    private String name;
    private String alias;
    private String description;
    private Visibility visibility = Visibility.PRIVATE;
    private Date creationDate;
    private Date updateDate;
    private boolean isOverview;
    private String defaultId;
    private List<StringOrSubcategory> subCategories;

    public Category() {}
    public Category(Category category) {
        id = category.getId();
        name = category.getName();
        alias = category.getAlias();
        description = category.getDescription();
        setVisibility(category.getVisibility());
        creationDate = category.getCreationDate();
        updateDate = category.getUpdateDate();
        isOverview = category.getIsOverview();
        defaultId = category.getDefaultId();
    }

    public void copyFromDefault(Category defaultCategory) {
        setName(defaultCategory.getName());
        setAlias(defaultCategory.getAlias());
        setDescription(defaultCategory.getDescription());
        setVisibility(defaultCategory.getVisibility());
        setCreationDate(defaultCategory.getCreationDate());
        setUpdateDate(defaultCategory.getUpdateDate());
        setIsOverview(defaultCategory.getIsOverview());
        setDefaultId(defaultCategory.getId());
        setSubCategories(new ArrayList());
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Visibility getVisibility() {
        return visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public boolean getIsOverview() {
        return isOverview;
    }

    public void setIsOverview(boolean isOverview) {
        this.isOverview = isOverview;
    }

    public String getDefaultId() {
        return defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public List<StringOrSubcategory> getSubCategories() {
        return subCategories;
    }

    public void setSubCategories(List<StringOrSubcategory> subCategories) {
        this.subCategories = subCategories;
    }
}
