package eu.dnetlib.uoamonitorservice.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.data.annotation.Id;

import java.util.Date;
import java.util.List;

enum IndicatorType {
    // Do not rename or remove existring values. This may cause problems with already stored values in DB
    number, chart,
    NUMBER, CHART;
}

enum IndicatorSize {
    // Do not rename or remove existring values. This may cause problems with already stored values in DB
    small, medium, large,
    SMALL, MEDIUM, LARGE;
}

public class Indicator {
    @Id
    @JsonProperty("_id")
    private String id;

    private String name;
    private String description;
    private String additionalDescription;
    private IndicatorType type; //number,chart
    private IndicatorSize width; //small,medium,large
    private IndicatorSize height = IndicatorSize.MEDIUM; //small,medium,large
    private List<String> tags;  // this field is not used anywhere now
    private Visibility visibility = Visibility.PRIVATE;
    private Date creationDate;
    private Date updateDate;
    private String defaultId;
    private List<IndicatorPath> indicatorPaths;

    public void copyFromDefault(Indicator defaultIndicator) {
        setName(defaultIndicator.getName());
        setDescription(defaultIndicator.getDescription());
        setAdditionalDescription(defaultIndicator.getAdditionalDescription());
        setType(defaultIndicator.getType());
        setWidth(defaultIndicator.getWidth());
        setHeight(defaultIndicator.getHeight());
        setTags(defaultIndicator.getTags());
        setVisibility(Visibility.RESTRICTED);
        setCreationDate(defaultIndicator.getCreationDate());
        setUpdateDate(defaultIndicator.getUpdateDate());
        setDefaultId(defaultIndicator.getId());
        setIndicatorPaths(defaultIndicator.getIndicatorPaths());
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAdditionalDescription() {
        return additionalDescription;
    }

    public void setAdditionalDescription(String description) {
        this.additionalDescription = description;
    }

    public String getType() {
        if(type == null) {
            return null;
        }
        return type.name();
    }

//    public String getStringType() {
//        return type.name();
//    }

//    public void setType(IndicatorType type) {
//        this.type = type;
//    }
    public void setType(String type) {
        if(type == null) {
            this.type = null;
        } else {
            IndicatorType indicatorType = IndicatorType.valueOf(type);
            this.type = indicatorType;
        }
    }

    public IndicatorSize getWidth() {
        return width;
    }

    public void setWidth(IndicatorSize width) {
        this.width = width;
    }

    public IndicatorSize getHeight() {
        return height;
    }

    public void setHeight(IndicatorSize height) {
        this.height = height;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Visibility getVisibility() {
        return visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getDefaultId() {
        return defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public List<IndicatorPath> getIndicatorPaths() {
        return indicatorPaths;
    }

    public void setIndicatorPaths(List<IndicatorPath> indicatorPaths) {
        this.indicatorPaths = indicatorPaths;
    }

//    public String hasType() {
//        return this.type.name();
//    }
}
