/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.handlers.ForbiddenException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.utils.RolesUtils;
import eu.dnetlib.uoamonitorservice.controllers.SectionController;
import eu.dnetlib.uoamonitorservice.controllers.StakeholderController;
import eu.dnetlib.uoamonitorservice.dao.CategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.IndicatorDAO;
import eu.dnetlib.uoamonitorservice.dao.SectionDAO;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.dao.SubCategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.TopicDAO;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Indicator;
import eu.dnetlib.uoamonitorservice.entities.IndicatorPath;
import eu.dnetlib.uoamonitorservice.entities.ReorderEvent;
import eu.dnetlib.uoamonitorservice.entities.Section;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.SubCategory;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.entities.Visibility;
import eu.dnetlib.uoamonitorservice.handlers.EntityNotFoundException;
import eu.dnetlib.uoamonitorservice.handlers.PathNotValidException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class IndicatorController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private RolesUtils rolesUtils;
    @Autowired
    private StakeholderDAO stakeholderDAO;
    @Autowired
    private TopicDAO topicDAO;
    @Autowired
    private CategoryDAO categoryDAO;
    @Autowired
    private SubCategoryDAO subCategoryDAO;
    @Autowired
    private SectionDAO sectionDAO;
    @Autowired
    private IndicatorDAO indicatorDAO;
    @Autowired
    private SectionController sectionController;
    @Autowired
    private StakeholderController stakeholderController;

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/save-bulk"}, method={RequestMethod.POST})
    public Stakeholder saveBulkIndicators(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @RequestBody List<Indicator> indicators) throws UnsupportedEncodingException {
        this.log.debug((Object)"save bulk indicators");
        this.log.debug((Object)("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId));
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        Date date = new Date();
        this.createSectionsAndSaveBulk(date, indicators, stakeholder, topicId, categoryId, subcategoryId);
        return this.stakeholderController.setFullEntities(stakeholder, this.rolesUtils.getRoles());
    }

    private void createSectionsAndSaveBulk(Date date, List<Indicator> new_indicators, Stakeholder stakeholder, String topicId, String categoryId, String subcategoryId) throws UnsupportedEncodingException {
        Section chart_section = null;
        Section number_section = null;
        List chart_indicators = null;
        List number_indicators = null;
        for (Indicator indicator : new_indicators) {
            if (indicator.getType().equals("chart")) {
                if (chart_section == null) {
                    chart_section = this.createSection(chart_section, "chart", "Charts imported from file", date, stakeholder, topicId, categoryId, subcategoryId);
                    chart_indicators = chart_section.getIndicators();
                }
                this.saveIndicatorAndAddInSection(indicator, date, stakeholder, chart_section, chart_indicators);
                continue;
            }
            if (!indicator.getType().equals("number")) continue;
            if (number_section == null) {
                number_section = this.createSection(number_section, "number", "Numbers imported from file", date, stakeholder, topicId, categoryId, subcategoryId);
                number_indicators = number_section.getIndicators();
            }
            this.saveIndicatorAndAddInSection(indicator, date, stakeholder, number_section, number_indicators);
        }
        if (chart_section != null) {
            this.sectionDAO.save(chart_section);
        }
        if (number_section != null) {
            this.sectionDAO.save(number_section);
        }
    }

    private Section createSection(Section section, String type, String title, Date date, Stakeholder stakeholder, String topicId, String categoryId, String subcategoryId) {
        section = new Section();
        section.setType(type);
        section.setTitle(title);
        section.setStakeholderAlias(stakeholder.getAlias());
        section.setUpdateDate(date);
        section.setCreationDate(date);
        section.setIndicators(new ArrayList());
        this.sectionController.saveSection(stakeholder.getId(), topicId, categoryId, subcategoryId, "-1", section);
        return section;
    }

    private void saveIndicatorAndAddInSection(Indicator indicator, Date date, Stakeholder stakeholder, Section section, List<String> indicators) throws UnsupportedEncodingException {
        indicator.setCreationDate(date);
        indicator.setUpdateDate(date);
        if (stakeholder.getDefaultId() == null) {
            this.indicatorDAO.save(indicator);
            this.onSaveDefaultIndicator(indicator, section.getId());
        } else {
            this.indicatorDAO.save(indicator);
        }
        indicators.add(indicator.getId());
        this.log.debug((Object)"Indicator saved!");
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/save"}, method={RequestMethod.POST})
    public Indicator saveIndicator(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @RequestBody Indicator indicator) throws UnsupportedEncodingException {
        this.log.debug((Object)"save indicator");
        this.log.debug((Object)("Name: " + indicator.getName() + " - Id: " + indicator.getId() + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId));
        Section section = this.checkForExceptions(stakeholderId, topicId, categoryId, subcategoryId, sectionId, indicator.getType());
        Date date = new Date();
        indicator.setUpdateDate(date);
        Indicator oldIndicator = null;
        if (indicator.getId() != null) {
            oldIndicator = this.indicatorDAO.findById(indicator.getId());
            if (oldIndicator == null) {
                throw new EntityNotFoundException("save indicator: Indicator with id: " + indicator.getId() + " not found");
            }
        } else {
            indicator.setCreationDate(date);
        }
        String indicatorId = indicator.getId();
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder.getDefaultId() == null) {
            if (indicatorId == null) {
                this.indicatorDAO.save(indicator);
                this.onSaveDefaultIndicator(indicator, sectionId);
            } else {
                this.onUpdateDefaultIndicator(indicator, stakeholder, oldIndicator);
                this.indicatorDAO.save(indicator);
            }
        } else {
            this.indicatorDAO.save(indicator);
        }
        List indicators = section.getIndicators();
        int index = indicators.indexOf(indicator.getId());
        if (index == -1) {
            indicators.add(indicator.getId());
            this.sectionDAO.save(section);
            this.log.debug((Object)"Indicator saved!");
        }
        return indicator;
    }

    public void onSaveDefaultIndicator(Indicator indicator, String defaultSectionId) throws UnsupportedEncodingException {
        this.log.debug((Object)"On save default indicator");
        List sections = this.sectionDAO.findByDefaultId(defaultSectionId);
        for (Section section : sections) {
            Indicator indicatorNew = new Indicator();
            indicatorNew.copyFromDefault(indicator);
            for (IndicatorPath indicatorPath : indicatorNew.getIndicatorPaths()) {
                Stakeholder stakeholder = this.stakeholderDAO.findByAlias(section.getStakeholderAlias());
                this.parameterMapping(indicatorPath, stakeholder);
            }
            this.indicatorDAO.save(indicatorNew);
            List indicators = section.getIndicators();
            indicators.add(indicatorNew.getId());
            this.sectionDAO.save(section);
        }
    }

    public void onUpdateDefaultIndicator(Indicator indicator, Stakeholder stakeholder, Indicator oldIndicator) throws UnsupportedEncodingException {
        this.log.debug((Object)"On update default indicator");
        List indicators = this.indicatorDAO.findByDefaultId(indicator.getId());
        for (Indicator indicatorBasedOnDefault : indicators) {
            boolean changed = false;
            if ((indicator.getName() == null && oldIndicator.getName() != null || indicator.getName() != null && !indicator.getName().equals(indicatorBasedOnDefault.getName())) && (oldIndicator.getName() == null && indicatorBasedOnDefault.getName() == null || oldIndicator.getName() != null && oldIndicator.getName().equals(indicatorBasedOnDefault.getName()))) {
                indicatorBasedOnDefault.setName(indicator.getName());
                changed = true;
            }
            if (indicator.getDescription() != null && !indicator.getDescription().equals(indicatorBasedOnDefault.getDescription()) || indicator.getDescription() == null && indicatorBasedOnDefault.getDescription() != null) {
                indicatorBasedOnDefault.setDescription(indicator.getDescription());
                changed = true;
            }
            if ((indicator.getAdditionalDescription() == null && oldIndicator.getAdditionalDescription() != null || indicator.getAdditionalDescription() != null && !indicator.getAdditionalDescription().equals(indicatorBasedOnDefault.getAdditionalDescription())) && (oldIndicator.getAdditionalDescription() == null && indicatorBasedOnDefault.getAdditionalDescription() == null || oldIndicator.getAdditionalDescription() != null && oldIndicator.getAdditionalDescription().equals(indicatorBasedOnDefault.getAdditionalDescription()))) {
                indicatorBasedOnDefault.setAdditionalDescription(indicator.getAdditionalDescription());
                changed = true;
            }
            int i = 0;
            ArrayList<IndicatorPath> indicatorPaths = indicatorBasedOnDefault.getIndicatorPaths();
            if (indicatorPaths == null && indicator.getIndicatorPaths() != null) {
                indicatorPaths = new ArrayList<IndicatorPath>();
            }
            for (IndicatorPath indicatorPath : indicator.getIndicatorPaths()) {
                IndicatorPath indicatorPathBasedOnDefault = null;
                if (i < indicatorPaths.size()) {
                    indicatorPathBasedOnDefault = (IndicatorPath)indicatorPaths.get(i);
                }
                if (indicatorPathBasedOnDefault == null) {
                    IndicatorPath indicatorPathNew = new IndicatorPath(indicatorPath);
                    this.parameterMapping(indicatorPathNew, stakeholder);
                    indicatorPaths.add(indicatorPathNew);
                    changed = true;
                } else {
                    IndicatorPath oldIndicatorPath = (IndicatorPath)oldIndicator.getIndicatorPaths().get(i);
                    this.log.debug((Object)("update indicator path: " + i + " (indicator id: " + indicatorBasedOnDefault.getId() + ")"));
                    if ((indicatorPath.getType() == null && oldIndicatorPath.getType() != null || indicatorPath.getType() != null && !indicatorPath.getType().equals(indicatorPathBasedOnDefault.getType())) && (oldIndicatorPath.getType() == null && indicatorPathBasedOnDefault.getType() == null || oldIndicatorPath.getType() != null && oldIndicatorPath.getType().equals(indicatorPathBasedOnDefault.getType()))) {
                        indicatorPathBasedOnDefault.setType(indicatorPath.getType());
                        changed = true;
                    }
                    this.log.debug((Object)("After type check: " + changed));
                    if ((indicatorPath.getSource() == null && oldIndicatorPath.getSource() != null || indicatorPath.getSource() != null && !indicatorPath.getSource().equals(indicatorPathBasedOnDefault.getSource())) && (oldIndicatorPath.getSource() == null && indicatorPathBasedOnDefault.getSource() == null || oldIndicatorPath.getSource() != null && oldIndicatorPath.getSource().equals(indicatorPathBasedOnDefault.getSource()))) {
                        indicatorPathBasedOnDefault.setSource(indicatorPath.getSource());
                        changed = true;
                    }
                    this.log.debug((Object)("After source check: " + changed));
                    if ((indicatorPath.getUrl() == null && oldIndicatorPath.getUrl() != null || indicatorPath.getUrl() != null && !indicatorPath.getUrl().equals(indicatorPathBasedOnDefault.getUrl())) && (oldIndicatorPath.getUrl() == null && indicatorPathBasedOnDefault.getUrl() == null || oldIndicatorPath.getUrl() != null && oldIndicatorPath.getUrl().equals(indicatorPathBasedOnDefault.getUrl()))) {
                        indicatorPathBasedOnDefault.setUrl(indicatorPath.getUrl());
                        changed = true;
                    }
                    this.log.debug((Object)("After url check: " + changed));
                    if ((indicatorPath.getChartObject() == null && oldIndicatorPath.getChartObject() != null || indicatorPath.getChartObject() != null && !indicatorPath.getChartObject().equals(indicatorPathBasedOnDefault.getChartObject())) && (oldIndicatorPath.getChartObject() == null && indicatorPathBasedOnDefault.getChartObject() == null || oldIndicatorPath.getChartObject() != null && oldIndicatorPath.getChartObject().equals(indicatorPathBasedOnDefault.getChartObject()))) {
                        indicatorPathBasedOnDefault.setChartObject(indicatorPath.getChartObject());
                        changed = true;
                    }
                    this.log.debug((Object)("After chartObject check: " + changed));
                    if (indicatorPath.getParameters() != null) {
                        if (indicatorPathBasedOnDefault.getParameters() == null) {
                            indicatorPathBasedOnDefault.setParameters(new HashMap());
                        }
                        for (Map.Entry parameter : indicatorPath.getParameters().entrySet()) {
                            this.log.debug((Object)("\nindicatorPath: parameter.getKey(): " + (String)parameter.getKey() + " - value: " + (String)parameter.getValue() + "\nindicatorPathBasedOnDefault:parameters:key: " + (String)indicatorPathBasedOnDefault.getParameters().get(parameter.getKey()) + "\noldIndicatorPath:parameters:key: " + (oldIndicatorPath.getParameters() == null ? "null" : (String)oldIndicatorPath.getParameters().get(parameter.getKey()))));
                            if (indicatorPathBasedOnDefault.getParameters().containsKey(parameter.getKey()) && oldIndicatorPath.getParameters() != null && oldIndicatorPath.getParameters().get(parameter.getKey()) != null && (!((String)oldIndicatorPath.getParameters().get(parameter.getKey())).equals(indicatorPathBasedOnDefault.getParameters().get(parameter.getKey())) || ((String)parameter.getValue()).equals(indicatorPathBasedOnDefault.getParameters().get(parameter.getKey())))) continue;
                            indicatorPathBasedOnDefault.getParameters().put(parameter.getKey(), parameter.getValue());
                            changed = true;
                        }
                        if (oldIndicatorPath.getParameters() != null && indicatorPath.getParameters().size() < oldIndicatorPath.getParameters().size()) {
                            for (Map.Entry parameter : oldIndicatorPath.getParameters().entrySet()) {
                                if (indicatorPath.getParameters().containsKey(parameter.getKey())) continue;
                                indicatorPathBasedOnDefault.getParameters().remove(parameter.getKey());
                            }
                        }
                        this.parameterMapping(indicatorPathBasedOnDefault, stakeholder);
                    }
                    this.log.debug((Object)("After parameters check: " + changed));
                    if (indicatorPath.getJsonPath() != null) {
                        boolean jsonPathChanged = false;
                        boolean breaked = false;
                        int oldJsonPathSize = 0;
                        if (oldIndicatorPath.getJsonPath() != null) {
                            oldJsonPathSize = oldIndicatorPath.getJsonPath().size();
                        }
                        int basedOnDefaultJsonPathSize = 0;
                        if (indicatorPathBasedOnDefault.getJsonPath() != null) {
                            basedOnDefaultJsonPathSize = indicatorPathBasedOnDefault.getJsonPath().size();
                        }
                        this.log.debug((Object)("old: " + oldJsonPathSize + " - based on default: " + basedOnDefaultJsonPathSize + " - new: " + indicatorPath.getJsonPath().size()));
                        if (oldJsonPathSize == basedOnDefaultJsonPathSize) {
                            if (indicatorPathBasedOnDefault.getJsonPath() == null && indicatorPath.getJsonPath().size() > 0) {
                                indicatorPathBasedOnDefault.setJsonPath(new ArrayList());
                            }
                            int basedOnDefaultIndex = 0;
                            int oldIndex = 0;
                            Iterator jsonStringBasedOnDefaultIterator = indicatorPathBasedOnDefault.getJsonPath().iterator();
                            while (jsonStringBasedOnDefaultIterator.hasNext()) {
                                String jsonStringBasedOnDefault = (String)jsonStringBasedOnDefaultIterator.next();
                                if (((String)oldIndicatorPath.getJsonPath().get(oldIndex)).equals(jsonStringBasedOnDefault)) {
                                    if (basedOnDefaultIndex >= indicatorPath.getJsonPath().size()) {
                                        jsonStringBasedOnDefaultIterator.remove();
                                        jsonPathChanged = true;
                                    } else {
                                        if (!((String)indicatorPath.getJsonPath().get(basedOnDefaultIndex)).equals(jsonStringBasedOnDefault)) {
                                            indicatorPathBasedOnDefault.getJsonPath().set(basedOnDefaultIndex, indicatorPath.getJsonPath().get(basedOnDefaultIndex));
                                            jsonPathChanged = true;
                                        }
                                        ++basedOnDefaultIndex;
                                    }
                                    ++oldIndex;
                                    continue;
                                }
                                breaked = true;
                                jsonPathChanged = false;
                                this.log.debug((Object)("not the same: " + oldIndex));
                                break;
                            }
                            int index = 0;
                            if (!breaked && indicatorPath.getJsonPath().size() > indicatorPathBasedOnDefault.getJsonPath().size()) {
                                jsonPathChanged = true;
                                for (index = indicatorPathBasedOnDefault.getJsonPath().size(); index < indicatorPath.getJsonPath().size(); ++index) {
                                    indicatorPathBasedOnDefault.getJsonPath().add(indicatorPath.getJsonPath().get(index));
                                }
                            }
                            if (jsonPathChanged) {
                                changed = true;
                            }
                        }
                    }
                    this.log.debug((Object)("After jsonPath check: " + changed));
                }
                ++i;
            }
            if (!changed) continue;
            indicatorBasedOnDefault.setUpdateDate(indicator.getUpdateDate());
            this.indicatorDAO.save(indicatorBasedOnDefault);
        }
    }

    public void parameterMapping(IndicatorPath indicatorPath, Stakeholder stakeholder) throws UnsupportedEncodingException {
        if (indicatorPath.getParameters() != null) {
            if (indicatorPath.getParameters().containsKey("index_name")) {
                indicatorPath.getParameters().put("index_name", stakeholder.getIndex_name());
            } else if (indicatorPath.getParameters().containsKey("index_shortName")) {
                indicatorPath.getParameters().put("index_shortName", stakeholder.getIndex_name().toLowerCase());
            } else if (indicatorPath.getParameters().containsKey("index_id")) {
                indicatorPath.getParameters().put("index_id", stakeholder.getIndex_id());
            }
        }
    }

    public String urlEncode(String encodedIndicatorPathField) {
        String indicatorPathField = "";
        for (int i = 0; i < encodedIndicatorPathField.length(); ++i) {
            String character = encodedIndicatorPathField.substring(i, i + 1);
            if (character.equals("+")) {
                indicatorPathField = indicatorPathField.concat("%20");
                continue;
            }
            if (character.equals("%")) {
                String output = encodedIndicatorPathField.substring(i + 1, i + 3);
                if (output.equals("7E") || output.equals("27") || output.equals("28") || output.equals("29") || output.equals("21")) {
                    int decimal = Integer.parseInt(output, 16);
                    StringBuilder sb = new StringBuilder();
                    sb.append((char)decimal);
                    indicatorPathField = indicatorPathField.concat(sb.toString());
                } else {
                    indicatorPathField = indicatorPathField.concat(character + output);
                }
                i += 2;
                continue;
            }
            indicatorPathField = indicatorPathField.concat(character);
        }
        return indicatorPathField;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/{indicatorId}/delete"}, method={RequestMethod.DELETE})
    public boolean deleteIndicator(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @PathVariable(value="indicatorId") String indicatorId, @RequestParam(required=false) String children) {
        this.log.debug((Object)"delete indicator");
        this.log.debug((Object)("Id: " + indicatorId + " - Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId));
        Indicator indicator = this.indicatorDAO.findById(indicatorId);
        if (indicator == null) throw new EntityNotFoundException("Delete indicator: Indicator with id: " + indicatorId + " not found");
        Section section = this.checkForExceptions(stakeholderId, topicId, categoryId, subcategoryId, sectionId, indicator.getType());
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        List roles = this.rolesUtils.getRoles();
        if (indicator.getDefaultId() != null && !this.rolesUtils.hasCreateAndDeleteAuthority(roles, stakeholder.getType())) {
            throw new ForbiddenException("Delete indicator: You are not authorized to delete a default Indicator in stakeholder with id: " + stakeholderId);
        }
        List indicators = section.getIndicators();
        int index = indicators.indexOf(indicatorId);
        if (index == -1) throw new PathNotValidException("Delete indicator: Indicator with id: " + indicatorId + " not found in Sectiom: " + sectionId);
        if (section.getDefaultId() == null && children != null) {
            this.onDeleteDefaultIndicator(indicatorId, sectionId, children);
        }
        indicators.remove(index);
        this.sectionDAO.save(section);
        this.indicatorDAO.delete(indicatorId);
        this.log.debug((Object)"Indicator deleted!");
        return true;
    }

    public boolean onDeleteDefaultIndicator(String defaultIndicatorId, String defaultSectionId, String children) {
        block4: {
            block3: {
                if (!children.equals("delete")) break block3;
                List sections = this.sectionDAO.findByDefaultId(defaultSectionId);
                List indicators = this.indicatorDAO.findByDefaultId(defaultIndicatorId);
                block0: for (Section section : sections) {
                    Iterator indicatorsIterator = indicators.iterator();
                    while (indicatorsIterator.hasNext()) {
                        String indicatorId = ((Indicator)indicatorsIterator.next()).getId();
                        if (!section.getIndicators().contains(indicatorId)) continue;
                        indicatorsIterator.remove();
                        section.getIndicators().remove(indicatorId);
                        this.sectionDAO.save(section);
                        this.indicatorDAO.delete(indicatorId);
                        this.log.debug((Object)("Indicator with id: " + indicatorId + " deleted!"));
                        continue block0;
                    }
                }
                break block4;
            }
            if (!children.equals("disconnect")) break block4;
            List indicators = this.indicatorDAO.findByDefaultId(defaultIndicatorId);
            for (Indicator indicator : indicators) {
                indicator.setDefaultId(null);
                this.indicatorDAO.save(indicator);
                this.log.debug((Object)("DefaultId for Indicator with id: " + indicator.getId() + " empty!"));
            }
        }
        return true;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/{type}/reorder"}, method={RequestMethod.POST})
    public List<Indicator> reorderIndicators(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @PathVariable(value="type") String type, @RequestBody ReorderEvent reorderEvent) {
        this.log.debug((Object)("reorder indicators of type: " + type));
        this.log.debug((Object)("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId));
        List indicators = reorderEvent.getIds();
        String actionType = reorderEvent.getAction();
        String targetId = reorderEvent.getTarget();
        Section section = this.checkForExceptions(stakeholderId, topicId, categoryId, subcategoryId, sectionId, type);
        List oldIndicators = section.getIndicators();
        for (String indicatorId : oldIndicators) {
            if (actionType.equals("removed") && targetId.equals(indicatorId) || indicators.contains(indicatorId)) continue;
            indicators.add(indicatorId);
        }
        section.setIndicators(indicators);
        ArrayList<Indicator> indicatorsFull = new ArrayList<Indicator>();
        for (String indicatorId : indicators) {
            Indicator indicator = this.indicatorDAO.findById(indicatorId);
            if (indicator == null) {
                throw new EntityNotFoundException("Reorder indicators: Indicator with id: " + indicatorId + " not found");
            }
            indicatorsFull.add(indicator);
        }
        this.sectionDAO.save(section);
        this.log.debug((Object)"Indicators reordered!");
        return indicatorsFull;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/{topicId}/{categoryId}/{subcategoryId}/{sectionId}/{indicatorId}/change-visibility"}, method={RequestMethod.POST})
    public Visibility changeTopicVisibility(@PathVariable(value="stakeholderId") String stakeholderId, @PathVariable(value="topicId") String topicId, @PathVariable(value="categoryId") String categoryId, @PathVariable(value="subcategoryId") String subcategoryId, @PathVariable(value="sectionId") String sectionId, @PathVariable(value="indicatorId") String indicatorId, @RequestParam(value="visibility") Visibility visibility) {
        this.log.debug((Object)("change indicator visibility: " + visibility));
        this.log.debug((Object)("Stakeholder: " + stakeholderId + " - Topic: " + topicId + " - Category: " + categoryId + " - SubCategory: " + subcategoryId + " - Section: " + sectionId + " - Indicator: " + indicatorId));
        Indicator indicator = this.indicatorDAO.findById(indicatorId);
        if (indicator == null) {
            throw new EntityNotFoundException("Change indicator visibility: Indicator with id: " + indicatorId + " not found");
        }
        indicator.setVisibility(visibility);
        this.toggleIndicator(stakeholderId, topicId, categoryId, subcategoryId, sectionId, indicator);
        return indicator.getVisibility();
    }

    public void toggleIndicator(String stakeholderId, String topicId, String categoryId, String subcategoryId, String sectionId, Indicator indicator) {
        Section section = this.checkForExceptions(stakeholderId, topicId, categoryId, subcategoryId, sectionId, indicator.getType());
        List indicators = section.getIndicators();
        if (!indicators.contains(indicator.getId())) {
            throw new PathNotValidException("Toggle indicators: Indicator with id: " + indicator.getId() + " not found in Section: " + sectionId);
        }
        this.indicatorDAO.save(indicator);
        this.log.debug((Object)"Indicator toggled!");
    }

    private Section checkForExceptions(String stakeholderId, String topicId, String categoryId, String subcategoryId, String sectionId, String indicatorType) {
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder == null) {
            throw new EntityNotFoundException("Save indicator: Stakeholder with id: " + stakeholderId + " not found");
        }
        List roles = this.rolesUtils.getRoles();
        if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            throw new ForbiddenException("CheckForExceptions Indicator: You are not authorized to update stakeholder with id: " + stakeholderId);
        }
        Topic topic = this.topicDAO.findById(topicId);
        if (topic == null) {
            throw new EntityNotFoundException("Save indicator: Topic with id: " + topicId + " not found");
        }
        if (!stakeholder.getTopics().contains(topicId)) {
            throw new PathNotValidException("Save indicator: Topic with id: " + topicId + " not found in Stakeholder: " + stakeholderId);
        }
        Category category = this.categoryDAO.findById(categoryId);
        if (category == null) {
            throw new EntityNotFoundException("Save indicator: Category with id: " + categoryId + " not found");
        }
        if (!topic.getCategories().contains(categoryId)) {
            throw new PathNotValidException("Save indicator: Category with id: " + categoryId + " not found in Topic: " + topicId);
        }
        SubCategory subcategory = this.subCategoryDAO.findById(subcategoryId);
        if (subcategory == null) {
            throw new EntityNotFoundException("Save indicator: SubCategory with id: " + subcategoryId + " not found");
        }
        if (!category.getSubCategories().contains(subcategoryId)) {
            throw new PathNotValidException("Save indicator: SubCategory with id: " + subcategoryId + " not found in Category: " + categoryId);
        }
        Section section = this.sectionDAO.findById(sectionId);
        if (section == null) {
            throw new EntityNotFoundException("Save indicator: Section with id: " + sectionId + " not found");
        }
        if (indicatorType.equals("chart") ? !subcategory.getCharts().contains(sectionId) : indicatorType.equals("number") && !subcategory.getNumbers().contains(sectionId)) {
            throw new PathNotValidException("Save indicator: SubCategory with id: " + subcategoryId + " not found in Category: " + categoryId);
        }
        return section;
    }

    public void deleteTree(Section section) {
        List indicators = section.getIndicators();
        for (String indicatorId : indicators) {
            this.indicatorDAO.delete(indicatorId);
        }
    }

    public void disConnectTree(Section section) {
        List indicators = section.getIndicators();
        for (String indicatorId : indicators) {
            Indicator indicator = this.indicatorDAO.findById(indicatorId);
            indicator.setDefaultId(null);
            this.indicatorDAO.save(indicator);
        }
    }
}

