/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import eu.dnetlib.uoamonitorservice.configuration.GlobalVars;
import eu.dnetlib.uoamonitorservice.configuration.mongo.MongoConnection;
import eu.dnetlib.uoamonitorservice.configuration.properties.MongoConfig;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class MonitorServiceCheckDeployController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private MongoConnection mongoConnection;
    @Autowired
    private MongoConfig mongoConfig;
    @Autowired
    private GlobalVars globalVars;

    @RequestMapping(value={"", "/health_check"}, method={RequestMethod.GET})
    public String hello() {
        this.log.debug((Object)"Hello from uoa-monitor-service!");
        return "Hello from uoa-monitor-service!";
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/health_check/advanced"}, method={RequestMethod.GET})
    public Map<String, String> checkEverything() {
        HashMap<String, String> response = new HashMap<String, String>();
        MongoTemplate mt = this.mongoConnection.getMongoTemplate();
        BasicDBObject ping = new BasicDBObject("ping", (Object)"1");
        try {
            CommandResult answer = mt.getDb().command((DBObject)ping);
            response.put("Mongo try: error", answer.getErrorMessage());
        }
        catch (Exception e) {
            response.put("Mongo catch: error", e.getMessage());
        }
        response.put("monitorservice.mongodb.database", this.mongoConfig.getDatabase());
        response.put("monitorservice.mongodb.host", this.mongoConfig.getHost());
        response.put("monitorservice.mongodb.port", this.mongoConfig.getPort() + "");
        response.put("monitorservice.mongodb.username", this.mongoConfig.getUsername() == null ? null : "[unexposed value]");
        response.put("monitorservice.mongodb.password", this.mongoConfig.getPassword() == null ? null : "[unexposed value]");
        if (GlobalVars.date != null) {
            response.put("Date of deploy", GlobalVars.date.toString());
        }
        if (this.globalVars.getBuildDate() != null) {
            response.put("Date of build", this.globalVars.getBuildDate());
        }
        return response;
    }
}

