package eu.dnetlib.uoamonitorservice;

import eu.dnetlib.uoaauthorizationlibrary.configuration.AuthorizationConfiguration;
import eu.dnetlib.uoamonitorservice.configuration.GlobalVars;
import eu.dnetlib.uoamonitorservice.configuration.properties.MongoConfig;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
//uoahelptexts
@SpringBootApplication(scanBasePackages = {"eu.dnetlib.uoamonitorservice", "eu.dnetlib.uoaadmintoolslibrary", "eu.dnetlib.uoanotificationservice"
//        , "eu.dnetlib.uoaauthorizationlibrary"
})
@PropertySources({
        @PropertySource("classpath:authorization.properties"),
        @PropertySource("classpath:admintoolslibrary.properties"),
        @PropertySource("classpath:notification.properties"),
        @PropertySource("classpath:monitorservice.properties"),
        @PropertySource(value = "classpath:dnet-override.properties", ignoreResourceNotFound = true)
})

//SecurityConfig.class,
@EnableConfigurationProperties({ MongoConfig.class, GlobalVars.class})

@Import(AuthorizationConfiguration.class)
public class UoaMonitorServiceApplication {
    public static void main(String[] args) {
        SpringApplication.run(UoaMonitorServiceApplication.class, args);
    }
}
