/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.emailSender.EmailSender;
import eu.dnetlib.uoaadmintoolslibrary.entities.email.Email;
import eu.dnetlib.uoaadmintoolslibrary.entities.email.EmailRecaptcha;
import eu.dnetlib.uoaadmintoolslibrary.handlers.InvalidReCaptchaException;
import eu.dnetlib.uoaadmintoolslibrary.recaptcha.VerifyRecaptcha;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class EmailController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private EmailSender emailSender;
    @Autowired
    private VerifyRecaptcha verifyRecaptcha;

    @RequestMapping(value={"/contact"}, method={RequestMethod.POST})
    public Boolean contact(@RequestBody EmailRecaptcha form) throws InvalidReCaptchaException {
        this.verifyRecaptcha.processResponse(form.getRecaptcha());
        Email email = form.getEmail();
        ArrayList<String> sendTo = new ArrayList<String>();
        for (String userMail : email.getRecipients()) {
            sendTo.add(userMail);
        }
        return this.emailSender.send(sendTo, email.getSubject(), email.getBody(), Boolean.valueOf(false));
    }

    @RequestMapping(value={"/sendMail"}, method={RequestMethod.POST})
    public Map<String, ArrayList<String>> sendEmail(@RequestBody Email email, @RequestParam(required=false) Optional<Boolean> optional) {
        String successString = "success";
        String failureString = "failure";
        HashMap<String, ArrayList<String>> mailResults = new HashMap<String, ArrayList<String>>();
        boolean bcc = optional.isPresent() ? optional.get() : true;
        for (String userMail : email.getRecipients()) {
            ArrayList<String> sendTo = new ArrayList<String>();
            sendTo.add(userMail);
            boolean success = this.emailSender.send(sendTo, email.getSubject(), email.getBody(), Boolean.valueOf(bcc));
            if (success) {
                if (!mailResults.containsKey(successString)) {
                    mailResults.put(successString, new ArrayList());
                }
                ((ArrayList)mailResults.get(successString)).add(userMail);
                continue;
            }
            if (!mailResults.containsKey(failureString)) {
                mailResults.put(failureString, new ArrayList());
            }
            ((ArrayList)mailResults.get(failureString)).add(userMail);
        }
        return mailResults;
    }
}

