/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.controllers;

import eu.dnetlib.uoaadmintoolslibrary.handlers.ForbiddenException;
import eu.dnetlib.uoaadmintoolslibrary.handlers.utils.RolesUtils;
import eu.dnetlib.uoamonitorservice.controllers.TopicController;
import eu.dnetlib.uoamonitorservice.dao.CategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.IndicatorDAO;
import eu.dnetlib.uoamonitorservice.dao.SectionDAO;
import eu.dnetlib.uoamonitorservice.dao.StakeholderDAO;
import eu.dnetlib.uoamonitorservice.dao.SubCategoryDAO;
import eu.dnetlib.uoamonitorservice.dao.TopicDAO;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Indicator;
import eu.dnetlib.uoamonitorservice.entities.Section;
import eu.dnetlib.uoamonitorservice.entities.Stakeholder;
import eu.dnetlib.uoamonitorservice.entities.SubCategory;
import eu.dnetlib.uoamonitorservice.entities.Topic;
import eu.dnetlib.uoamonitorservice.entities.Visibility;
import eu.dnetlib.uoamonitorservice.handlers.EntityNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
public class StakeholderController {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private RolesUtils rolesUtils;
    @Autowired
    private StakeholderDAO stakeholderDAO;
    @Autowired
    private TopicDAO topicDAO;
    @Autowired
    private CategoryDAO categoryDAO;
    @Autowired
    private SubCategoryDAO subCategoryDAO;
    @Autowired
    private SectionDAO sectionDAO;
    @Autowired
    private IndicatorDAO indicatorDAO;
    @Autowired
    private TopicController topicController;

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/stakeholder/alias"}, method={RequestMethod.GET})
    public List<String> getAllReservedStakeholderAlias() {
        ArrayList<String> stakeholderAlias = new ArrayList<String>();
        List stakeholders = this.stakeholderDAO.findAll();
        if (stakeholders != null) {
            stakeholders.forEach(stakeholder -> stakeholderAlias.add(stakeholder.getAlias()));
        }
        stakeholderAlias.add("all");
        stakeholderAlias.add("default");
        stakeholderAlias.add("alias");
        return stakeholderAlias;
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#stakeholderFull.getType()))")
    @RequestMapping(value={"/build-stakeholder"}, method={RequestMethod.POST})
    public Stakeholder<Topic<Category<SubCategory<Section<Indicator>>>>> buildFullStakeholder(@RequestBody Stakeholder<Topic<Category<SubCategory<Section<Indicator>>>>> stakeholderFull) {
        this.log.debug((Object)"build stakeholder");
        this.log.debug((Object)("Alias: " + stakeholderFull.getAlias()));
        Stakeholder stakeholder = new Stakeholder(stakeholderFull);
        ArrayList<String> topics = new ArrayList<String>();
        ArrayList<Topic> topicsFull = new ArrayList<Topic>();
        for (Topic topic : stakeholderFull.getTopics()) {
            Topic topicFull = this.topicController.buildTopic(topic);
            topicsFull.add(topicFull);
            topics.add(topicFull.getId());
        }
        stakeholderFull.setTopics(topicsFull);
        stakeholder.setTopics(topics);
        Date date = new Date();
        stakeholder.setCreationDate(date);
        stakeholder.setUpdateDate(date);
        stakeholderFull.setCreationDate(date);
        stakeholderFull.setUpdateDate(date);
        Stakeholder stakeholderSaved = this.stakeholderDAO.save(stakeholder);
        stakeholderFull.setId(stakeholderSaved.getId());
        return stakeholderFull;
    }

    public Stakeholder setFullEntities(Stakeholder<String> stakeholder, List<String> roles) {
        boolean addAll = false;
        boolean addPublicAndRestricted = false;
        if (this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            addAll = true;
            addPublicAndRestricted = true;
        } else if (this.rolesUtils.isMember(roles, stakeholder.getType(), stakeholder.getAlias())) {
            addPublicAndRestricted = true;
        }
        Stakeholder stakeholderFull = new Stakeholder(stakeholder);
        ArrayList<Topic> topics = new ArrayList<Topic>();
        for (String topicId : stakeholder.getTopics()) {
            Topic topic = this.topicDAO.findById(topicId);
            if (topic == null) {
                throw new EntityNotFoundException("Get stakeholder: Topic with id: " + topicId + " not found (topic exists in stakeholder: " + stakeholder.getId() + ")");
            }
            if (!addAll && topic.getVisibility() == Visibility.PRIVATE || !addPublicAndRestricted && topic.getVisibility() == Visibility.RESTRICTED) continue;
            Topic topicFull = new Topic(topic);
            ArrayList<Category> categories = new ArrayList<Category>();
            for (String categoryId : topic.getCategories()) {
                Category category = this.categoryDAO.findById(categoryId);
                if (category == null) {
                    throw new EntityNotFoundException("Get stakeholder: Category with id: " + categoryId + " not found (category exists in topic: " + topicId + ")");
                }
                if (!addAll && category.getVisibility() == Visibility.PRIVATE || !addPublicAndRestricted && category.getVisibility() == Visibility.RESTRICTED) continue;
                Category categoryFull = new Category(category);
                ArrayList<SubCategory> subCategories = new ArrayList<SubCategory>();
                for (String subCategoryId : category.getSubCategories()) {
                    SubCategory subCategory = this.subCategoryDAO.findById(subCategoryId);
                    if (subCategory == null) {
                        throw new EntityNotFoundException("Get stakeholder: SubCategory with id: " + subCategoryId + " not found (subCategory exists in category: " + categoryId + ")");
                    }
                    if (!addAll && subCategory.getVisibility() == Visibility.PRIVATE || !addPublicAndRestricted && subCategory.getVisibility() == Visibility.RESTRICTED) continue;
                    SubCategory subCategoryFull = new SubCategory(subCategory);
                    ArrayList<Section> sectionsCharts = new ArrayList<Section>();
                    for (String sectionId : subCategory.getCharts()) {
                        sectionsCharts.add(this.getSectionFull(sectionId, subCategoryId, addAll, addPublicAndRestricted));
                    }
                    subCategoryFull.setCharts(sectionsCharts);
                    ArrayList<Section> sectionsNumbers = new ArrayList<Section>();
                    for (String sectionId : subCategory.getNumbers()) {
                        sectionsNumbers.add(this.getSectionFull(sectionId, subCategoryId, addAll, addPublicAndRestricted));
                    }
                    subCategoryFull.setNumbers(sectionsNumbers);
                    subCategories.add(subCategoryFull);
                }
                categoryFull.setSubCategories(subCategories);
                categories.add(categoryFull);
            }
            topicFull.setCategories(categories);
            topics.add(topicFull);
        }
        stakeholderFull.setTopics(topics);
        return stakeholderFull;
    }

    private Section getSectionFull(String sectionId, String subCategoryId, boolean addAll, boolean addPublicAndRestricted) {
        Section section = this.sectionDAO.findById(sectionId);
        if (section == null) {
            throw new EntityNotFoundException("Get stakeholder: Section with id: " + sectionId + " not found (section exists in subCategory: " + subCategoryId + ")");
        }
        Section sectionFull = new Section(section);
        ArrayList<Indicator> indicators = new ArrayList<Indicator>();
        for (String indicatorId : section.getIndicators()) {
            Indicator indicator = this.indicatorDAO.findById(indicatorId);
            if (indicator == null) {
                throw new EntityNotFoundException("Get stakeholder: Indicator with id: " + indicatorId + " not found (indicator exists in section: " + sectionId + ")");
            }
            if (!addAll && indicator.getVisibility() == Visibility.PRIVATE || !addPublicAndRestricted && indicator.getVisibility() == Visibility.RESTRICTED) continue;
            indicators.add(indicator);
        }
        sectionFull.setIndicators(indicators);
        return sectionFull;
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN)")
    @RequestMapping(value={"/stakeholder/all"}, method={RequestMethod.GET})
    public List<Stakeholder> getAllStakeholders(@RequestParam(required=false) String type) {
        List stakeholders = type == null ? this.stakeholderDAO.findAll() : this.stakeholderDAO.findByType(type);
        ArrayList<Stakeholder> stakeholdersFull = new ArrayList<Stakeholder>();
        for (Stakeholder stakeholder : stakeholders) {
            List roles = this.rolesUtils.getRoles();
            stakeholdersFull.add(this.setFullEntities(stakeholder, roles));
        }
        return stakeholdersFull;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/stakeholder/default"}, method={RequestMethod.GET})
    public List<Stakeholder> getAllDefaultStakeholders(@RequestParam(required=false) String type) {
        List stakeholders = type == null ? this.stakeholderDAO.findByDefaultId(null) : this.stakeholderDAO.findByDefaultIdAndType(null, type);
        ArrayList<Stakeholder> stakeholdersFull = new ArrayList<Stakeholder>();
        if (stakeholders != null && stakeholders.size() > 0) {
            List roles = this.rolesUtils.getRoles();
            if (this.rolesUtils.isPortalAdmin(roles)) {
                for (Stakeholder stakeholder : stakeholders) {
                    stakeholdersFull.add(this.setFullEntities(stakeholder, roles));
                }
                return stakeholdersFull;
            }
            Iterator stakeholderIterator = stakeholders.iterator();
            while (stakeholderIterator.hasNext()) {
                Stakeholder stakeholder = (Stakeholder)stakeholderIterator.next();
                if (this.rolesUtils.isCurator(roles, stakeholder.getType())) {
                    stakeholdersFull.add(this.setFullEntities(stakeholder, roles));
                    continue;
                }
                stakeholderIterator.remove();
            }
        }
        return stakeholdersFull;
    }

    @RequestMapping(value={"/stakeholder"}, method={RequestMethod.GET})
    public List<Stakeholder> getAllRealStakeholders(@RequestParam(required=false) String type, @RequestParam(required=false) String defaultId) {
        List stakeholders = type != null && defaultId != null ? this.stakeholderDAO.findByDefaultIdAndType(defaultId, type) : (defaultId != null ? this.stakeholderDAO.findByDefaultId(defaultId) : (type != null ? this.stakeholderDAO.findByDefaultIdNotAndType(null, type) : this.stakeholderDAO.findByDefaultIdNot(null)));
        if (stakeholders != null && stakeholders.size() > 0) {
            List roles = this.rolesUtils.getRoles();
            if (this.rolesUtils.isPortalAdmin(roles)) {
                return stakeholders;
            }
            Iterator stakeholderIterator = stakeholders.iterator();
            while (stakeholderIterator.hasNext()) {
                Stakeholder stakeholder = (Stakeholder)stakeholderIterator.next();
                if (this.rolesUtils.isCurator(roles, stakeholder.getType()) || this.rolesUtils.isManager(roles, stakeholder.getType(), stakeholder.getAlias()) || stakeholder.getVisibility() == Visibility.PUBLIC || stakeholder.getVisibility() == Visibility.RESTRICTED) continue;
                stakeholderIterator.remove();
            }
        }
        return stakeholders;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/my-stakeholder"}, method={RequestMethod.GET})
    public List<Stakeholder> getMyRealStakeholders(@RequestParam(required=false) String type) {
        List stakeholders = type == null ? this.stakeholderDAO.findByDefaultIdNot(null) : this.stakeholderDAO.findByDefaultIdNotAndType(null, type);
        ArrayList stakeholdersFull = new ArrayList();
        if (stakeholders != null && stakeholders.size() > 0) {
            List roles = this.rolesUtils.getRoles();
            if (this.rolesUtils.isPortalAdmin(roles)) {
                return stakeholders;
            }
            Iterator stakeholderIterator = stakeholders.iterator();
            while (stakeholderIterator.hasNext()) {
                Stakeholder stakeholder = (Stakeholder)stakeholderIterator.next();
                if (this.rolesUtils.isCurator(roles, stakeholder.getType()) || this.rolesUtils.isManager(roles, stakeholder.getType(), stakeholder.getAlias())) continue;
                stakeholderIterator.remove();
            }
        }
        return stakeholders;
    }

    @RequestMapping(value={"/stakeholder/{alias}"}, method={RequestMethod.GET})
    public Stakeholder getStakeholder(@PathVariable(value="alias") String alias) {
        Stakeholder stakeholder = this.stakeholderDAO.findByAlias(alias);
        if (stakeholder == null) {
            throw new EntityNotFoundException("Get stakeholder: Stakeholder with alias: " + alias + " not found");
        }
        List roles = this.rolesUtils.getRoles();
        if (stakeholder.getDefaultId() == null && !this.rolesUtils.isLoggedIn(roles)) {
            throw new AccessDeniedException("Get stakeholder: You are not authorized (not logged in) to access stakeholder with alias: " + alias);
        }
        if (stakeholder.getDefaultId() == null && !this.rolesUtils.hasCreateAndDeleteAuthority(roles, stakeholder.getType())) {
            throw new ForbiddenException("Get stakeholder: You are not authorized to access stakeholder with alias: " + alias);
        }
        if (stakeholder.getVisibility() == Visibility.PRIVATE && !this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias()) || stakeholder.getVisibility() == Visibility.RESTRICTED && !this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias()) && !this.rolesUtils.isMember(roles, stakeholder.getType(), stakeholder.getAlias())) {
            List topicsEmpty = stakeholder.getTopics();
            topicsEmpty.clear();
            stakeholder.setTopics(topicsEmpty);
            stakeholder.setVisibility(Visibility.PRIVATE);
            return stakeholder;
        }
        return this.setFullEntities(stakeholder, roles);
    }

    @PreAuthorize(value="hasAnyAuthority(@AuthorizationService.PORTAL_ADMIN, @AuthorizationService.curator(#_stakeholder.getType()), @AuthorizationService.manager(#_stakeholder.getType(), #_stakeholder.getAlias()) )")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public Stakeholder saveStakeholder(@RequestBody Stakeholder _stakeholder) {
        this.log.debug((Object)"save stakeholder");
        this.log.debug((Object)("Alias: " + _stakeholder.getAlias() + " - Id: " + _stakeholder.getId()));
        Stakeholder stakeholder = new Stakeholder(_stakeholder);
        Date date = new Date();
        stakeholder.setUpdateDate(date);
        ArrayList<String> topics = new ArrayList<String>();
        if (_stakeholder.getId() == null) {
            stakeholder.setCreationDate(date);
        } else {
            Stakeholder oldStakeholder = this.stakeholderDAO.findById(_stakeholder.getId());
            if (oldStakeholder == null) {
                throw new EntityNotFoundException("save stakeholder: Stakeholder with id: " + _stakeholder.getId() + " not found");
            }
            for (String topicId : oldStakeholder.getTopics()) {
                Topic topic = this.topicDAO.findById(topicId);
                if (topic == null) {
                    throw new EntityNotFoundException("Save stakeholder: Topic with id: " + topicId + " not found (topic exists in stakeholder: " + stakeholder.getId() + ")");
                }
                topics.add(topic.getId());
            }
        }
        stakeholder.setTopics(topics);
        Stakeholder stakeholderSaved = this.stakeholderDAO.save(stakeholder);
        _stakeholder.setId(stakeholderSaved.getId());
        _stakeholder.setCreationDate(stakeholderSaved.getCreationDate());
        _stakeholder.setUpdateDate(stakeholderSaved.getUpdateDate());
        topics = null;
        stakeholder = null;
        stakeholderSaved = null;
        return _stakeholder;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/delete"}, method={RequestMethod.DELETE})
    public boolean deleteStakeholder(@PathVariable(value="stakeholderId") String stakeholderId) {
        this.log.debug((Object)"delete stakeholder");
        this.log.debug((Object)("Id: " + stakeholderId));
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder != null) {
            List roles = this.rolesUtils.getRoles();
            if (!this.rolesUtils.hasCreateAndDeleteAuthority(roles, stakeholder.getType())) {
                throw new ForbiddenException("Delete stakeholder: You are not authorized to delete stakeholder with id: " + stakeholderId);
            }
        } else {
            throw new EntityNotFoundException("Delete stakeholder: Stakeholder with id: " + stakeholderId + " not found");
        }
        this.topicController.deleteTree(stakeholder);
        stakeholder.setTopics(null);
        this.stakeholderDAO.delete(stakeholderId);
        this.log.debug((Object)"Stakeholder deleted!");
        return true;
    }

    @PreAuthorize(value="isAuthenticated()")
    @RequestMapping(value={"/{stakeholderId}/change-visibility"}, method={RequestMethod.POST})
    public Visibility toggleStakeholderAccess(@PathVariable(value="stakeholderId") String stakeholderId, @RequestParam(value="visibility") Visibility visibility) {
        this.log.debug((Object)("change stakeholder visibility: " + visibility));
        this.log.debug((Object)("Stakeholder: " + stakeholderId));
        Stakeholder stakeholder = this.stakeholderDAO.findById(stakeholderId);
        if (stakeholder == null) {
            throw new EntityNotFoundException("Change stakeholder visibility: Stakeholder with id: " + stakeholderId + " not found");
        }
        List roles = this.rolesUtils.getRoles();
        if (!this.rolesUtils.hasUpdateAuthority(roles, stakeholder.getType(), stakeholder.getAlias())) {
            throw new ForbiddenException("Change stakeholder visibility: You are not authorized to update stakeholder with id: " + stakeholderId);
        }
        stakeholder.setVisibility(visibility);
        this.stakeholderDAO.save(stakeholder);
        this.log.debug((Object)"Stakeholder toggled!");
        return stakeholder.getVisibility();
    }
}

