package eu.dnetlib.uoamonitorservice.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.data.annotation.Id;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

enum SectionType {
    // Do not rename or remove existring values. This may cause problems with already stored values in DB
    number, chart,
    NUMBER, CHART;
}

public class Section<StringOrIndicator> {
    @Id
    @JsonProperty("_id")
    private String id;

    private String title;
    private String defaultId;
    private String stakeholderAlias;
    private SectionType type;
    private Date creationDate;
    private Date updateDate;
    private List<StringOrIndicator> indicators;

    public Section() {}

    public Section(Section section) {
        id = section.getId();
        title = section.getTitle();
        defaultId = section.getDefaultId();
        stakeholderAlias = section.getStakeholderAlias();
        setType(section.getType());
        creationDate = section.getCreationDate();
        updateDate = section.getUpdateDate();
    }

    public void copyFromDefault(Section defaultSection) {
        setTitle(defaultSection.getTitle());
        setType(defaultSection.getType());
        setDefaultId(defaultSection.id);
        setCreationDate(defaultSection.getCreationDate());
        setUpdateDate(defaultSection.getUpdateDate());
        setIndicators(new ArrayList<>());
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDefaultId() {
        return defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public String getStakeholderAlias() {
        return stakeholderAlias;
    }

    public void setStakeholderAlias(String stakeholderAlias) {
        this.stakeholderAlias = stakeholderAlias;
    }

    public String getType() {
        if(type == null) {
            return null;
        }
        return type.name();
    }

    public void setType(String type) {
        if(type == null) {
            this.type = null;
        } else {
            SectionType sectionType = SectionType.valueOf(type);
            this.type = sectionType;
        }
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public List<StringOrIndicator> getIndicators() {
        return indicators;
    }

    public void setIndicators(List<StringOrIndicator> indicators) {
        this.indicators = indicators;
    }
}
