package eu.dnetlib.uoamonitorservice.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.data.annotation.Id;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Topic<StringOrCategory> {
    @Id
    @JsonProperty("_id")
    private String id;

    private String name;
    private String alias;
    private String description;
    private String icon;
    private Visibility visibility = Visibility.PRIVATE;
    private Date creationDate;
    private Date updateDate;
    private String defaultId;
    private List<StringOrCategory> categories;

    public Topic() {}
    public Topic(Topic topic) {
        id = topic.getId();
        name = topic.getName();
        alias = topic.getAlias();
        description = topic.getDescription();
        icon = topic.getIcon();
        setVisibility(topic.getVisibility());
        creationDate = topic.getCreationDate();
        updateDate = topic.getUpdateDate();
        defaultId = topic.getDefaultId();
    }

    public void copyFromDefault(Topic defaultTopic) {
        setName(defaultTopic.getName());
        setAlias(defaultTopic.getAlias());
        setDescription(defaultTopic.getDescription());
        setIcon(defaultTopic.getIcon());
        setVisibility(defaultTopic.getVisibility());
        setCreationDate(defaultTopic.getCreationDate());
        setUpdateDate(defaultTopic.getUpdateDate());
        setDefaultId(defaultTopic.getId());
        setCategories(new ArrayList());
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Visibility getVisibility() {
        return visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getDefaultId() {
        return defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public List<StringOrCategory> getCategories() {
        return categories;
    }

    public void setCategories(List<StringOrCategory> categories) {
        this.categories = categories;
    }
}
