/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.uoamonitorservice.entities.Category;
import eu.dnetlib.uoamonitorservice.entities.Visibility;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.data.annotation.Id;

public class SubCategory<StringOrSection> {
    @Id
    @JsonProperty(value="_id")
    private String id;
    private String name;
    private String alias;
    private String description;
    private Visibility visibility = Visibility.PRIVATE;
    private Date creationDate;
    private Date updateDate;
    private String defaultId;
    private List<StringOrSection> charts;
    private List<StringOrSection> numbers;

    public SubCategory() {
    }

    public SubCategory(SubCategory subCategory) {
        this.id = subCategory.getId();
        this.name = subCategory.getName();
        this.alias = subCategory.getAlias();
        this.description = subCategory.getDescription();
        this.setVisibility(subCategory.getVisibility());
        this.creationDate = subCategory.getCreationDate();
        this.updateDate = subCategory.getUpdateDate();
        this.defaultId = subCategory.getDefaultId();
    }

    public void createOverviewSubCategory(Category category) {
        this.setName("Overview");
        this.setAlias("overview");
        this.setVisibility(category.getVisibility());
        this.setCreationDate(category.getCreationDate());
        this.setUpdateDate(category.getUpdateDate());
        this.setCharts(new ArrayList());
        this.setNumbers(new ArrayList());
    }

    public void copyFromDefault(SubCategory defaultSubCategory) {
        this.setName(defaultSubCategory.getName());
        this.setAlias(defaultSubCategory.getAlias());
        this.setDescription(defaultSubCategory.getDescription());
        this.setVisibility(defaultSubCategory.getVisibility());
        this.setCreationDate(defaultSubCategory.getCreationDate());
        this.setUpdateDate(defaultSubCategory.getUpdateDate());
        this.setDefaultId(defaultSubCategory.getId());
        this.setCharts(new ArrayList());
        this.setNumbers(new ArrayList());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getDefaultId() {
        return this.defaultId;
    }

    public void setDefaultId(String defaultId) {
        this.defaultId = defaultId;
    }

    public List<StringOrSection> getCharts() {
        return this.charts;
    }

    public void setCharts(List<StringOrSection> charts) {
        this.charts = charts;
    }

    public List<StringOrSection> getNumbers() {
        return this.numbers;
    }

    public void setNumbers(List<StringOrSection> numbers) {
        this.numbers = numbers;
    }
}

