package eu.dnetlib.uoamonitorservice.controllers;

//import eu.dnetlib.uoahelptexts.emailSender.EmailSender;
//import eu.dnetlib.uoahelptexts.entities.EmailRecaptcha;
//import eu.dnetlib.uoahelptexts.entities.Email;
//import eu.dnetlib.uoahelptexts.handlers.InvalidReCaptchaException;
//import eu.dnetlib.uoahelptexts.recaptcha.VerifyRecaptcha;
import eu.dnetlib.uoaadmintoolslibrary.emailSender.EmailSender;
import eu.dnetlib.uoaadmintoolslibrary.entities.email.Email;
import eu.dnetlib.uoaadmintoolslibrary.entities.email.EmailRecaptcha;
import eu.dnetlib.uoaadmintoolslibrary.handlers.InvalidReCaptchaException;
import eu.dnetlib.uoaadmintoolslibrary.recaptcha.VerifyRecaptcha;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.*;

@RestController
@CrossOrigin(origins = "*")
public class EmailController {
    private final Logger log = Logger.getLogger(this.getClass());

    @Autowired
    private EmailSender emailSender;

    @Autowired
    private VerifyRecaptcha verifyRecaptcha;

    @RequestMapping(value = "/contact", method = RequestMethod.POST)
    public Boolean contact(@RequestBody EmailRecaptcha form)  throws InvalidReCaptchaException {
        verifyRecaptcha.processResponse(form.getRecaptcha());
        Email email = form.getEmail();
        ArrayList<String> sendTo = new ArrayList<>();
        for(String userMail: email.getRecipients()){
            sendTo.add(userMail);
        }
        return emailSender.send(sendTo, email.getSubject(), email.getBody(), false);
    }

    @RequestMapping(value = "/sendMail", method = RequestMethod.POST)
    public Map<String, ArrayList<String>> sendEmail(@RequestBody Email email,
                                                    @RequestParam(required = false) Optional<Boolean> optional) {
        String successString = "success";
        String failureString = "failure";
        Map<String, ArrayList<String>> mailResults = new HashMap<>();
        boolean bcc = (optional.isPresent())?optional.get():true;
        for(String userMail:email.getRecipients()){
            ArrayList<String> sendTo = new ArrayList<>();
            sendTo.add(userMail);
            boolean success =emailSender.send(sendTo,email.getSubject(),email.getBody(), bcc);
            if(success){
                if(!mailResults.containsKey(successString)) {
                    mailResults.put(successString, new ArrayList<>());
                }
                mailResults.get(successString).add(userMail);
            } else {
                if(!mailResults.containsKey(failureString)) {
                    mailResults.put(failureString, new ArrayList<>());
                }
                mailResults.get(failureString).add(userMail);
            }
        }
        return mailResults;

    }

}